/***************************************************************************
                          amphetadeskinport.cpp  -  description
                             -------------------
    begin                : Thu Oct 18 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "amphetadeskinport.h"

#include <qlayout.h>
#include <qtoolbutton.h>
#include <qprogressbar.h>
#include <qgroupbox.h>

#include <klocale.h>
#include <kcombobox.h>
#include <kstddirs.h>
#include <kio/job.h>
#include <kio/jobclasses.h>
#include <kio/netaccess.h>
#include <kfiledialog.h>
#include <kapp.h>
#include <klistbox.h>
#include <kglobal.h>
#include <kconfig.h>

#include <iostream>

#include "sitehandler.h"


AmphetaDeskInport::AmphetaDeskInport(KApplication *app, SiteHandler *sitehandler, QWidget *parent, const char *name )
: KDialogBase(parent,name,true,i18n("Import Sites from AmphetaDesk"),Details|User1|Close,Close,true,i18n("Import")), QXmlDefaultHandler()
{
	mApp = app;
	mSites = sitehandler;
	
	QWidget *mwid = new QWidget(this);
	QVBoxLayout *mlay = new QVBoxLayout(mwid, 11, 6);
	//QWidget *mwid = new QWidget(this);
	//QVBoxLayout *mlay = new QVBoxLayout(mwid, 11, 6);
	
	QFrame * mFrame = new QFrame(mwid);
	QVBoxLayout *flay = new QVBoxLayout(mFrame, 11, 6);
	
	QWidget *twid = new QWidget(mFrame);
	QHBoxLayout *tlay = new QHBoxLayout(twid, 11 ,6);
	
	mLocation = new KComboBox(twid, "mLocation");
 	KConfig * config = KGlobal::config();
  if(config) {
    config->setGroup(QString("General"));
    QStringList urls = config->readListEntry(QString("AmphetaDesk URLs"), ',');
    if(urls.isEmpty()) {
      mLocation->insertItem(QString("http://www.disobey.com/amphetadesk/service-channels-complete.xml"));
			mLocation->insertItem(QString("http://www.disobey.com/amphetadesk/service-channels-recent.xml"));
			mLocation->insertItem(QString("file:") + KStandardDirs::kde_default("data") + QString("apps/krss/amphetadesk.xml"));
   	}
		else {
    	for(QStringList::Iterator it = urls.begin(); it != urls.end(); ++it) {
       	mLocation->insertItem(QString((*it)));
      }
    }
  }
  else {
  	mLocation->insertItem(QString("http://www.disobey.com/amphetadesk/service-channels-complete.xml"));
		mLocation->insertItem(QString("http://www.disobey.com/amphetadesk/service-channels-recent.xml"));
		mLocation->insertItem(QString("file:") + KStandardDirs::kde_default("data") + QString("apps/krss/amphetadesk.xml"));
 	}
	//mLocation->setCurrentItem(0);
	mLocation->setEditable(true);
	
	mBrowse = new QToolButton(twid, "mBrowse");
	mBrowse->setText(QString("..."));
	connect(mBrowse, SIGNAL(clicked()), this, SLOT(slotBrowse()));
	
	tlay->addWidget(mLocation);
	tlay->addWidget(mBrowse);
	
	flay->addWidget(twid);
	
	mProgress = new QProgressBar(100, mFrame, "mProgress");
	
	flay->addWidget(mProgress);
	
	QGroupBox * mDetailsGroup = new QGroupBox(0, "mDetailsGroup");
	mDetailsGroup->setTitle(i18n("Details"));
	QHBoxLayout *dlay = new QHBoxLayout(mDetailsGroup, 11 ,6);
	mDetails = new KListBox(mDetailsGroup, "mDetails");
	mDetails->setMinimumHeight(150);
	dlay->addWidget(mDetails);
	
	mlay->addWidget(mFrame);
	//mlay->addWidget(mDetailsGroup);
		
	setMainWidget(mwid);
	setDetailsWidget(mDetailsGroup);
}

AmphetaDeskInport::~AmphetaDeskInport()
{
	KConfig *config = KGlobal::config();
 	if(!config)
  	return;

  config->setGroup(QString("General"));
  QStringList urls;
  cout << "Saving " << mLocation->count() << " recently used imports" << endl;
  for(int i=0; i<mLocation->count(); i++)
  	urls.append(mLocation->text(i));
  config->writeEntry(QString("AmphetaDesk URLs"), urls, ',');
}

bool AmphetaDeskInport::startDocument()
{
	cerr << "Starting Doc..." << endl;
	mDetails->insertItem(i18n("Importing..."));
	mReadingService = mReadingTitle = mReadingDescription = mReadingURL = mReadingEntries = false;
	mTitle = mDescription = mURL = QString::null;
	return true;
	
}
bool AmphetaDeskInport::endDocument()
{
	cerr << "All done." << endl;
	mDetails->insertItem(i18n("All Done."));
	return true;
}

bool AmphetaDeskInport::startElement(const QString &, const QString &, const QString & qName, const QXmlAttributes &)
{
	if(qName.compare(QString("service")) == 0)
		mReadingService = true;
	else if(qName.compare(QString("title")) == 0)
		mReadingTitle = true;
	else if(qName.compare(QString("description")) == 0)
		mReadingDescription = true;
	else if(qName.compare(QString("xmlurl")) == 0)
		mReadingURL = true;
	else if(qName.compare(QString("entries")) == 0)
		mReadingEntries = true;
		
	return true;
}

bool AmphetaDeskInport::endElement(const QString &, const QString &, const QString & qName)
{
	if(qName.compare(QString("service")) == 0) {
		addSite();
		mReadingService = false;
	}
	else if(qName.compare(QString("title")) == 0)
		mReadingTitle = false;
	else if(qName.compare(QString("description")) == 0)
		mReadingDescription = false;
	else if(qName.compare(QString("xmlurl")) == 0)
		mReadingURL = false;
	else if(qName.compare(QString("entries")) == 0)
		mReadingEntries = false;
		
	return true;
}

bool AmphetaDeskInport::characters(const QString & ch)
{
	if(mReadingService) {
		if(mReadingTitle)
			mTitle = ch;
		else if(mReadingURL)
			mURL = ch;
		else if(mReadingDescription)
			mDescription = ch;
  }
	else if(mReadingEntries) {
		mEntries = ch.toInt();
		mHaveEntries = 0;
		mProgress->reset();
		cerr << "Total Number of Entries: " << mEntries << endl;
		mDetails->insertItem(i18n("Adding ") + ch + i18n(" Sites..."));
	}

	return true;
}

bool AmphetaDeskInport::warning(const QXmlParseException & e)
{
	mDetails->insertItem(i18n("WARNING (") + QString::number(e.lineNumber()) + QString(",") + QString::number(e.columnNumber()) + QString("): ") + e.message());
	return true;
}

bool AmphetaDeskInport::error(const QXmlParseException & e)
{
	mDetails->insertItem(i18n("ERROR (") + QString::number(e.lineNumber()) + QString(",") + QString::number(e.columnNumber()) + QString("): ") + e.message());
	return true;
}

bool AmphetaDeskInport::fatalError(const QXmlParseException & e)
{
	mDetails->insertItem(i18n("FATAL ERROR (") + QString::number(e.lineNumber()) + QString(",") + QString::number(e.columnNumber()) + QString("): ") + e.message());
	return true;
}

void AmphetaDeskInport::import(KApplication *app, SiteHandler *sitehandler)
{
	AmphetaDeskInport *adiDlg = new AmphetaDeskInport(app, sitehandler);
	adiDlg->exec();
}

void AmphetaDeskInport::slotUser1()
{
	enableButton(User1, false);
	enableButton(Close, false);
 	mLocation->setEnabled(false);
  mBrowse->setEnabled(false);
	mDetails->clear();

 	QString tmpFile;
	KURL url(mLocation->currentText());
	KIO::NetAccess::download(url, tmpFile);
	
	cerr << url.url() << " -> " << tmpFile << endl;
	
	//mSites.readSites();
	mEntries = 1;
	mHaveEntries = 0;
	
	QFile f(tmpFile);
	QXmlInputSource source(f);
	QXmlSimpleReader reader;
	reader.setContentHandler(this);
	reader.setErrorHandler(this);
	if(reader.parse(source))
		mDetails->insertItem(i18n("Importing AmphetaDesk Site Listings was Successful."));
	else
		mDetails->insertItem(i18n("Importing AmphetaDesk Site Listings Failed.  Check Error Message."));
	
	KIO::NetAccess::removeTempFile(tmpFile);
	
	mDetails->insertItem(i18n("Saving Site File..."));
	if(mSites)
		mSites->writeSites();
	mDetails->insertItem(i18n("Sites Have Been Saved."));
	
 	mDetails->setCurrentItem(mDetails->count());
  mDetails->ensureCurrentVisible();
	setDetails(true);
	enableButton(User1, true);
	enableButton(Close, true);
	mLocation->setEnabled(true);
  mBrowse->setEnabled(true);
}

void AmphetaDeskInport::addSite(void)
{
	if(!mSites->isDuplicate(KURL(mURL))) {
		Site * s = new Site();
		s->setName(mTitle.simplifyWhiteSpace());
		s->setURL(KURL(mURL.stripWhiteSpace()));
		s->setDescription(mDescription.simplifyWhiteSpace());
		s->setUsed(false);
		s->makeFileName();
		mSites->addSite(s);
		mDetails->insertItem(i18n("Adding New Site: ") + mTitle);
	}
	else
		mDetails->insertItem(i18n("Already Have Site: ") + mTitle);
	
	mTitle = QString::null;
	mURL = QString::null;
	mDescription = QString::null;
	
 	mHaveEntries++;
	if(mEntries != 0) {
		mProgress->setProgress((int)((double) mHaveEntries / (double)mEntries * 100.0));
  	cout << (double) mHaveEntries << " / " << (double)mEntries << " = ";
  	cout << (int)((double) mHaveEntries / (double)mEntries * 100.0) << "%" << endl;
  }

	mDetails->setCurrentItem(mDetails->count() - 1);
  mDetails->ensureCurrentVisible();

  if(mApp)
		mApp->processEvents(100);
}

void AmphetaDeskInport::slotBrowse(void)
{
	KURL url = KFileDialog::getOpenURL();
	
	if(url.url().isEmpty() || url.url().isNull())
		return;
		
	mLocation->insertItem(url.url(), 0);
}
