/***************************************************************************
                          amphetadeskinport.h  -  description
                             -------------------
    begin                : Thu Oct 18 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AMPHETADESKINPORT_H
#define AMPHETADESKINPORT_H

#include <qwidget.h>
#include <qxml.h>

#include <kdialogbase.h>

class KComboBox;
class KApplication;
class KListBox;
class QToolButton;
class QProgressBar;

class SiteHandler;


/**
  *@author Chris Wallace
  */

class AmphetaDeskInport : public KDialogBase, public QXmlDefaultHandler {
   Q_OBJECT
	public:
		AmphetaDeskInport(KApplication *app, SiteHandler * sitehandler, QWidget *parent=0, const char *name=0);
		~AmphetaDeskInport();
		
	static void import(KApplication *app, SiteHandler *sitehandler);
		
	protected:
		bool startDocument();
		bool endDocument();
		bool startElement(const QString & namespaceURI, const QString & localName, const QString & qName, const QXmlAttributes & atts);
		bool endElement(const QString & namespaceURI, const QString & localName, const QString & qName);
		bool characters(const QString & ch);
		bool warning(const QXmlParseException & exception);
		bool error(const QXmlParseException & exception);
		bool fatalError(const QXmlParseException & exception);
		
	protected slots:
		void slotUser1();
		void slotBrowse();
		
	protected:
		void addSite(void);
		
	private:
		bool mReadingService;
		bool mReadingTitle;
		bool mReadingURL;
		bool mReadingDescription;
		bool mReadingEntries;
		
		QString mTitle;
		QString mDescription;
		QString mURL;
		
		KComboBox *mLocation;
		QToolButton *mBrowse;
		QProgressBar *mProgress;
		KListBox *mDetails;
		
		int mEntries;
		int mHaveEntries;
		
		SiteHandler *mSites;
		
		KApplication *mApp;
};

#endif
