/***************************************************************************
                          colourconverter.cpp  -  description
                             -------------------
    begin                : Wed Aug 8 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "colourconverter.h"

ColourConverter::ColourConverter()
{
}

ColourConverter::~ColourConverter()
{
}

void ColourConverter::makeHTMLColour(const QColor & c, QString & mStr)
{
	QString red, green, blue;
	red.setNum(c.red(), 16);
	if(red.length() < 2)
		red.prepend(QString("0"));
		
	green.setNum(c.green(), 16);
	if(green.length() < 2)
		green.prepend(QString("0"));
	
	blue.setNum(c.blue(), 16);
	if(blue.length() < 2)
		blue.prepend(QString("0"));
		
	mStr.append(red);
	mStr.append(green);
	mStr.append(blue);
}

void ColourConverter::makeCSSColour(const QColor & c, QString & mStr)
{
	mStr = QString(QString("rgb(") + QString::number(c.red()) + QString(",") + QString::number(c.green()) + QString(",") + QString::number(c.blue()) + QString(")"));
}
