/***************************************************************************
                          configuredialog.cpp  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "configuredialog.h"

#include <qframe.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qgroupbox.h>
#include <qmultilineedit.h>
#include <qlistview.h>
#include <qdir.h>
#include <qlabel.h>
#include <qtoolbutton.h>
#include <qradiobutton.h>

#include <ktip.h>
#include <klineeditdlg.h>
#include <kglobal.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfontdialog.h>
#include <kcolordialog.h>
#include <kfiledialog.h>
#include <kurl.h>
#include <kdirsize.h>


#include "schemeparser.h"


ConfigureDialog::ConfigureDialog(KConfig *c, QWidget *parent, const char *name )
: KDialogBase(IconList,i18n("Configure"),Ok|Apply|Cancel,Apply,parent,name)
{
	mConfig = c;

	
	QFrame *page1 = addPage(i18n("General"), i18n("General"), QPixmap(KGlobal::iconLoader()->iconPath("misc", KIcon::Desktop)));
	QHBoxLayout *lay1 = new QHBoxLayout(page1);
	gcv_bend = new GeneralConfigureViewBackEnd(page1, "gcv_bend");
	lay1->addWidget(gcv_bend);
	
	mConfig->setGroup(QString("General"));
	
	gcv_bend->mAlwaysOnTop->setChecked(mConfig->readBoolEntry(QString("Always On Top"), false));
	
	gcv_bend->mURLHandler->clear();
	gcv_bend->mURLHandler->insertStringList(mConfig->readListEntry(QString("URL Handlers")));
	gcv_bend->mURLHandler->setCurrentItem(0);
	
	gcv_bend->mScrollFeeds->setChecked(mConfig->readBoolEntry(QString("Scroll Feeds"), true));
	gcv_bend->mScrollingOptions->setEnabled(mConfig->readBoolEntry(QString("Scroll Feeds"), true));
	
	gcv_bend->mScrollingSpeed->setValue(mConfig->readNumEntry(QString("Scrolling Speed"), 2));
	gcv_bend->mLoopFeeds->setChecked(mConfig->readBoolEntry(QString("Loop Feeds"), true));
	
	gcv_bend->mButtonText->setText(mConfig->readEntry(QString("Button Text"), i18n("Go")));
	
	gcv_bend->mUseSysTray->setChecked(mConfig->readBoolEntry(QString("Use System Tray"), true));
	
	mConfig->setGroup(QString("TipOfDay"));
	gcv_bend->mShowTips->setChecked(mConfig->readBoolEntry(QString("RunOnStart"), true));
	
	QFrame *page2 = addPage(i18n("Style Sheet"), i18n("Style Sheet"), QPixmap(KGlobal::iconLoader()->iconPath("html", KIcon::Desktop)));
	QHBoxLayout *lay2 = new QHBoxLayout(page2);
	sscv_bend = new StyleSheetConfigureViewBackEnd(page2, "sscv_bend");
	lay2->addWidget(sscv_bend);
	
	mConfig->setGroup(QString("Style Sheet"));
	sscv_bend->mUseStyleSheet->setChecked(mConfig->readBoolEntry(QString("Use Style Sheet"), true));
	sscv_bend->mStyleSheet->setEnabled(mConfig->readBoolEntry(QString("Use Style Sheet"), true));
	
	sscv_bend->mStyleSheet->setText(mConfig->readEntry(QString("Style Sheet"), QString("body { font-family: \"Times New Roman\", Times, serif;\n       background-color: white; color: black;\n       margin: 1em 1em 1em 1em; }\np, .version {\n    margin-left: 2.5em; }\n\ndl, blockquote {\n     margin-left: 3.2em; }\n\nul, ol {\n     margin-left: 4.5em; }\n\npre { font-family: \"Courier New\", monospace;\n      padding: 1em;\n      margin: 0.2em 2.5em 0.2em 3em;\n      background-color: #efeff5;\n      border: 1px solid #cfcfcf;\n      white-space: pre;\n }\n\nh1, h2, h3, h4 {font-family: Arial, Helvetica, sans-serif;}\nh1 { font-size: 2.2em; }\n\nh2 { font-size: 1.6em; }\n\nh2, h3, em { font-weight: bold;\n             margin-left: 0.3em; }\n\ndd.indent { padding-left: 1em; }\n\n.example-dc { color: blue; }\n.example-taxo { color: green; }\n.example-syn, .example-other { color: red; }\n.example-co { color: purple; }\n.example-ti { color: #ff9900; /* orange */ }\n.example-rdf { color: #996633; /* brown */}\n\npre {\n  white-space: pre;\n}")));
	
	QFrame *page3 = addPage(i18n("Schemes"), i18n("Schemes"), KGlobal::iconLoader()->iconPath("colorize", KIcon::Desktop));
	QHBoxLayout *lay3 = new QHBoxLayout(page3);
	sev_bend = new SchemeEditor(page3, "sev_bend");
	lay3->addWidget(sev_bend);
	
	QFrame *page4 = addPage(i18n("Caches"), i18n("Caches"), QPixmap(KGlobal::iconLoader()->iconPath("proxy", KIcon::Desktop)));
	QHBoxLayout *lay4 = new QHBoxLayout(page4);
	ccv_bend = new CacheConfigureViewBackEnd(page4, "ccv_bend");
	lay4->addWidget(ccv_bend);
	
	/** Calculate the size of the caches **/
	KURL url;
	url.setPath(QDir::homeDirPath() + QString("/.krss/feeds/unparsed/"));
	ccv_bend->mFeedSize->setText(i18n("Size: ") + QString::number(KDirSize::dirSize(url)/1024, KGlobal::locale()->fracDigits()) + QString("KB"));
	url.setPath(QDir::homeDirPath() + QString("/.krss/cache/"));
	ccv_bend->mImageSize->setText(i18n("Size: ") + QString::number(KDirSize::dirSize(url)/1024, KGlobal::locale()->fracDigits()) + QString("KB"));
	
	QFrame *page5 = addPage(i18n("MyChannelBar"), i18n("MyChannelBar"), QPixmap(KGlobal::iconLoader()->iconPath("view_icon", KIcon::Desktop)));
	QHBoxLayout *lay5 = new QHBoxLayout(page5);
	mcv_bend = new MyChannelBarConfigViewBackEnd(page5, "mcv_bend");
	lay5->addWidget(mcv_bend);
	
	mConfig->setGroup(QString("MyChannelBar"));
	mcv_bend->mAutoArrange->setChecked(mConfig->readBoolEntry(QString("Auto Arrange"), true));
	if(mConfig->readBoolEntry(QString("Arrangement"), false)) {
		mcv_bend->mTopToBottom->setChecked(true);
		mcv_bend->mLeftToRight->setChecked(false);
	}
	else {
		mcv_bend->mTopToBottom->setChecked(false);
		mcv_bend->mLeftToRight->setChecked(true);
	}
	
	if(mConfig->readBoolEntry(QString("Resize"), true)) {
		mcv_bend->mResizeFixed->setChecked(true);
		mcv_bend->mResizeAdjust->setChecked(false);
	}
	else {
		mcv_bend->mResizeFixed->setChecked(false);
		mcv_bend->mResizeAdjust->setChecked(true);
	}
		
	mcv_bend->mWordwrap->setChecked(mConfig->readBoolEntry(QString("WordWrap"), true));
	mcv_bend->mMaxTextLen->setValue(mConfig->readNumEntry(QString("Max Text Length"), 100));
		
	if(mConfig->readBoolEntry(QString("Text Position"), false)) {
		mcv_bend->mPosRight->setChecked(true);
		mcv_bend->mPosBottom->setChecked(false);
	}
	else {
		mcv_bend->mPosRight->setChecked(false);
		mcv_bend->mPosBottom->setChecked(true);
	}
	
	mcv_bend->mImageX->setValue(mConfig->readNumEntry(QString("Image X"), 16));
	mcv_bend->mImageY->setValue(mConfig->readNumEntry(QString("Image Y"), 16));
	
	mcv_bend->mGridX->setValue(mConfig->readNumEntry(QString("Grid X"), 128));
	mcv_bend->mGridY->setValue(mConfig->readNumEntry(QString("Grid Y"), 32));
	
	QFrame *page6 = addPage(i18n("Data and Time"), i18n("Date and Time"), QPixmap(KGlobal::iconLoader()->iconPath("clock", KIcon::Desktop)));
	QHBoxLayout *lay6 = new QHBoxLayout(page6);
	dtv_bend = new DateTimeConfigViewBackEnd(page6, "dtv_bend");
	lay6->addWidget(dtv_bend);
	
	mConfig->setGroup(QString("MyChannelBar"));
	dtv_bend->mUseDateTimeTags->setChecked(mConfig->readBoolEntry(QString("Display Channel Information"), true));
	dtv_bend->mDateTimeTagOptions->setEnabled(mConfig->readBoolEntry(QString("Display Channel Information"), true));
	
	dtv_bend->mUseShortDateTime->setChecked(mConfig->readBoolEntry(QString("Use Short Format"), true));
	dtv_bend->mIncludeSeconds->setChecked(mConfig->readBoolEntry(QString("Include Seconds"), false));
	
	dtv_bend->mNeverExpire->setChecked(mConfig->readBoolEntry(QString("No Expiration"), false));
	dtv_bend->mExpirationOptions->setDisabled(mConfig->readBoolEntry(QString("No Expiration"), false));
	
	dtv_bend->mExpirationDays->setValue(mConfig->readNumEntry(QString("Expiration Days"), 1));
	dtv_bend->mExpirationHours->setValue(mConfig->readNumEntry(QString("Expiration Hours"), 0));
	dtv_bend->mExpirationMinutes->setValue(mConfig->readNumEntry(QString("Expiration Minutes"), 0));
	
	connect(ccv_bend->mClearImageCache, SIGNAL(clicked()), this, SLOT(slotClearImageCache()));
	connect(ccv_bend->mClearFeedCache, SIGNAL(clicked()), this, SLOT(slotClearFeedCache()));
	
}


ConfigureDialog::~ConfigureDialog()
{
}

void ConfigureDialog::configure(KConfig *c)
{
	ConfigureDialog cd(c);
	if(cd.exec() == Accepted) {
		cd.slotApply();
	}
}

void ConfigureDialog::slotApply(void)
{
	mConfig->setGroup(QString("General"));
	
	mConfig->writeEntry(QString("Open URLs With"), gcv_bend->mURLHandler->currentText());
	
	QStringList uh_list;
	for(int i=0; i < gcv_bend->mURLHandler->count(); i++)
		uh_list.append(gcv_bend->mURLHandler->text(i));
		
	mConfig->writeEntry(QString("URL Handlers"), uh_list);
	
	mConfig->writeEntry(QString("Scroll Feeds"), gcv_bend->mScrollFeeds->isChecked());
	mConfig->writeEntry(QString("Scrolling Speed"), gcv_bend->mScrollingSpeed->value());
	mConfig->writeEntry(QString("Loop Feeds"), gcv_bend->mLoopFeeds->isChecked());
	
	mConfig->writeEntry(QString("Always On Top"), gcv_bend->mAlwaysOnTop->isChecked());
	
	mConfig->writeEntry(QString("Button Text"), gcv_bend->mButtonText->text());
	
	mConfig->writeEntry(QString("Use System Tray"), gcv_bend->mUseSysTray->isChecked());
	
	mConfig->setGroup(QString("Style Sheet"));
	mConfig->writeEntry(QString("Use Style Sheet"), sscv_bend->mUseStyleSheet->isChecked());
	mConfig->writeEntry(QString("Style Sheet"), sscv_bend->mStyleSheet->text());
	
	sev_bend->saveCurrentScheme();
	
	mConfig->setGroup(QString("MyChannelBar"));
	mConfig->writeEntry(QString("Auto Arrange"), mcv_bend->mAutoArrange->isChecked());
	
	mConfig->writeEntry(QString("Arrangement"), mcv_bend->mTopToBottom->isChecked());
		
	mConfig->writeEntry(QString("Resize"), mcv_bend->mResizeFixed->isChecked());
		
	mConfig->writeEntry(QString("WordWrap"), mcv_bend->mWordwrap->isChecked());
	mConfig->writeEntry(QString("Max Text Length"), mcv_bend->mMaxTextLen->value());
	
	mConfig->writeEntry(QString("Text Position"), mcv_bend->mPosRight->isChecked());
	
	mConfig->writeEntry(QString("Image X"), mcv_bend->mImageX->value());
	mConfig->writeEntry(QString("Image Y"), mcv_bend->mImageY->value());
	
	mConfig->writeEntry(QString("Grid X"), mcv_bend->mGridX->value());
	mConfig->writeEntry(QString("Grid Y"), mcv_bend->mGridY->value());
	
	KTipDialog::setShowOnStart(gcv_bend->mShowTips->isChecked());
	
	mConfig->setGroup(QString("MyChannelBar"));
	mConfig->writeEntry(QString("Display Channel Information"), dtv_bend->mUseDateTimeTags->isChecked());
	mConfig->writeEntry(QString("Use Short Format"), dtv_bend->mUseShortDateTime->isChecked());	
	mConfig->writeEntry(QString("Include Seconds"), dtv_bend->mIncludeSeconds->isChecked());
	
	mConfig->writeEntry(QString("No Expiration"), dtv_bend->mNeverExpire->isChecked());
	mConfig->writeEntry(QString("Expiration Days"), dtv_bend->mExpirationDays->value());
	mConfig->writeEntry(QString("Expiration Hours"), dtv_bend->mExpirationHours->value());
	mConfig->writeEntry(QString("Expiration Minutes"), dtv_bend->mExpirationMinutes->value());
}

void ConfigureDialog::slotClearFeedCache(void)
{
	if(KMessageBox::warningYesNo(0, i18n("The feeds will be deleted from your harddrive.\n  They will be restored once you get the news feeds.  Are\n you sure that you want clear the feed cache?")) == KMessageBox::No)
		return;
		
	clearFeedCache();
	
	KURL url;
	url.setPath(QDir::homeDirPath() + QString("/.krss/feeds/unparsed/"));
	ccv_bend->mFeedSize->setText(i18n("Size: ") + QString::number(KDirSize::dirSize(url)/1024) + QString("KB"));
	url.setPath(QDir::homeDirPath() + QString("/.krss/cache/"));
	ccv_bend->mImageSize->setText(i18n("Size: ") + QString::number(KDirSize::dirSize(url)/1024) + QString("KB"));
}

void ConfigureDialog::clearFeedCache(void)
{		
	QDir d(QDir::homeDirPath() + QString("/.krss/feeds/unparsed/"));
	d.setFilter(QDir::Files | QDir::Hidden | QDir::NoSymLinks);
	
	const QFileInfoList *list = d.entryInfoList();
	QFileInfoListIterator it(*list);
	QFileInfo *fi;
	
	while( (fi = it.current() ) ) {
		d.remove(d.absPath() + QChar('/') + fi->fileName(), true);
		++it;
	}
}

void ConfigureDialog::slotClearImageCache(void)
{
	if(KMessageBox::warningYesNo(0, i18n("The images will be deleted from your harddrive.\n  They will be restored once you get the news feeds.  Are\n you sure that you want clear the image cache?")) == KMessageBox::No)
		return;
		
	clearImageCache();
	
	KURL url;
	url.setPath(QDir::homeDirPath() + QString("/.krss/feeds/unparsed/"));
	ccv_bend->mFeedSize->setText(i18n("Size: ") + QString::number(KDirSize::dirSize(url)/1024) + QString("KB"));
	url.setPath(QDir::homeDirPath() + QString("/.krss/cache/"));
	ccv_bend->mImageSize->setText(i18n("Size: ") + QString::number(KDirSize::dirSize(url)/1024) + QString("KB"));
}

void ConfigureDialog::clearImageCache(void)
{		
	QDir d(QDir::homeDirPath() + QString("/.krss/cache/"));
	d.setFilter(QDir::Files | QDir::Hidden | QDir::NoSymLinks);
	
	const QFileInfoList *list = d.entryInfoList();
	QFileInfoListIterator it(*list);
	QFileInfo *fi;
	
	while( (fi = it.current() ) ) {
		d.remove(d.absPath() + QChar('/') + fi->fileName(), true);
		++it;
	}
	
}
