/***************************************************************************
                          configuredialog.h  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFIGUREDIALOG_H
#define CONFIGUREDIALOG_H

#include <qwidget.h>
#include <kdialogbase.h>
#include <kconfig.h>
#include <klocale.h>

#include "generalconfigureviewbackend.h"
#include "stylesheetconfigureviewbackend.h"
//#include "schemeconfigureviewbackend.h"
#include "cacheconfigureviewbackend.h"
#include "mychannelbarconfigureviewbackend.h"
#include "datetimeconfigureviewbackend.h"

#include "schemetree.h"

#include "schemeeditor.h"

/**
  *@author Chris Wallace
  */

class ConfigureDialog : public KDialogBase  {
   Q_OBJECT
	public:
		~ConfigureDialog();
		
		static void configure(KConfig *c);
		
		static void clearImageCache(void);
		static void clearFeedCache(void);
	
	protected:
		ConfigureDialog(KConfig *c, QWidget *parent=0, const char *name=0);
		
	protected slots:
		void slotApply(void);
		
		void slotClearFeedCache(void);
		void slotClearImageCache(void);
		
	private:
		KConfig *mConfig;
		GeneralConfigureViewBackEnd *gcv_bend;
		StyleSheetConfigureViewBackEnd *sscv_bend;
		SchemeEditor *sev_bend;
		CacheConfigureViewBackEnd *ccv_bend;
		MyChannelBarConfigViewBackEnd *mcv_bend;
		DateTimeConfigViewBackEnd *dtv_bend;
};

#endif
