/***************************************************************************
                          editfeeddialog.cpp  -  description
                             -------------------
    begin                : Sat Aug 4 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "editfeeddialog.h"
#include <klocale.h>
#include <qframe.h>
#include <qlayout.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qgroupbox.h>

#include <kglobal.h>
#include <kiconloader.h>
#include <klistview.h>

#include "sitehandler.h"
#include "editsitedialog.h"

EditFeedDialog::EditFeedDialog(KConfig *c, SiteHandler *sitehandler, QWidget *parent, const char *name )
: KDialogBase(IconList, i18n("Configure MyFeeds"), Apply|Ok|Cancel, Apply, parent,name)
{
	config = c;
	mSiteHandler = sitehandler;
	
	QFrame *page1 = addPage(i18n("RSS Feeds"), i18n("RSS Feeds"), QPixmap(KGlobal::iconLoader()->iconPath("editrssfeeds", KIcon::Desktop)));
	QHBoxLayout *lay1 = new QHBoxLayout(page1);
	efv_bend = new EditFeedViewBackEnd(page1, "efv_bend");
	lay1->addWidget(efv_bend);
	
	connect(efv_bend->mAddFeed, SIGNAL(clicked()), this, SLOT(slotAddFeedClicked()));
	connect(efv_bend->mEditFeed, SIGNAL(clicked()), this, SLOT(slotEditFeedClicked()));
	connect(efv_bend->mRemoveFeed, SIGNAL(clicked()), this, SLOT(slotRemoveFeedClicked()));
	
	/**
 		Lets have manual column moving so that we do not get huge a dialog box
	**/
	for(int i = 0; i < efv_bend->mFeedList->columns(); i++)
		efv_bend->mFeedList->setColumnWidthMode(i, QListView::Manual);

	/**
 		Lets load the last size of the columns
  **/
  KConfig * config = KGlobal::config();
  if(config) {
    config->setGroup(QString("General"));
    QValueList<int> sizes = config->readIntListEntry(QString("Edit Feed Column Sizes"));
    if(sizes.isEmpty()) { //Load some defualts if there arn't any
    	sizes.append(50);
      for(int i=1; i<efv_bend->mFeedList->columns(); i++)
      	sizes.append(200);
    }
    int col = 0;
    QValueList<int>::Iterator it = sizes.begin();
    while(it != sizes.end()) {
      efv_bend->mFeedList->setColumnWidth(col, (*it));
      col++;
      ++it;
    }
  }
		
	if(mSiteHandler)
		mSiteHandler->displaySites(efv_bend->mFeedList);
	
	
	QFrame *page2 = addPage(i18n("Auto Update"), i18n("Auto Update"), QPixmap(KGlobal::iconLoader()->iconPath("autoupdaterssfeeds", KIcon::Desktop)));
	QHBoxLayout *lay2 = new QHBoxLayout(page2);
	auv_bend = new AutoUpdateViewBackEnd(page2, "auv_bend");
	lay2->addWidget(auv_bend);
	
	config->setGroup(QString("Auto Update"));
	auv_bend->mUseAutoUpdate->setChecked(config->readBoolEntry(QString("Use AutoUpdate"), false));
	auv_bend->mAutoUpdateGroup->setEnabled(config->readBoolEntry(QString("Use AutoUpdate"), false));
	
	auv_bend->mUpdateDays->setValue(config->readNumEntry(QString("Days To Update"), 1));
	auv_bend->mUpdateHours->setValue(config->readNumEntry(QString("Hours To Update"), 0));
	auv_bend->mUpdateMinutes->setValue(config->readNumEntry(QString("Minutes To Update"), 0));
}

EditFeedDialog::~EditFeedDialog()
{
	/**
 		Lets remeber the last size of the columns
  **/
  KConfig * config = KGlobal::config();
  if(config) {
    config->setGroup(QString("General"));
    QValueList<int> sizes;
    for(int i=0; i<efv_bend->mFeedList->columns(); i++)
      	sizes.append(efv_bend->mFeedList->columnWidth(i));
		config->writeEntry(QString("Edit Feed Column Sizes"), sizes);
  }
}

void EditFeedDialog::editFeeds(KConfig *c, SiteHandler *sitehandler)
{
	EditFeedDialog efd(c, sitehandler);
	if(efd.exec() == Accepted) {
		efd.slotApply();
	}
}

void EditFeedDialog::slotAddFeedClicked(void)
{
	Site site;
	site.setUsed(true);
	if(EditSiteDialog::editSite(site)) {
		QCheckListItem *cli = new QCheckListItem(efv_bend->mFeedList, "", QCheckListItem::CheckBox);
		cli->setText(1, site.name());
		cli->setText(2, site.URL().url());
		cli->setText(3, site.description());
		site.makeFileName();
		cli->setText(4, site.fileNameUnParsed());
		cli->setText(5, site.fileNameParsed());
		cli->setOn(site.used());
		efv_bend->mFeedList->insertItem(cli);
	}
}

void EditFeedDialog::slotEditFeedClicked(void)
{
	for(QListViewItem *lvi = efv_bend->mFeedList->firstChild(); lvi != 0; lvi = lvi->nextSibling()) {
		if(lvi->isSelected()) {
			QCheckListItem *cli = (QCheckListItem *) lvi;
			if(cli) {
				Site site;
				site.setUsed(cli->isOn());
				site.setName(cli->text(1));
				site.setURL(KURL(cli->text(2)));
				site.setDescription(cli->text(3));
				if(EditSiteDialog::editSite(site)) {
					cli->setText(1, site.name());
					cli->setText(2, site.URL().url());
					cli->setText(3, site.description());
					cli->setText(4, site.fileNameUnParsed());
					cli->setText(5, site.fileNameParsed());
					cli->setOn(site.used());
				}
			}
		}
	}
}

void EditFeedDialog::slotRemoveFeedClicked(void)
{
	for(QListViewItem *lvi = efv_bend->mFeedList->firstChild(); lvi != 0; lvi = lvi->nextSibling()) {
		if(lvi->isSelected()) {
			efv_bend->mFeedList->takeItem(lvi);
		}
	}	
}

void EditFeedDialog::slotApply(void)
{
	config->setGroup(QString("Auto Update"));
	config->writeEntry(QString("Used AutoUpdate"), auv_bend->mUseAutoUpdate->isChecked());
	
	config->writeEntry(QString("Days To Update"), auv_bend->mUpdateDays->value());	
	config->writeEntry(QString("Hours To Update"), auv_bend->mUpdateHours->value());	
	config->writeEntry(QString("Minutes To Update"), auv_bend->mUpdateMinutes->value());	
	saveSites();
}
