/***************************************************************************
                          editfeeddialog.h  -  description
                             -------------------
    begin                : Sat Aug 4 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EDITFEEDDIALOG_H
#define EDITFEEDDIALOG_H

#include <qwidget.h>
#include <kdialogbase.h>
#include <kconfig.h>

/**
  *@author Chris Wallace
  */
#include "editfeedviewbackend.h"
#include "autoupdateviewbackend.h"
#include "sitehandler.h"

class EditFeedDialog : public KDialogBase  {
   Q_OBJECT
	public:
		~EditFeedDialog();
		
		static void editFeeds(KConfig *c, SiteHandler * sitehandler);
		
		void saveSites(void) {
			if(mSiteHandler) {
				mSiteHandler->getSites(efv_bend->mFeedList);
				mSiteHandler->writeSites();
			}
		}
			
		
	protected:
		EditFeedDialog(KConfig *c, SiteHandler * sitehandler, QWidget *parent=0, const char *name=0);
		
	protected slots:
		void slotAddFeedClicked(void);
		void slotEditFeedClicked(void);
		void slotRemoveFeedClicked(void);
		
		void slotApply(void);
		
	private:
		EditFeedViewBackEnd *efv_bend;
		AutoUpdateViewBackEnd *auv_bend;
		KConfig *config;
		SiteHandler *mSiteHandler;
};

#endif
