/***************************************************************************
                          editsitedialog.cpp  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "editsitedialog.h"

#include <qradiobutton.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <kmessagebox.h>
#include <klocale.h>

EditSiteDialog::EditSiteDialog(QWidget *parent, const char *name )
: KDialogBase(parent,name,true,i18n("Edit RSS Feed"),Ok|Cancel)
{
	es_bend = new EditRSSFeedDialogBackEnd(this, "es_bend");
	setMainWidget(es_bend);
}

EditSiteDialog::~EditSiteDialog()
{
}

void EditSiteDialog::fill(Site & site)
{
	es_bend->mUseYes->setChecked(site.used());
	es_bend->mUseNo->setChecked(!site.used());
	es_bend->mFeedName->setText(site.name());
	es_bend->mFeedURL->setText(site.URL().url());
	es_bend->mDescription->setText(site.description());
}

void EditSiteDialog::get(Site & site)
{
	site.setUsed(es_bend->mUseYes->isChecked());
	site.setName(es_bend->mFeedName->text());
	site.setURL(es_bend->mFeedURL->text().stripWhiteSpace());
	site.setDescription(es_bend->mDescription->text());
}

bool EditSiteDialog::editSite(Site & site)
{
	EditSiteDialog esd;
	esd.fill(site);
	if(esd.exec() == Accepted) {
		esd.get(site);
		return true;
	}
	return false;
}

void EditSiteDialog::slotOk(void)
{
	KURL url(es_bend->mFeedURL->text().stripWhiteSpace());
	if(!url.isValid()) {
		KMessageBox::sorry(0, i18n("The URL that you have entered is invalid, please enter a valid URL."), i18n("Sorry"), false);
		return;
	}
	
	if(url.protocol().compare(QString("http")) != 0) {
		KMessageBox::sorry(0, i18n("Sorry only the HTTP protocol is supported."), i18n("Sorry"), false);
		return;
	}
	
	accept();
}
