/***************************************************************************
                          filetransfer.h  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILETRANSFER_H
#define FILETRANSFER_H

#include <kurl.h>
#include <qstring.h>

/**
  *@author Chris Wallace
  */

class FileTransfer {
	public:
		FileTransfer();
		FileTransfer(const FileTransfer & ft) {
			operator = (ft);
		}

		~FileTransfer();
		
		void operator = (const FileTransfer & ft) {
			mSrc = ft.mSrc;
			mDst = ft.mDst;
			mFName = ft.mFName;
			mFinalDst = ft.mFinalDst;
			mIsFeed = ft.mIsFeed;
		}
		
		const QString & destination(void) const {return mDst;}
		const QString & finalDestination(void) const {return mFinalDst;}
		const KURL & URL(void) const {return mSrc;}
		const QString & feedName(void) const {return mFName;}
		bool isFeed(void) {return mIsFeed;}
		
		void setDestination(const QString & dest) {mDst = dest;}
		void setFinalDestination(const QString & dest) {mFinalDst = dest;}
		void setURL(const KURL & url) {mSrc = url;}
		void setFeedName(const QString & feedname) {mFName = feedname;}
		void setIsFeed(bool isfeed) {mIsFeed = isfeed;}
		
	private:
		KURL mSrc;
		QString mDst;
		QString mFName;
		QString mFinalDst;
		bool mIsFeed;
};

#endif
