/***************************************************************************
                          filterdialog.cpp  -  description
                             -------------------
    begin                : Mon Oct 15 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "filterdialog.h"

#include <qradiobutton.h>

#include <klocale.h>
#include <klistview.h>

#include <iostream>

#include "filterviewbackend.h"

#include "filterruledialog.h"


FilterDialog::FilterDialog(QWidget *parent, const char *name )
: KDialogBase(parent,name,true,i18n("MyFilters"),Ok|Apply|Close,Ok,true)
{
	fv_bend = new FilterViewBackEnd(this, "fv_bend");
	setMainWidget(fv_bend);
	
	fv_bend->mRules->setSorting(5, true);
	//fv_bend->setShowSortIndicator(true);
	
	connect(fv_bend->mNewRule, SIGNAL(clicked()), this, SLOT(slotNewFilterRule()));
	connect(fv_bend->mEditRule, SIGNAL(clicked()), this, SLOT(slotEditFilterRule()));
	connect(fv_bend->mRemoveRule, SIGNAL(clicked()), this, SLOT(slotRemoveFilterRule()));
	connect(fv_bend->mMoveUp, SIGNAL(clicked()), this, SLOT(slotMoveFilterRuleUp()));
	connect(fv_bend->mMoveDown, SIGNAL(clicked()), this, SLOT(slotMoveFilterRuleDown()));
	
	mFilters.readFilters();
	
	if(mFilters.defaultAction() == FilterRule::Allow) {
		fv_bend->mAllow->setChecked(true);
		fv_bend->mDeny->setChecked(false);
	}
	else {
		fv_bend->mAllow->setChecked(false);
		fv_bend->mDeny->setChecked(true);
	}
	mFilters.list(fv_bend->mRules);
}

FilterDialog::~FilterDialog()
{
}

void FilterDialog::slotClose(void)
{
	reject();
}

void FilterDialog::slotApply(void)
{
	if(fv_bend->mAllow->isChecked())
		mFilters.setDefaultAction(FilterRule::Allow);
	else
		mFilters.setDefaultAction(FilterRule::Deny);
		
	mFilters.writeFilters();
}

void FilterDialog::slotOk(void)
{
	slotApply();
	slotClose();
}

void FilterDialog::slotNewFilterRule(void)
{
	FilterRule fr;
	if(FilterRuleDialog::editFilterRule(fr, true)) {
		cerr << "We have a new FilterRule" << endl;
		mFilters.addFilterRule(new FilterRule(fr));
	}
	else {
		cerr << "We do not have a new Filter Rule" << endl;
	}
		
	mFilters.list(fv_bend->mRules);
}

void FilterDialog::slotEditFilterRule(void)
{
	QListViewItem * item = fv_bend->mRules->firstChild();
	while(item) {
		if(item->isSelected()) {
			QString id = item->text(4);
			FilterRule *fr = mFilters.find(id);
			if(fr) {
				if(FilterRuleDialog::editFilterRule(*fr))
					cerr << "We have edited to filter rule." << endl;
				else
					cerr << "No changes will be made." << endl;
			}
					
		}
		item = item->nextSibling();
	}
	
	mFilters.list(fv_bend->mRules);
}

void FilterDialog::slotRemoveFilterRule(void)
{
	QListViewItem * item = fv_bend->mRules->firstChild();
	while(item) {
		if(item->isSelected()) {
			QString id = item->text(4);
			mFilters.remove(id);
		}
		item = item->nextSibling();
	}
	
	mFilters.list(fv_bend->mRules);
}

void FilterDialog::slotMoveFilterRuleUp(void)
{
	QListViewItem * item = fv_bend->mRules->firstChild();
	while(item) {
		if(item->isSelected()) {
			QString id = item->text(4);
			mFilters.moveUp(id);
		}
		item = item->nextSibling();
	}
	
	mFilters.list(fv_bend->mRules);
}

void FilterDialog::slotMoveFilterRuleDown(void)
{
	QListViewItem * item = fv_bend->mRules->firstChild();
	while(item) {
		if(item->isSelected()) {
			QString id = item->text(4);
			mFilters.moveDown(id);
		}
		item = item->nextSibling();
	}
	
	mFilters.list(fv_bend->mRules);
}

void FilterDialog::editFilters(void)
{
	FilterDialog fDlg;
	fDlg.exec();
}
