/***************************************************************************
                          filterdialog.h  -  description
                             -------------------
    begin                : Mon Oct 15 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILTERDIALOG_H
#define FILTERDIALOG_H

#include <qwidget.h>
#include <kdialogbase.h>

#include "filterhandler.h"

class FilterViewBackEnd;
/**
  *@author Chris Wallace
  */

class FilterDialog : public KDialogBase  {
   Q_OBJECT
	public:	
		~FilterDialog();
		
		static void editFilters(void);
		
	protected:
		FilterDialog(QWidget *parent=0, const char *name=0);
		void loadFilters(void);
		void saveFilters(void);
		
	protected slots:
		void slotOk(void);
		void slotApply(void);
		void slotClose(void);
		void slotNewFilterRule(void);
		void slotEditFilterRule(void);
		void slotRemoveFilterRule(void);
		void slotMoveFilterRuleUp(void);
		void slotMoveFilterRuleDown(void);
		
	private:
		FilterViewBackEnd *fv_bend;
		FilterHandler mFilters;
};

#endif
