/***************************************************************************
                          filterhandler.h  -  description
                             -------------------
    begin                : Mon Oct 15 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILTERHANDLER_H
#define FILTERHANDLER_H


#include <qlist.h>
#include <qxml.h>
#include <qdom.h>

#include "filterrule.h"

class KListView;
/**
  *@author Chris Wallace
  */

class FilterHandler : QXmlDefaultHandler {
	public:
		FilterHandler(FilterRule::Action defaultAction = FilterRule::Allow);
		//FilterHandler(const FilterHandler &);
		~FilterHandler();
		
		void operator = (const FilterHandler &);
		
		void setDefaultAction(FilterRule::Action action) {mDefaultAction = action;}
		FilterRule::Action defaultAction(void) {return mDefaultAction;}
		
		void clearRules(void);
		
		void addFilterRule(FilterRule::Location location, FilterRule::Test test, const QString & re, FilterRule::Action action);
		void addFilterRule(FilterRule *);
		
		FilterRule *find(const QString & id);
		
		void remove(const QString & id);
		
		void moveUp(const QString & id);
		void moveDown(const QString & id);
		
		FilterRule::Action filter(const QString & title, const QString & description);
		
		void list(KListView *mFilterList);
		
		void writeFilters(void);
		void readFilters(void);
		
	protected:
		const QString & locationToString(FilterRule::Location location);
		const QString & testToString(FilterRule::Test test);
		const QString & actionToString(FilterRule::Action action);
		
		bool startDocument(void);
		bool endDocument(void);
		bool startElement(const QString &, const QString &, const QString &, const QXmlAttributes &);
		bool endElement(const QString &, const QString &, const QString &);
		bool warning(const QXmlParseException &);
		bool error(const QXmlParseException &);
		bool fatalError(const QXmlParseException &);
		bool characters(const QString &);
				
	private:
		bool mReadingFilters;
		bool mReadingDefaultAction;
		bool mReadingRule;
		bool mReadingLocation;
		bool mReadingTest;
		bool mReadingRegExp;
		bool mReadingAction;
		
		FilterRule::Action mDefaultAction;
		QList<FilterRule> mFilters;
		QString mTempStr;
		FilterRule *mTempRule;
		
};

#endif
