/***************************************************************************
                          filterrule.cpp  -  description
                             -------------------
    begin                : Mon Oct 15 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "filterrule.h"

FilterRule::FilterRule(Location location, Test test, const QString & re, Action action)
{
	setLocation(location);
	setTest(test);
	setRegularExpression(re);
	setAction(action);
}

FilterRule::FilterRule(const FilterRule & f)
{
	operator = (f);
}

FilterRule::~FilterRule()
{
}

void FilterRule::operator = (const FilterRule & f)
{
	mLocation = f.mLocation;
	mTest = f.mTest;
	mRegularExpression = f.mRegularExpression;
	mAction = f.mAction;
}

bool FilterRule::doesTrigger(const QString & title, const QString & description)
{
	bool ret = false;
	QRegExp re(mRegularExpression, true, false);
	switch(mLocation) {
		case NewsTitle:
			switch(mTest) {
				case Contains:
					if(re.match(title, 0) >= 0)
						ret = true;
					break;
				case DoesNotContain:
					if(re.match(title, 0) < 0)
						ret = true;
					break;
			}
			break;
		case NewsDescription:
			switch(mTest) {
				case Contains:
					if(re.match(description, 0) >= 0)
						ret = true;
					break;
				case DoesNotContain:
					if(re.match(description, 0) < 0)
						ret = true;
					break;
			}
			break;
		case Both:
			switch(mTest) {
				case Contains:
					if(re.match(title, 0) >= 0 && re.match(description, 0) >= 0)
						ret = true;
					break;
				case DoesNotContain:
					if(re.match(title, 0) < 0 && re.match(description, 0) < 0)
						ret = true;
					break;
			}
			break;
		case Either:
			switch(mTest) {
				case Contains:
					if(re.match(title, 0) >= 0 || re.match(description, 0) >= 0)
						ret = true;
					break;
				case DoesNotContain:
					if(re.match(title, 0) < 0 || re.match(description, 0) < 0)
						ret = true;
					break;
			}
			break;
	}
	return ret;
}

void FilterRule::write(QDomDocument & doc, QDomElement & elm)
{
	QDomElement relm = doc.createElement("rule");
		QDomElement lelm = doc.createElement("location");
			QDomText ltxt = doc.createTextNode(QString::number(location()));
		lelm.appendChild(ltxt);
	relm.appendChild(lelm);
		QDomElement telm = doc.createElement("test");
			QDomText ttxt = doc.createTextNode(QString::number(test()));
		telm.appendChild(ttxt);
	relm.appendChild(telm);
		QDomElement reelm = doc.createElement("regexp");
			QDomText retxt = doc.createTextNode(regularExpression());
		reelm.appendChild(retxt);
	relm.appendChild(reelm);
		QDomElement aelm = doc.createElement("action");
			QDomText atxt = doc.createTextNode(QString::number(action()));
		aelm.appendChild(atxt);
	relm.appendChild(aelm);
	
	elm.appendChild(relm);
}
