/***************************************************************************
                          filterrule.h  -  description
                             -------------------
    begin                : Mon Oct 15 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILTERRULE_H
#define FILTERRULE_H

#include <qregexp.h>
#include <qstring.h>
#include <qdom.h>


/**
  *@author Chris Wallace
  */

class FilterRule {
	public:
		enum Location {
			NewsTitle=0,
			NewsDescription,
			Both,
			Either
		};
		enum Test {
			Contains=0,
			DoesNotContain
		};
		enum Action {
			Allow=0,
			Deny
		};
		
		FilterRule(Location location = NewsTitle, Test test = Contains, const QString & regexpr = QString::null, Action action = Allow);
		FilterRule(const FilterRule & );
		~FilterRule();
		
		void operator = (const FilterRule &);
		
		void setLocation(Location location) {mLocation = location;}
		Location location(void) {return mLocation;}
		
		void setTest(Test test) {mTest = test;}
		Test test(void) {return mTest;}
		
		void setRegularExpression(const QString & re) {mRegularExpression = re;}
		const QString & regularExpression(void) {return mRegularExpression;}
		
		void setAction(Action action) {mAction = action;}
		Action action(void) {return mAction;}
		
		void setId(const QString & id) {mId = id;}
		const QString id(void) {return mId;}
		
		bool doesTrigger(const QString & title, const QString & description);
		
		void write(QDomDocument & doc, QDomElement & elm);
		
	private:
		Location mLocation;
		Test mTest;
		QString mRegularExpression;
		Action mAction;
		QString mId;
};

#endif
