/***************************************************************************
                          filterruledialog.cpp  -  description
                             -------------------
    begin                : Mon Oct 15 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "filterruledialog.h"

#include <qcombobox.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qgroupbox.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>

#include <klocale.h>
#include <kiconloader.h>

#include <iostream>

#include "filterruleviewbackend.h"

FilterRuleDialog::FilterRuleDialog(QWidget *parent, const char *name )
: KDialogBase(parent,name,true,i18n("Edit Filter Rule"),Details|Ok|Apply|Close,Apply,true,i18n("More Information"))
{
	fv_bend = new FilterRuleViewBackEnd(this, "fv_bend");
	setMainWidget(fv_bend);
	mSaveFilterRule = false;
	setDetailsWidget(fv_bend->mMoreInfo);
	
	QPopupMenu * options = new QPopupMenu(this);
	options->insertTearOffHandle();
  options->setCaption(i18n("Options"));
  options->insertItem(i18n("Any character ('.')"), this, SLOT(slotRegExprMenuAnyChar()));
  options->insertItem(i18n("Start of Input ('^')"), this, SLOT(slotRegExprMenuSOI()));
  options->insertItem(i18n("End of Input ('$')"), this, SLOT(slotRegExprMenuEOI()));
  options->insertItem(i18n("Character Set (\"[]\")"), this, SLOT(slotRegExprMenuCharSet()));
  options->insertItem(i18n("Zero or more previous characters ('*')"), this, SLOT(slotRegExprMenuZOMPChars()));
  options->insertItem(i18n("One or more previous characters ('+')"), this, SLOT(slotRegExprMenuOOMPChars()));
  options->insertItem(i18n("Previous character is optional ('?')"), this, SLOT(slotRegExprMenuPCharOpt()));
  options->insertItem(i18n("Escape character ('\\')"), this, SLOT(slotRegExprMenuEscape()));
  options->insertSeparator();
  options->insertItem(i18n("Tab character ('\\t')"), this, SLOT(slotRegExprMenuTab()));
  options->insertItem(i18n("Newline character ('\\n')"), this, SLOT(slotRegExprMenuNewLine()));
  options->insertItem(i18n("Return character ('\\r')"), this, SLOT(slotRegExprMenuReturn()));
  options->insertItem(i18n("White Space chracter ('\\s')"), this, SLOT(slotRegExprMenuWhiteSpace()));

	fv_bend->mOptions->setPopup(options);
	fv_bend->mOptions->setPopupDelay(0);
	fv_bend->mOptions->setPixmap(KIconLoader().loadIcon("edit", KIcon::Small));	
}

FilterRuleDialog::~FilterRuleDialog()
{
}

void FilterRuleDialog::slotOk(void)
{
	slotApply();
	slotClose();
}


void FilterRuleDialog::slotApply(void)
{
	mFilterRule.setLocation((FilterRule::Location)fv_bend->mLocation->currentItem());
	mFilterRule.setTest((FilterRule::Test)fv_bend->mTest->currentItem());
	mFilterRule.setRegularExpression(fv_bend->mRegExp->text());
	if(fv_bend->mAllow->isChecked())
		mFilterRule.setAction(FilterRule::Allow);
	else
		mFilterRule.setAction(FilterRule::Deny);
		
	mSaveFilterRule = true;
}

void FilterRuleDialog::slotClose(void)
{
	reject();
}

void FilterRuleDialog::setFilterRule(const FilterRule & f)
{
	mFilterRule = f;
		
	fv_bend->mLocation->setCurrentItem((int)mFilterRule.location());
	fv_bend->mTest->setCurrentItem((int)mFilterRule.test());
	fv_bend->mRegExp->setText(mFilterRule.regularExpression());
	if(mFilterRule.action() == FilterRule::Allow) {
		fv_bend->mAllow->setChecked(true);
		fv_bend->mDeny->setChecked(false);
	}
	else {
		fv_bend->mAllow->setChecked(false);
		fv_bend->mDeny->setChecked(true);
	}
}

bool FilterRuleDialog::editFilterRule(FilterRule & f, bool isnew)
{
	FilterRuleDialog frDlg;
	frDlg.setFilterRule(f);
	frDlg.enableButtonApply(!isnew);
	frDlg.exec();
	if(frDlg.saveFilterRule()) {
		f = frDlg.getFilterRule();
		return true;
	}
	return false;
}

void FilterRuleDialog::slotRegExprMenuAnyChar(void)
{
	fv_bend->mRegExp->insert(QString("."));
}

void FilterRuleDialog::slotRegExprMenuSOI(void)
{
	fv_bend->mRegExp->insert(QString("^"));
}

void FilterRuleDialog::slotRegExprMenuEOI(void)
{
	fv_bend->mRegExp->insert(QString("$"));
}

void FilterRuleDialog::slotRegExprMenuCharSet(void)
{
	fv_bend->mRegExp->insert(QString("[]"));
}

void FilterRuleDialog::slotRegExprMenuZOMPChars(void)
{
	fv_bend->mRegExp->insert(QString("*"));
}

void FilterRuleDialog::slotRegExprMenuOOMPChars(void)
{
	fv_bend->mRegExp->insert(QString("+"));
}

void FilterRuleDialog::slotRegExprMenuPCharOpt(void)
{
	fv_bend->mRegExp->insert(QString("?"));
}

void FilterRuleDialog::slotRegExprMenuEscape(void)
{
	fv_bend->mRegExp->insert(QString("\\"));
}

void FilterRuleDialog::slotRegExprMenuTab(void)
{
	fv_bend->mRegExp->insert(QString("\\t"));
}

void FilterRuleDialog::slotRegExprMenuNewLine(void)
{
	fv_bend->mRegExp->insert(QString("\\n"));
}

void FilterRuleDialog::slotRegExprMenuReturn(void)
{
	fv_bend->mRegExp->insert(QString("\\r"));
}

void FilterRuleDialog::slotRegExprMenuWhiteSpace(void)
{
	fv_bend->mRegExp->insert(QString("\\s"));
}
