/***************************************************************************
                          filterruledialog.h  -  description
                             -------------------
    begin                : Mon Oct 15 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FILTERRULEDIALOG_H
#define FILTERRULEDIALOG_H

#include <qwidget.h>
#include <kdialogbase.h>

#include "filterrule.h"

class FilterRuleViewBackEnd;
/**
  *@author Chris Wallace
  */

class FilterRuleDialog : public KDialogBase  {
   Q_OBJECT
	public:
		FilterRuleDialog(QWidget *parent=0, const char *name=0);
		~FilterRuleDialog();
		
		void setFilterRule(const FilterRule & f);
		const FilterRule & getFilterRule(void) {return mFilterRule;}
		
		static bool editFilterRule(FilterRule & f, bool isnew = false);
		
		bool saveFilterRule(void) {return mSaveFilterRule;}
		
	protected slots:
		void slotOk(void);
		void slotApply(void);
		void slotClose(void);
		
		void slotRegExprMenuAnyChar(void);
		void slotRegExprMenuSOI(void);
		void slotRegExprMenuEOI(void);
		void slotRegExprMenuCharSet(void);
		void slotRegExprMenuZOMPChars(void);
		void slotRegExprMenuOOMPChars(void);
		void slotRegExprMenuPCharOpt(void);
		void slotRegExprMenuEscape(void);
		void slotRegExprMenuTab(void);
		void slotRegExprMenuNewLine(void);
		void slotRegExprMenuReturn(void);
		void slotRegExprMenuWhiteSpace(void);
		
	private:
		FilterRuleViewBackEnd *fv_bend;
		FilterRule mFilterRule;
		bool mSaveFilterRule;
		
};

#endif
