/***************************************************************************
                          krss.cpp  -  description
                             -------------------
    begin                : Sat Aug  4 15:59:19 CEST 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for QT
#include <qdir.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qpixmap.h>
#include <qtextstream.h>
#include <qscrollbar.h>
#include <qsplitter.h>
#include <qlayout.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstdaction.h>
#include <kstddirs.h>
#include <kstddirs.h>
#include <kiconloader.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <kprocess.h>
#include <kpopupmenu.h>
#include <ktip.h>
#include <ksystemtray.h>
#include <kwin.h>
#include <kwinmodule.h>
#include <khtml_part.h>
#include <khtmlview.h>


// application specific includes
#include "krss.h"
#include "transferdialog.h"
#include "editfeeddialog.h"
#include "configuredialog.h"
#include "syncdialog.h"
#include "mychannelbar.h"
#include "filterdialog.h"
#include "amphetadeskinport.h"
#include "schemetree.h"
#include "schemeparser.h"

#define ID_STATUS_MSG 1

KrssApp::KrssApp(QWidget* , const char* name)
: KMainWindow(0, name)
{
	mQuitRequested = false;
	mAllowScrolling = true;
	mHasBeenCleared = false;
 	mManualScrolling = false;
	
	checkDirectories();
	
	mSiteHandler.readSites();
	
  config=kapp->config();

  config->setGroup(QString("General"));
  QString mExec = config->readEntry(QString("Open URLs With"), QString::null);
	if(mExec.isEmpty() || mExec.isNull())
		config->writeEntry(QString("Open URLs With"), QString("konqueror %url"));
		
	QStringList uh_list = config->readListEntry(QString("URL Handlers"));
	if(uh_list.count() < 1) {
		uh_list.append(QString("konqueror %url"));
		uh_list.append(QString("netscape %url"));
		uh_list.append(QString("mozilla %url"));
		config->writeEntry(QString("URL Handlers"), uh_list);
	}

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initStatusBar();
  initActions();

  mSplitter = new QSplitter(this);

  mQuickLink = new MyChannelBar(config, &mSiteHandler, mSplitter, "mQuickLink");
  mQuickLink->setItemsMovable(false);
  //mQuickLink->resize(200, mQuickLink->height());
  connect(mQuickLink, SIGNAL(executed(QIconViewItem *)), this, SLOT(slotQuickLinkExecute(QIconViewItem *)));
  connect(mQuickLink, SIGNAL(signalRefresh()), this, SLOT(slotRefresh()));
  connect(mQuickLink, SIGNAL(signalMyChannelBarPopupMenu(const QString &, const QPoint &)), this, SLOT(slotMyChannelBarPopupMenu(const QString &, const QPoint &)));


	config->setGroup(QString("MyChannelBar"));
	mQuickLink->setAutoArrange(config->readBoolEntry(QString("Auto Arrange"), true));
	
	if(config->readBoolEntry(QString("Arrangement"), false))
		mQuickLink->setArrangement(QIconView::TopToBottom);
	else
		mQuickLink->setArrangement(QIconView::LeftToRight);
		
	if(config->readBoolEntry(QString("Resize"), true))
		mQuickLink->setResizeMode(QIconView::Adjust);
	else
		mQuickLink->setResizeMode(QIconView::Fixed);
	
	mQuickLink->setWordWrapIconText(config->readBoolEntry(QString("WordWrap"), true));
	mQuickLink->setMaxItemTextLength(config->readNumEntry(QString("Max Text Length"), 100));
	
	if(config->readBoolEntry(QString("Text Position"), false))
		mQuickLink->setItemTextPos(QIconView::Right);
	else
		mQuickLink->setItemTextPos(QIconView::Bottom);
		
	mQuickLink->setGridX(config->readNumEntry(QString("Grid X"), 128));
	mQuickLink->setGridY(config->readNumEntry(QString("Grid Y"), 32));
		

  mHTMLReader = new KHTMLPart(mSplitter, "mHTMLReader");
  connect(mHTMLReader->browserExtension(), SIGNAL(openURLRequest(const KURL &, const KParts::URLArgs &)), this, SLOT(slotOpenURLRequest(const KURL &, const KParts::URLArgs &)));
  connect(mHTMLReader, SIGNAL(onURL(const QString & )), this, SLOT(slotOnURL(const QString & )));
  connect(mHTMLReader, SIGNAL(popupMenu(const QString & , const QPoint &)), this, SLOT(slotPopupMenu(const QString &, const QPoint &)));
  connect(mHTMLReader->view()->verticalScrollBar(), SIGNAL(sliderPressed()), this, SLOT(slotManualScrollingOn()));
  connect(mHTMLReader->view()->verticalScrollBar(), SIGNAL(sliderReleased()), this, SLOT(slotManualScrollingOff()));
  setCentralWidget(mSplitter);

  doSplash();

	readOptions();

  ///////////////////////////////////////////////////////////////////
  // disable actions at startup
  filePrint->setEnabled(true);

  slotToggleScrolling();
 	
 	connect(&mScrollTimer, SIGNAL(timeout()), this, SLOT(slotScrollTimer()));
	mScrollTimer.start(200, false);
	
	connect(&mAutoUpdateTimer, SIGNAL(timeout()), this, SLOT(slotAutoUpdateTimer()));
	config->setGroup(QString("Auto Update"));
	if(config->readBoolEntry(QString("Use AutoUpdate"), false))
		mAutoUpdateTimer.start(15000, false);
		
	mWinModule = new KWinModule(this);
	connect(mWinModule, SIGNAL(windowChanged(WId)), this, SLOT(slotWindowChanged(WId)));
	config->setGroup(QString("General"));
	viewAlwaysOnTop->setChecked(config->readBoolEntry(QString("Always On Top"), false));
	doAlwaysOnTop();
	
	KTipDialog::showTip(/*KStandardDirs::kde_default("data") + QString("krss/tips")*/);
	
	mTray = new KSystemTray(this, "mTray");
	mTray->hide();
	mTray->setPixmap(KIconLoader().loadIcon("krss", KIcon::Small));
}

KrssApp::~KrssApp()
{
	if(mAutoUpdateTimer.isActive())
		mAutoUpdateTimer.stop();
	if(mScrollTimer.isActive())
		mScrollTimer.stop();
}

void KrssApp::initActions()
{
  fileNewWindow = new KAction(i18n("New &Window"), QPixmap(KGlobal::iconLoader()->iconPath("window_new", KIcon::Small)), 0, this, SLOT(slotFileNewWindow()), actionCollection(),"file_new_window");
  fileGetFeeds = new KAction(i18n("Get News..."), QPixmap(KGlobal::iconLoader()->iconPath("getrssfeeds", KIcon::Small)), 0, this, SLOT(slotGetFeeds()), actionCollection(), "file_new");
  fileGetThisFeed = new KAction(i18n("Get This Feed..."), QPixmap(KGlobal::iconLoader()->iconPath("getrssfeeds", KIcon::Small)), 0, this, SLOT(slotGetJustThisFeed()), actionCollection(), "file_just_get_this_feed");
  filePrint = KStdAction::print(this, SLOT(slotFilePrint()), actionCollection());
  fileQuit = KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection());
  viewToolBar = KStdAction::showToolbar(this, SLOT(slotViewToolBar()), actionCollection());
  viewStatusBar = KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), actionCollection());
  viewQuickLinks = new KToggleAction(i18n("Show MyChannelBar"), 0, this, SLOT(slotViewQuickLinks()), actionCollection(), "viewQuickLinks");
  clearViewer = new KToggleAction(i18n("Clear Viewer"), 0, this, SLOT(slotToggleClearViewer()), actionCollection(), "clearviewer");
  viewAlwaysOnTop = new KToggleAction(i18n("Stays On Top"), 0, this, SLOT(slotToggleAlwaysOnTop()), actionCollection(), "viewAlwaysOnTop");
  //viewDisplayRootWindow = new KToggleAction(i18n("Display In Root Window"), 0, this, SLOT(slotToggleDisplayInRootWindow()), actionCollection(), "viewDisplayInRoot");

  amphetaDeskImport = new KAction(i18n("Import Sites from AmphetaDesk..."), 0, this, SLOT(slotImportAmphetaDesk()), actionCollection(), "amphetadesk_import");

  scrollToggle = new KToggleAction(i18n("Scroll Feeds"), 0, this, SLOT(slotToggleScrolling()), actionCollection(), "scrolltoggle");
  feedSetup = new KAction(i18n("&MyFeeds..."), QPixmap(KGlobal::iconLoader()->iconPath("editrssfeeds", KIcon::Small)), 0, this, SLOT(slotEditFeeds()), actionCollection(), "feedsetup");
  krssSetup = new KAction(i18n("Configure..."), QPixmap(KGlobal::iconLoader()->iconPath("configure", KIcon::Small)), 0, this, SLOT(slotConfigure()), actionCollection(), "krsssetup");
  feedSync = new KAction(i18n("Share Feeds..."), QPixmap(KGlobal::iconLoader()->iconPath("kdmconfig", KIcon::Small)), 0, this, SLOT(slotSyncFeeds()), actionCollection(), "feedsync");

  keySetup = new KAction(i18n("Configure Keys..."), 0, this, SLOT(slotConfigureKeys()), actionCollection(), "keysetup");
  toolbarSetup = new KAction(i18n("Configure Toolbars..."), 0, this, SLOT(slotConfigureToolbars()), actionCollection(), "toolbarsetup");
  filterSetup = new KAction(i18n("MyFilters..."), QPixmap(KGlobal::iconLoader()->iconPath("filter", KIcon::Small)), 0, this, SLOT(slotEditFilters()), actionCollection(), "filtersetup");

  fileNewWindow->setStatusText(i18n("Opens a new application window"));
  fileGetFeeds->setStatusText(i18n("Gets The News"));
  filePrint ->setStatusText(i18n("Prints out the actual document"));
  fileQuit->setStatusText(i18n("Quits the application"));
  viewToolBar->setStatusText(i18n("Enables/disables the toolbar"));
  viewStatusBar->setStatusText(i18n("Enables/disables the statusbar"));
  viewQuickLinks->setStatusText(i18n("Enables/disables the MyChannelBar"));

  scrollToggle->setStatusText(i18n("Enables/disables scrolling of the feeds"));

  feedSetup->setStatusText(i18n("Configure the feeds"));
  krssSetup->setStatusText(i18n("Configure KRSS"));
  feedSync->setStatusText(i18n("Share feeds you or others have discovered"));
  keySetup->setStatusText(i18n("Configure key bindings"));
  toolbarSetup->setStatusText(i18n("Configure the toolbar"));
  clearViewer->setStatusText(i18n("Temporarily clears the viewer of any active feeds."));

  scrollToggle->setChecked(mAllowScrolling);

  // use the absolute path to your krssui.rc file for testing purpose in createGUI();
  createGUI();
  //createGUI();
}


void KrssApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
  // TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG);
  mProgress = new QProgressBar(statusBar());
  //mProgress->setProgress(50);
}

void KrssApp::saveOptions()
{	
  config->setGroup("General Options");
  config->writeEntry("Geometry", size());
  config->writeEntry("Show Toolbar", viewToolBar->isChecked());
  config->writeEntry("Show Statusbar",viewStatusBar->isChecked());
  config->writeEntry("ToolBarPos", (int) toolBar("mainToolBar")->barPos());
  config->writeEntry("Show QuickLinks", viewQuickLinks->isChecked());
  //fileOpenRecent->saveEntries(config,"Recent Files");
}


void KrssApp::readOptions()
{
	
  config->setGroup("General Options");

  // bar status settings
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
  viewToolBar->setChecked(bViewToolbar);
  slotViewToolBar();

  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  viewStatusBar->setChecked(bViewStatusbar);
  slotViewStatusBar();

  bool bViewQuickLinks = config->readBoolEntry("Show QuickLinks", true);
  viewQuickLinks->setChecked(bViewQuickLinks);
  slotViewQuickLinks();


  // bar position settings
  KToolBar::BarPosition toolBarPos;
  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);
  toolBar("mainToolBar")->setBarPos(toolBarPos);
	
  // initialize the recent file list
  //fileOpenRecent->loadEntries(config,"Recent Files");

  QSize size=config->readSizeEntry("Geometry");
  if(!size.isEmpty())
  {
    resize(size);
  }
}

bool KrssApp::queryClose()
{
	mQuitRequested = true;
	if(mLoadingSites)
		return false;
  return true; //doc->saveModified();
}

bool KrssApp::queryExit()
{
	mQuitRequested = true;
	if(mLoadingSites)
		return false;
  saveOptions();
  return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void KrssApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new application window..."));
	
  KrssApp *new_window= new KrssApp();
  new_window->show();

  slotStatusMsg(i18n("Ready."));
}

void KrssApp::slotGetFeeds()
{
	mAutoUpdateTimer.stop();
	
	setActionsEnabled(false);
	
	if(mHasBeenCleared) {
		mSiteHandler.readSites();
		clearViewer->setChecked(false);
		mHasBeenCleared = false;
	}
	
	config->setGroup(QString("General"));
	config->writeEntry(QString("Start of Last Update"), QDateTime::currentDateTime());
	
  TransferDialog::getFeeds(&mSiteHandler);

  displaySites();
	
	mAutoUpdateTimer.stop();
	config->setGroup(QString("Auto Update"));
	config->writeEntry(QString("Last Update"), QDateTime::currentDateTime());
	if(config->readBoolEntry(QString("Use AutoUpdate"), false))
		mAutoUpdateTimer.start(15000, false);
		
	setActionsEnabled(true);
}

void KrssApp::slotGetJustThisFeed()
{
	mAutoUpdateTimer.stop();
	
	setActionsEnabled(false);
	
	if(mHasBeenCleared) {
		mSiteHandler.readSites();
		clearViewer->setChecked(false);
		mHasBeenCleared = false;
	}
	
	config->setGroup(QString("General"));
	config->writeEntry(QString("Start of Last Update"), QDateTime::currentDateTime());
	
  TransferDialog::getFeeds(&mSiteHandler, mMyChannelBarCurrentFeed);

  displaySites();
	
	mAutoUpdateTimer.stop();
	config->setGroup(QString("Auto Update"));
	config->writeEntry(QString("Last Update"), QDateTime::currentDateTime());
	if(config->readBoolEntry(QString("Use AutoUpdate"), false))
		mAutoUpdateTimer.start(15000, false);
		
	setActionsEnabled(true);
}

void KrssApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));

 	mHTMLReader->view()->print();

  slotStatusMsg(i18n("Ready."));
}

void KrssApp::slotFileQuit()
{
  slotStatusMsg(i18n("Exiting..."));
  saveOptions();
  // close the first window, the list makes the next one the first again.
  // This ensures that queryClose() is called on each window to ask for closing
  KMainWindow* w;
  if(memberList)
  {
    for(w=memberList->first(); w!=0; w=memberList->next())
    {
      // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
      // the window and the application stay open.
      if(!w->close())
				break;
    }
  }	
  slotStatusMsg(i18n("Ready."));
}

void KrssApp::slotViewToolBar()
{
  slotStatusMsg(i18n("Toggling toolbar..."));
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  if(!viewToolBar->isChecked())
  {
    toolBar("mainToolBar")->hide();
  }
  else
  {
    toolBar("mainToolBar")->show();
  }		

  slotStatusMsg(i18n("Ready."));
}

void KrssApp::slotViewStatusBar(void)
{
  slotStatusMsg(i18n("Toggle the statusbar..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  if(!viewStatusBar->isChecked())
  {
    statusBar()->hide();
  }
  else
  {
    statusBar()->show();
  }

  slotStatusMsg(i18n("Ready."));
}

void KrssApp::slotToggleScrolling(void)
{
	slotStatusMsg(i18n("Toggle the scrolling..."));
	///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
	mAllowScrolling = scrollToggle->isChecked();
	
	if(mAllowScrolling)
		scrollToggle->setIconSet(QIconSet(KIconLoader().loadIcon("player_pause", KIcon::Small)));
	else
		scrollToggle->setIconSet(QIconSet(KIconLoader().loadIcon("player_start", KIcon::Small)));

  slotStatusMsg(i18n("Ready."));
}


void KrssApp::slotStatusMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG);
}

void KrssApp::slotOnURL(const QString & url)
{
	if(url.isEmpty() || url.isNull())
		slotStatusMsg(QString("Ready"));
	else {
		if(url.length() > 55) {
			QString left = url.left(32);
			QString right = url.right(20);
			slotStatusMsg(left + QString("...") + right);
		}
		else
			slotStatusMsg(url);
	}
}

void KrssApp::slotEditFeeds()
{
	setActionsEnabled(false);
	
	mAutoUpdateTimer.stop();
	
	if(mHasBeenCleared) {
		mSiteHandler.readSites();
		clearViewer->setChecked(false);
		mHasBeenCleared = false;
	}
	
	EditFeedDialog::editFeeds(config, &mSiteHandler);
	
	displaySites();
	
	mSiteHandler.writeSites();
	
	config->setGroup(QString("Auto Update"));
	config->writeEntry(QString("Last Update"), QDateTime::currentDateTime());
	if(config->readBoolEntry(QString("Use AutoUpdate"), false))
		mAutoUpdateTimer.start(15000, false);
		
	setActionsEnabled(true);
}

void KrssApp::slotScrollTimer(void)
{
	if(mAllowScrolling && !mHasBeenCleared && !mManualScrolling) {
		config->setGroup(QString("General"));
		if(config->readBoolEntry(QString("Scroll Feeds"), true)) {
			mHTMLReader->view()->scrollBy(0, config->readNumEntry(QString("Scrolling Speed"), 2));
			if(config->readBoolEntry(QString("Loop Feeds"), true)) {
				if(mHTMLReader->view()->verticalScrollBar()) {
					if(mHTMLReader->view()->verticalScrollBar()->value() >= mHTMLReader->view()->verticalScrollBar()->maxValue()) {
						mHTMLReader->view()->verticalScrollBar()->setValue(0);
					}
				}
			}
		}
	}
}

void KrssApp::slotOpenURLRequest(const KURL &url, const KParts::URLArgs &)
{
	config->setGroup(QString("General"));
	QString mExec = config->readEntry(QString("Open URLs With"), QString("konqueror %url"));
	mExec.replace(QString("%url"), url.url());
		
	slotStatusMsg(i18n("Starting ") + mExec + QString("..."));
	
	KProcess p; // = new KProcess;
	QTextStream t(&mExec, IO_ReadOnly);
	while(!t.atEnd()) {
		QString mStr;
		t >> mStr;
		p << mStr;
	}
	cerr << endl;
	
	p.start(KProcess::DontCare);
}

void KrssApp::slotConfigure(void)
{
	setActionsEnabled(false);
	
	mAutoUpdateTimer.stop();
	ConfigureDialog::configure(config);
	
	SchemeTree st;
	SchemeParser::parseFile(QDir::homeDirPath() + QString("/.krss/schemes/currentscheme"), st);	
	
	mQuickLink->setItemColours(st.myChannelBarNewFeedColour(), st.myChannelBarTextColour());
	
	config->setGroup(QString("General"));
	viewAlwaysOnTop->setChecked(config->readBoolEntry(QString("Always On Top"), false));
	doAlwaysOnTop();
	
	config->setGroup(QString("MyChannelBar"));
	mQuickLink->setAutoArrange(config->readBoolEntry(QString("Auto Arrange"), true));
	
	mQuickLink->expirationChanged();
	
	if(config->readBoolEntry(QString("Arrangement"), false))
		mQuickLink->setArrangement(QIconView::TopToBottom);
	else
		mQuickLink->setArrangement(QIconView::LeftToRight);
		
	if(config->readBoolEntry(QString("Resize"), true))
		mQuickLink->setResizeMode(QIconView::Adjust);
	else
		mQuickLink->setResizeMode(QIconView::Fixed);
	
	mQuickLink->setWordWrapIconText(config->readBoolEntry(QString("WordWrap"), true));
	mQuickLink->setMaxItemTextLength(config->readNumEntry(QString("Max Text Length"), 100));
	
		
	if(config->readBoolEntry(QString("Text Position"), false))
		mQuickLink->setItemTextPos(QIconView::Right);
	else
		mQuickLink->setItemTextPos(QIconView::Bottom);
		
	mQuickLink->setGridX(config->readNumEntry(QString("Grid X"), 128));
	mQuickLink->setGridY(config->readNumEntry(QString("Grid Y"), 32));
	
	mAutoUpdateTimer.stop();
	
	unsigned int scrollBarPos = mHTMLReader->view()->verticalScrollBar()->value();
	
	displaySites();
	
	mHTMLReader->view()->verticalScrollBar()->setValue(scrollBarPos);
		
	config->setGroup(QString("Auto Update"));
	if(config->readBoolEntry(QString("Use AutoUpdate"), false))
		mAutoUpdateTimer.start(15000, false);
		
	setActionsEnabled(true);
	
}

void KrssApp::slotAutoUpdateTimer(void)
{
	//If the last time that we checked was old than the update date then we need to update
	config->setGroup(QString("Auto Update"));
	QDateTime cdt = QDateTime::currentDateTime();
	QDateTime ldt = config->readDateTimeEntry(QString("Last Update"));
	if(config->readBoolEntry(QString("Use AutoUpdate"), false)) {
		ldt = ldt.addDays(config->readNumEntry(QString("Days To Update"), 1));
		ldt = ldt.addSecs(60*60*config->readNumEntry(QString("Hours To Update"), 0));
		ldt = ldt.addSecs(60*config->readNumEntry(QString("Minutes To Update"), 0));
		if(ldt < cdt) {
			slotGetFeeds();
		}
	}
}

void KrssApp::slotSyncFeeds(void)
{
	mAutoUpdateTimer.stop();
	
	setActionsEnabled(false);
	
	/*
	SyncDialog::syncFeeds(config);
	
	config->setGroup(QString("Feed Sync"));
	config->writeEntry(QString("Have Synced"), true);
	config->writeEntry(QString("Last Sync"), QDateTime::currentDateTime());
	*/
	
	KMessageBox::sorry(0, i18n("This feature is currently disabled, since the\n database request is still being processed at Sourceforge."), i18n("Sorry"), false);
	
	config->setGroup(QString("Auto Update"));
	if(config->readBoolEntry(QString("Use AutoUpdate"), false))
		mAutoUpdateTimer.start(15000, false);
		
	setActionsEnabled(true);
}

void KrssApp::checkDirectories(void)
{
	QDir d(QDir::homeDirPath() + QString("/.krss"));
	if(!d.exists()) {
		if(!d.mkdir(QDir::homeDirPath() + QString("/.krss"), true)) {
			KMessageBox::error(0, i18n("Could not create: ") + QDir::homeDirPath() + QString("/.krss"), i18n("Error"), false);
		}
	}
	d.setPath(QDir::homeDirPath() + QString("/.krss/feeds"));
	if(!d.exists()) {
		if(!d.mkdir(QDir::homeDirPath() + QString("/.krss/feeds"), true)) {
			KMessageBox::error(0, i18n("Could not create: ") + QDir::homeDirPath() + QString("/.krss/feeds"), i18n("Error"), false);
		}
	}	
	d.setPath(QDir::homeDirPath() + QString("/.krss/feeds/unparsed"));
	if(!d.exists()) {
		if(!d.mkdir(QDir::homeDirPath() + QString("/.krss/feeds/unparsed"), true)) {
			KMessageBox::error(0, i18n("Could not create: ") + QDir::homeDirPath() + QString("/.krss/feeds/unparsed"), i18n("Error"), false);
		}
	}
	d.setPath(QDir::homeDirPath() + QString("/.krss/feeds/parsed"));
	if(!d.exists()) {
		if(!d.mkdir(QDir::homeDirPath() + QString("/.krss/feeds/parsed"), true)) {
			KMessageBox::error(0, i18n("Could not create: ") + QDir::homeDirPath() + QString("/.krss/feeds/parsed"), i18n("Error"), false);
		}
		//We have an older version?
		/**If we have old files from a previous installation then we need to move them **/
		mSiteHandler.fixSiteFile_2_2();
		
		d.setFilter(QDir::Files | QDir::NoSymLinks);
		d.setPath(QDir::homeDirPath() + QString("/.krss/feeds"));
		
		const QFileInfoList *list = d.entryInfoList();
    QFileInfoListIterator it( *list );      // create list iterator
    QFileInfo *fi;                          // pointer for traversing

    QDir dm;
    QString frompath = QDir::homeDirPath() + QString("/.krss/feeds/");
    QString topath = QDir::homeDirPath() + QString("/.krss/parsed/");
    while ( (fi=it.current()) ) {           // for each file...
    	dm.rename(frompath + fi->fileName(), topath + fi->fileName());
      ++it;                               // goto next list element
    }		
	}
	
	d.setPath(QDir::homeDirPath() + QString("/.krss/cache"));
	if(!d.exists()) {
		if(!d.mkdir(QDir::homeDirPath() + QString("/.krss/cache"), true)) {
			KMessageBox::error(0, i18n("Could not create: ") + QDir::homeDirPath() + QString("/.krss/cache"), i18n("Error"), false);
		}
	}
	d.setPath(QDir::homeDirPath() + QString("/.krss/schemes"));
	if(!d.exists()) {
		if(!d.mkdir(QDir::homeDirPath() + QString("/.krss/schemes"), true)) {
			KMessageBox::error(0, i18n("Could not create: ") + QDir::homeDirPath() + QString("/.krss/schemes"), i18n("Error"), false);
		}
	}
	d.setPath(QDir::homeDirPath() + QString("/.krss/tmp"));
	if(!d.exists()) {
		if(!d.mkdir(QDir::homeDirPath() + QString("/.krss/tmp"), true)) {
			KMessageBox::error(0, i18n("Could not create: ") + QDir::homeDirPath() + QString("/.krss/schemes"), i18n("Error"), false);
		}
	}
	
	checkSiteFile();
}

void KrssApp::checkSiteFile(void)
{
	QString filename = QString(QDir::homeDirPath() + QString("/.krss/sites.xml"));
	QFile f(filename);
	if(f.exists()) return;
		
	addSite(mSiteHandler, false, QString("4 Arrow Samples"), KURL("http://4arrow.com/users/my/html/newest_4arrow_coding_samples.php"), QString::null);
	addSite(mSiteHandler, false, QString("Ap International"), KURL("http://www.ecn.purdue.edu/~jacoby/Portal/ap_int.cgi"), QString::null);
	addSite(mSiteHandler, false, QString("Artificial Cheese"), KURL("http://www.artificialcheese.com/autopost/news.cdf"), QString::null);
	addSite(mSiteHandler, false, QString("Benews"), KURL("http://www.benews.com/story/news_hound/6"), QString::null);
	addSite(mSiteHandler, false, QString("Benews 2"), KURL("http://www.benews.com/ns_xml.hei"), QString::null);
	addSite(mSiteHandler, false, QString("Benews 3"), KURL("http://www.benews.com/headlines.hei"), QString::null);
	addSite(mSiteHandler, false, QString("CNN Arts and Style"), KURL("http://csociety.purdue.org/~jacoby/XML/CNN_ARTS_&_STYLE.xml"), QString::null);
	addSite(mSiteHandler, false, QString("CNN Books"), KURL("http://csociety.purdue.org/~jacoby/XML/CNN_BOOKS.xml"), QString::null);
	addSite(mSiteHandler, false, QString("CNN Business News"), KURL("http://csociety.purdue.org/~jacoby/XML/CNN_BUSINESS_from_CNNfn.com.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Foxnews World"), KURL("http://headlines.isyndicate.com/pages/kkdqriax/FoxNews_WorldNews.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Ironminds"), KURL("http://headlines.isyndicate.com/pages/kkdqriax/MST3K_Writers.rss"), QString::null);
	addSite(mSiteHandler, false, QString("NYT Frontpage"), KURL("http://headlines.isyndicate.com/pages/kkdqriax/NYTimesHeadlines.rss"), QString::null);
	addSite(mSiteHandler, false, QString("NYT Intl"), KURL("http://headlines.isyndicate.com/pages/kkdqriax/NYTimesIntl.rss"), QString::null);
	addSite(mSiteHandler, false, QString("NYT Science"), KURL("http://headlines.isyndicate.com/pages/kkdqriax/NYTimesTech.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Tech"), KURL("http://headlines.isyndicate.com/pages/kkdqriax/technology.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Hacker News Network"), KURL("http://www.hackernews.com/misc/hnn.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Just Linux"), KURL("http://www.justlinux.com/backend/features.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Keeptabs Pub Lib"), KURL("http://www.keeptabs.com/keeptabs.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Linux Web Dev News"), KURL("http://www.LinuxWebDevNews.com/lwdn.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Monkey News"), KURL("http://trainedmonkey.com/news/rss.php?s=28"), QString::null);
	addSite(mSiteHandler, false, QString("Perl Month"), KURL("http://www.perlmonth.com/perlmonth.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Scripting News"), KURL("http://scriptingnews.userland.com/xml/scriptingnews2.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Slapd Net"), KURL("http://www.slapd.net/backend.php"), QString::null);
	addSite(mSiteHandler, false, QString("Write The Web"), KURL("http://trainedmonkey.com/news/rss.php?s=19"), QString::null);
	addSite(mSiteHandler, false, QString("Zez"), KURL("http://zez.org/article/rssheadlines"), QString::null);
	addSite(mSiteHandler, false, QString("Zope Newbies"), KURL("http://weblogs.userland.com/zopeNewbies/xml/rss.xml"), QString::null);
	addSite(mSiteHandler, false, QString("4 Arrow Services"), KURL("http://4arrow.com/users/my/html/4arrow_newest_eservices.php"), QString::null);
	addSite(mSiteHandler, false, QString("Advogato"), KURL("http://www.advogato.org/rss/articles.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Anime Fantasia"), KURL("http://www.animefantasia.com/backend.php"), QString::null);
	addSite(mSiteHandler, false, QString("Bebits Development"), KURL("http://www.bebits.com/backend/recent.rdf/3"), QString::null);
	addSite(mSiteHandler, false, QString("Bebits Drivers"), KURL("http://www.bebits.com/backend/recent.rdf/14"), QString::null);
	addSite(mSiteHandler, false, QString("Bebits Geek toys"), KURL("http://www.bebits.com/backend/recent.rdf/11"), QString::null);
	addSite(mSiteHandler, false, QString("Bebits Networking"), KURL("http://www.bebits.com/backend/recent.rdf/1"), QString::null);
	addSite(mSiteHandler, false, QString("Bebits Newest"), KURL("http://www.bebits.com/backend/recent.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Bebits System Files"), KURL("http://www.bebits.com/backend/recent.rdf/4"), QString::null);
	addSite(mSiteHandler, false, QString("Book Reviews"), KURL("http://p.moreover.com/cgi-local/page?index_bookreviews+rss"), QString::null);
	addSite(mSiteHandler, false, QString("Bottom Quark"), KURL("http://www.bottomquark.com/backend.php"), QString::null);
	addSite(mSiteHandler, false, QString("Brunching"), KURL("http://brunching.com/brunching.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("BSD Today"), KURL("http://www.bsdtoday.com/backend/bt.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("CERT"), KURL("http://www.cert.org/channels/certcc.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("CNet Personal"), KURL("http://trainedmonkey.com/news/rss.php?s=32"), QString::null);
	addSite(mSiteHandler, false, QString("CNet Tech News"), KURL("http://trainedmonkey.com/news/rss.php?s=31"), QString::null);
	addSite(mSiteHandler, false, QString("CNN Entertainment"), KURL("http://csociety.purdue.org/~jacoby/XML/CNN_ENTERTAINMENT.xml"), QString::null);
	addSite(mSiteHandler, false, QString("CNN Food"), KURL("http://csociety.purdue.org/~jacoby/XML/CNN_FOOD.xml"), QString::null);
	addSite(mSiteHandler, false, QString("CNN Politics"), KURL("http://csociety.purdue.org/~jacoby/XML/CNN_POLITICS.xml"), QString::null);
	addSite(mSiteHandler, false, QString("CNN Space"), KURL("http://csociety.purdue.org/~jacoby/XML/CNN_SPACE.xml"), QString::null);
	addSite(mSiteHandler, false, QString("CNN Sports"), KURL("http://csociety.purdue.org/~jacoby/XML/CNN_SPORTS_from_CNNSI.com.xml"), QString::null);
	addSite(mSiteHandler, false, QString("CNN Technology"), KURL("http://csociety.purdue.org/~jacoby/XML/CNN_TECHNOLOGY.xml"), QString::null);
	addSite(mSiteHandler, false, QString("CNN Top stories"), KURL("http://csociety.purdue.org/~jacoby/XML/CNN_TOP_STORIES.xml"), QString::null);
	addSite(mSiteHandler, false, QString("CNN Travel"), KURL("http://csociety.purdue.org/~jacoby/XML/CNN_TRAVEL.xml"), QString::null);
	addSite(mSiteHandler, false, QString("CNN US"), KURL("http://csociety.purdue.org/~jacoby/XML/CNN_US.xml"), QString::null);
	addSite(mSiteHandler, false, QString("CNN Weather"), KURL("http://csociety.purdue.org/~jacoby/XML/CNN_WEATHER.xml"), QString::null);
	addSite(mSiteHandler, false, QString("CNN World"), KURL("http://csociety.purdue.org/~jacoby/XML/CNN_WORLD.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Daemon News"), KURL("http://daily.daemonnews.org/ddn.rdf.php3"), QString::null);
	addSite(mSiteHandler, false, QString("Damian News"), KURL("http://yetanother.org/damian/news.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Desktopian"), KURL("http://desktopian.org/includes/headlines.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Digital Theatre"), KURL("http://www.dtheatre.com/backend.php3?xml=yes"), QString::null);
	addSite(mSiteHandler, false, QString("Doc Javascript"), KURL("http://www.webreference.com/js/tips/channels/last1015.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Drop"), KURL("http://www.drop.org/export.php?headlines.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Earth Observatory"), KURL("http://earthobservatory.nasa.gov/eo.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Ebiquity"), KURL("http://www.ebiquity.org/backend.php"), QString::null);
	addSite(mSiteHandler, false, QString("Evhead"), KURL("http://www.evhead.com/evhead_rss.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Freebsd Diary"), KURL("http://www.freebsddiary.org/news.php3"), QString::null);
	addSite(mSiteHandler, false, QString("Freshmeat"), KURL("http://freshmeat.net/backend/fm.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Gamedev"), KURL("http://www.gamedev.net/xml/"), QString::null);
	addSite(mSiteHandler, false, QString("Geeknews.net"), KURL("http://geeknews.net/backend.php"), QString::null);
	addSite(mSiteHandler, false, QString("Geeknik"), KURL("http://www.geeknik.net/backend.php"), QString::null);
	addSite(mSiteHandler, false, QString("Generation5"), KURL("http://csociety.purdue.org/~jacoby/XML/gen5.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Gigabit Ethernet News"), KURL("http://www.nwfusion.com:8080/rss/gigabit/query.html?col=archive1&col=edge&ws=0&qt=%2B%22Gigabit+Ethernet%22&qm=0&st=1&nh=10&rf=1"), QString::null);
	addSite(mSiteHandler, false, QString("Gimp News"), KURL("http://www.xach.com/gimp/news/channel.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Gnome News"), KURL("http://news.gnome.org/gnome-news/rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Guardian Unlimited"), KURL("http://www.newsunlimited.co.uk/rss/1,,,00.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Happypenguin"), KURL("http://happypenguin.org/html/news.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Hittpansophism"), KURL("http://hittpansophism.com/html/newsletter/quotes.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Hollywood Bitchslap"), KURL("http://hollywoodbitchslap.com/hbs.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Icewalkers"), KURL("http://www.icewalk.com/backend/netscape_channel.txt"), QString::null);
	addSite(mSiteHandler, false, QString("Intelligence Net"), KURL("http://www.intellnet.org/rdf/intellnet.html"), QString::null);
	addSite(mSiteHandler, false, QString("Internet News"), KURL("http://trainedmonkey.com/news/rss.php?s=5"), QString::null);
	addSite(mSiteHandler, false, QString("Jabber Central"), KURL("http://www.jabbercentral.com/rss.php"), QString::null);
	addSite(mSiteHandler, false, QString("KDE News"), KURL("http://dot.kde.org/rdf"), QString::null);
	addSite(mSiteHandler, false, QString("KDE News 2"), KURL("http://www.kde.org/news/kdenews.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Kumo"), KURL("http://www.lphty.com/kumo/backend.php"), QString::null);
	addSite(mSiteHandler, false, QString("Kuro5hin"), KURL("http://www.kuro5hin.org/backend.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("LA Times Comp"), KURL("http://trainedmonkey.com/news/rss.php?s=25"), QString::null);
	addSite(mSiteHandler, false, QString("LA Times Tech"), KURL("http://trainedmonkey.com/news/rss.php?s=26"), QString::null);
	addSite(mSiteHandler, false, QString("Librenix"), KURL("http://librenix.com/rss/"), QString::null);
	addSite(mSiteHandler, false, QString("Links"), KURL("http://csociety.purdue.org/~jacoby/XML/links.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Linux.com"), KURL("http://www.linux.com/mrn/front_page.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Linux Journal"), KURL("http://linuxjournal.com/news.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Linux Insider"), KURL("http://www.freenewsfeed.com/headlines/raw/?cat=linux&type=rss"), QString::null);
	addSite(mSiteHandler, false, QString("Linux Lock"), KURL("http://www.linuxlock.org/linuxlock.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Linux Net News"), KURL("http://www.netnews.opensrc.org/index.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Linux News"), KURL("http://www.linuxnews.com/backend/weblog.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Linux Today"), KURL("http://linuxtoday.com/backend/my-netscape.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Linux Weekly News"), KURL("http://lwn.net/headlines/rss"), QString::null);
	addSite(mSiteHandler, false, QString("Managed Care"), KURL("http://www.benefitslink.com/rdf/benefitslink-managedcare.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Meatball"), KURL("http://csociety.purdue.org/~jacoby/XML/meatballwiki.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Moreover"), KURL("http://p.moreover.com/cgi-local/page?&s=vnunet.com&o=rss"), QString::null);
	addSite(mSiteHandler, false, QString("Moreover Offbeat News"), KURL("http://www.moreover.com/cgi-local/page?index_offbeat+rss"), QString::null);
	addSite(mSiteHandler, false, QString("Motleyfool"), KURL("http://www.fool.com/About/headlines/rss_headlines.asp"), QString::null);
	addSite(mSiteHandler, false, QString("Mozilla"), KURL("http://www.mozilla.org/news.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Mozillazine"), KURL("http://www.mozillazine.org/contents.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("MS Geek"), KURL("http://www.msgeek.org/html/backend.php"), QString::null);
	addSite(mSiteHandler, false, QString("Multiagent"), KURL("http://www.multiagent.com/mynetscape.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Newsforge"), KURL("http://www.newsforge.com/newsforge.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Osinvestor"), KURL("http://www.osinvestor.com/backend/osinvestor.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Osopinion"), KURL("http://www.osopinion.com/OSOlinks2.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Palmstation"), KURL("http://www.palmstation.com/palmstation.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Parc Events"), KURL("http://www.parc.xerox.com/current/parc-events.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Pdabuzz"), KURL("http://www.pdabuzz.com/netscape.txt"), QString::null);
	addSite(mSiteHandler, false, QString("Peertal"), KURL("http://www.peertal.com/backend.php"), QString::null);
	addSite(mSiteHandler, false, QString("Perl News"), KURL("http://www.perl.com/pace/perlnews.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Perl Updates"), KURL("http://www.perl.com/p6pdigest.cgi?s=rdf"), QString::null);
	addSite(mSiteHandler, false, QString("PHP Weblog"), KURL("http://php.weblogs.com/xml/rss.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Plastic"), KURL("http://www.plastic.com/plastic.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Register"), KURL("http://www.theregister.co.uk/tonys/slashdot.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Request for Comments"), KURL("http://x42.com/rss/rfc.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Researchbuzz"), KURL("http://www.researchbuzz.com/researchbuzz.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Risks"), KURL("http://catless.ncl.ac.uk/rdigest.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Robots"), KURL("http://robots.net/rss/articles.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Rootprompt"), KURL("http://www.rootprompt.org/rss/"), QString::null);
	addSite(mSiteHandler, false, QString("RSS on RSS"), KURL("http://www.blogspace.com/rss/rss10"), QString::null);
	addSite(mSiteHandler, false, QString("Ruby Cookbook"), KURL("http://www.rubycookbook.org/rdf.rb"), QString::null);
	addSite(mSiteHandler, false, QString("Rubygarden"), KURL("http://www.rubygarden.org/cgi-bin/rubygarden-rss.rb"), QString::null);
	addSite(mSiteHandler, false, QString("Rubygarden DJ"), KURL("http://csociety.purdue.org/~jacoby/XML/rubygarden.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Salon"), KURL("http://www.salon.com/feed/RDF/salon_use.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Security Geeks"), KURL("http://www.shmoo.com/stampy.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Security Protocols"), KURL("http://www.security-protocols.com/backend.php"), QString::null);
	addSite(mSiteHandler, false, QString("Security Focus"), KURL("http://www.securityfocus.com/topnews-rdf.html"), QString::null);
	addSite(mSiteHandler, false, QString("Segfault"), KURL("http://segfault.org/stories.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Shell City"), KURL("http://shellcity.net/citynews.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Slashdot"), KURL("http://slashdot.org/slashdot.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Solaris Central"), KURL("http://www.solariscentral.org/news/SolarisCentral.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Sourceforge New Releases"), KURL("http://sourceforge.net/export/rss_sfnewreleases.php"), QString::null);
	addSite(mSiteHandler, false, QString("Sourceforge News"), KURL("http://sourceforge.net/export/rss_sfnews.php"), QString::null);
	addSite(mSiteHandler, false, QString("Space Today"), KURL("http://www.spacetoday.net/summaries.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Spacenews"), KURL("http://exosci.com/exosci.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("TBTF"), KURL("http://tbtf.com/tbtf.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Team Gop"), KURL("http://www.teamgop.com/teamgop-rss.php3"), QString::null);
	addSite(mSiteHandler, false, QString("Technique Features"), KURL("http://www.tech-nique.org/feed.php?category=features&type=rss&limit=10"), QString::null);
	addSite(mSiteHandler, false, QString("Technique Top Stories"), KURL("http://www.tech-nique.org/feed.php?category=top+stories&type=rss&limit=10"), QString::null);
	addSite(mSiteHandler, false, QString("The Beeb"), KURL("http://trainedmonkey.com/news/rss.php?s=18"), QString::null);
	addSite(mSiteHandler, false, QString("Thinkgeek"), KURL("http://www.thinkgeek.com/thinkgeek.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Use Perl"), KURL("http://use.perl.org/useperl.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Usemod"), KURL("http://csociety.purdue.org/~jacoby/XML/usemodwiki.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Vaults Parnassus"), KURL("http://www.vex.net/parnassus/parnassus.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Virus Warnings"), KURL("http://p.moreover.com/cgi-local/page?c=Virus%20warnings&o=rss"), QString::null);
	addSite(mSiteHandler, false, QString("W3M"), KURL("http://www.w3.org/2000/08/w3c-synd/home.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Winer on OSS"), KURL("http://www.ourfavoritesongs.com/users/dave@userland.com/rss/openSource.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Winer on RSS"), KURL("http://www.ourfavoritesongs.com/users/dave@userland.com/rss/rss.xml"), QString::null);
	addSite(mSiteHandler, false, QString("Wired"), KURL("http://www.wired.com/news_drop/netcenter/netcenter.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Wordoftheday"), KURL("http://www.dictionary.com/wordoftheday/wotd.rss"), QString::null);
	addSite(mSiteHandler, false, QString("XMLHack"), KURL("http://www.xmlhack.com/rsscat.php"), QString::null);
	addSite(mSiteHandler, false, QString("Yet Another Society"), KURL("http://yetanother.org/yetanother.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("ZDNet-appwatch"), KURL("http://www.appwatch.com/appwatch.rdf"), QString::null);
	addSite(mSiteHandler, false, QString("Zope"), KURL("http://www.zope.org/SiteIndex/news.rss"), QString::null);
	addSite(mSiteHandler, false, QString("Zope Pproducts"), KURL("http://www.zope.org/Members/lalo/products.rss"), QString::null);
		
	mSiteHandler.writeSites();
	
}

void KrssApp::addSite(SiteHandler & mSites, bool used, const QString & name, const KURL & url, const QString & description)
{
	Site * s = new Site();
	s->setName(name);
	s->setURL(url);
	s->setDescription(description);
	s->setUsed(used);
	s->makeFileName();
	mSites.addSite(s);
}

void KrssApp::displaySites(void)
{
	statusBar()->addWidget(mProgress, -1, true);
	mProgress->show();
	
	cerr << "\tDisplaying Sites" << endl;
	
	slotStatusMsg(i18n("Reading Site Information..."));
	
	//SiteHandler sh;
	//sh.readSites();
	QString mText;
	
	mQuickLink->clear();
	
	bool haveSites = mSiteHandler.displayNews(config, mText, mProgress, kapp, mQuickLink);
	
	/*
	if(mQuitRequested) {
		mLoadingSites = false;
		kapp->quit();
	}
	*/
		
	if(!haveSites) {
		doSplash();
		mProgress->reset();
		statusBar()->removeWidget(mProgress);
		mProgress->hide();
	
		slotStatusMsg(i18n("Ready"));
		cerr << "\tDone (HaveSites)." << endl;
		return;
	}
	
	unsigned int tsize = mText.length();
	unsigned int hsize = 0;
	
	if(tsize == 0) tsize = 1;
	
	mHTMLReader->begin();
	mProgress->reset();
	
	slotStatusMsg(i18n("Converting Sites into HTML..."));
	
	QTextStream t(&mText, IO_ReadOnly);
	
	while(!t.atEnd()) {
		QString mLine = t.readLine();
		if(!(mLine.isEmpty() || mLine.isNull())) {
			hsize += mLine.length();
			mHTMLReader->write(mLine + QChar('\n'));
			mProgress->setProgress((hsize * 100) / tsize);
			kapp->processEvents(100);
		}
		/*
		if(mQuitRequested)
				break;
		*/
	}
	
	mHTMLReader->end();
	mProgress->reset();
	statusBar()->removeWidget(mProgress);
	mProgress->hide();
	
	slotStatusMsg(i18n("Ready"));
	cerr << "\tDone." << endl;
	/*
	if(mQuitRequested)
		kapp->quit();
	*/
}

void KrssApp::slotPopupMenu(const QString & url, const QPoint & p)
{
	if(url.isEmpty() || url.isNull()) {
		KPopupMenu *pop = (KPopupMenu *)factory()->container("html_popup", this);
		cerr << "html_popup" << endl;
		if(!pop)
			return;
		pop->popup(p);
	}
	else {
		KPopupMenu menu(this, "url_menu");
		menu.insertTitle(i18n("Open URL Using:"));
		config->setGroup(QString("General"));
		QStringList uh_list = config->readListEntry(QString("URL Handlers"));
		QString default_handler = config->readEntry(QString("Open URLs With"), QString("konqueror %url"));
		default_handler.replace(QString("%url"), url);
		menu.insertItem(default_handler);
		menu.insertSeparator();
		for(QStringList::Iterator i = uh_list.begin(); i != uh_list.end(); i++) {
			QString handler((*i).latin1());
			handler.replace(QString("%url"), url);
			menu.insertItem(handler);
		}
		int ret = menu.exec(p);
		if(ret == -1)
			return;
			
		QString mExec = menu.text(ret);
		//mExec.replace(QString("%url"), url);
		cerr << "Running: " << mExec << endl;
	
		slotStatusMsg(i18n("Starting ") + mExec + QString("..."));
	
		KProcess p; // = new KProcess;
		QTextStream t(&mExec, IO_ReadOnly);
		while(!t.atEnd()) {
			QString mStr;
			t >> mStr;
			p << mStr;
		}
	
		p.start(KProcess::DontCare);
		if(p.isRunning())
			cerr << "Process is running!" << endl;
	}
}

void KrssApp::slotMyChannelBarPopupMenu(const QString & site, const QPoint & p)
{
	if(site.isEmpty() || site.isNull()) {
		mMyChannelBarCurrentFeed = QString::null;
		fileGetThisFeed->setEnabled(false);
	}
	else {
		mMyChannelBarCurrentFeed = site;
		fileGetThisFeed->setEnabled(true);
	}
	
	KPopupMenu *pop = (KPopupMenu *)factory()->container("mychannelbar_popup", this);
	cerr << "mychannelbar_popup" << endl;
	if(!pop)
		return;
	pop->popup(p);
}

void KrssApp::doSplash(void)
{
	mHTMLReader->begin();
	mHTMLReader->write(QString("<html><title>Splash Screen</title>"));
	mHTMLReader->write(QString("<body>"));
	mHTMLReader->write(QString("<H1>K.R.S.S.</H1>"));
	mHTMLReader->write(QString("&nbsp;&nbsp;KDE's Only RDF Site Summmary Viewer"));
	mHTMLReader->write(QString("<hr>"));
	mHTMLReader->write(QString("<p>With KRSS gathering news from mutliple sites have never been easier.  Simple configure which feeds you want and let KRSS do the rest.</p>"));
	mHTMLReader->write(QString("<p><b>Three Quick Steps:</b></p>"));
	mHTMLReader->write(QString("<p>&nbsp;1) Use the menu bar to open the MyFeeds Dialog (Options -> MyFeeds)</p>"));
	mHTMLReader->write(QString("<p>&nbsp;2) Select the from the predefined feeds which sites you want to get news from or add your own</p>"));
	mHTMLReader->write(QString("<p>&nbsp;3) Click on Get News on the tool bar, or using the menu bar (File -> Get Feeds)</p>"));
	mHTMLReader->write(QString("<br><p>That is all there is to it.  Once you have your feeds selected, to update the feeds, all you have to do click on Get Feeds.</p>"));
	mHTMLReader->write(QString("<p>Version 1.1b now offers a MyChannelBar, which allows you to jump between feeds.  By just clicking on a channel you can now read the sites you want in any order that you want.</p>"));
	mHTMLReader->write(QString("<p>Don't forget to check out the Configuration Dialog (Options -> Configure) to change a wide range of settings."));
	mHTMLReader->write(QString("<br><br><br><br><br><br><br><br><br><br><br><br><br>"));
	mHTMLReader->write(QString("</body></html>"));
	mHTMLReader->end();
}

void KrssApp::slotViewQuickLinks(void)
{
	slotStatusMsg(i18n("Toggle the Quick Links..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  if(!viewQuickLinks->isChecked())
  {
    mQuickLink->hide();
  }
  else
  {
    mQuickLink->show();
  }

  slotStatusMsg(i18n("Ready."));
}

void KrssApp::slotQuickLinkExecute(QIconViewItem *item)
{
	if(!item)
		return;
		
	QString key = item->key();
	bool ret = mHTMLReader->gotoAnchor(key);
	if(ret)
		cerr << "Scolling to Anchor: " << key << " was successfull." << endl;
	else
		cerr << "Scolling to Anchor: " << key << " failed." << endl;
}

void KrssApp::slotConfigureKeys(void)
{
	mAutoUpdateTimer.stop();
	
	setActionsEnabled(false);
	
	KKeyDialog::configureKeys(actionCollection(), xmlFile());
	
	config->setGroup(QString("Auto Update"));
	if(config->readBoolEntry(QString("Use AutoUpdate"), false))
		mAutoUpdateTimer.start(15000, false);
		
	setActionsEnabled(true);
}

void KrssApp::slotConfigureToolbars(void)
{
	mAutoUpdateTimer.stop();
	
	setActionsEnabled(false);
	
	saveMainWindowSettings( KGlobal::config(), "General Options" );
  KEditToolbar dlg(actionCollection());
  connect(&dlg,SIGNAL(newToolbarConfig()),this,SLOT(slotNewToolbarConfig()));
  if(dlg.exec()) {
  	createGUI();
	}
	
	config->setGroup(QString("Auto Update"));
	if(config->readBoolEntry(QString("Use AutoUpdate"), false))
		mAutoUpdateTimer.start(15000, false);
		
	setActionsEnabled(true);
}

void KrssApp::slotEditFilters(void)
{	
	mAutoUpdateTimer.stop();
	
	setActionsEnabled(false);
	
	FilterDialog::editFilters();
	
	unsigned int scrollBarPos = mHTMLReader->view()->verticalScrollBar()->value();
	
	displaySites();
	
	mHTMLReader->view()->verticalScrollBar()->setValue(scrollBarPos);
	
	config->setGroup(QString("Auto Update"));
	if(config->readBoolEntry(QString("Use AutoUpdate"), false))
		mAutoUpdateTimer.start(15000, false);
		
	setActionsEnabled(true);
}

bool KrssApp::event(QEvent *e)
{
	switch(e->type()) {
		case QEvent::Show:
			config->setGroup(QString("General"));
			if(config->readBoolEntry(QString("Use System Tray"), true)) {
				if(!isMinimized()) {
					mTray->hide();
					show();
				}
			}
			break;
		case QEvent::Hide:
			config->setGroup(QString("General"));
			if(config->readBoolEntry(QString("Use System Tray"), true)) {
				if(isMinimized()) {
					mTray->show();
					hide();
				}
			}
			break;
	}
			
	return KMainWindow::event(e);		
}

void KrssApp::slotImportAmphetaDesk(void)
{
	mAutoUpdateTimer.stop();
	
	setActionsEnabled(false);
	
	if(mHasBeenCleared) {
		mSiteHandler.readSites();
		clearViewer->setChecked(false);
		mHasBeenCleared = false;
	}
	
	AmphetaDeskInport::import(kapp, &mSiteHandler);
	
	unsigned int scrollBarPos = mHTMLReader->view()->verticalScrollBar()->value();
	
	displaySites();
	
	mHTMLReader->view()->verticalScrollBar()->setValue(scrollBarPos);
	
	config->setGroup(QString("Auto Update"));
	if(config->readBoolEntry(QString("Use AutoUpdate"), false))
		mAutoUpdateTimer.start(15000, false);
		
	setActionsEnabled(true);
}

void KrssApp::slotToggleClearViewer(void)
{
	setActionsEnabled(false);
	
	if(clearViewer->isChecked()) {
		mHasBeenCleared = true;
		mSiteHandler.clearSites();
		displaySites();
	}
	else {
		mHasBeenCleared = false;
		mSiteHandler.readSites();
		displaySites();
	}
	
	setActionsEnabled(true);
}

void KrssApp::slotToggleAlwaysOnTop(void)
{
	config->setGroup(QString("General"));
	
	if(viewAlwaysOnTop->isChecked())
		config->writeEntry(QString("Always On Top"), true);
	else
		config->writeEntry(QString("Always On Top"), false);
		
	doAlwaysOnTop();
}

void KrssApp::doAlwaysOnTop(void)
{
	config->setGroup(QString("General"));
	if(config->readBoolEntry(QString("Always On Top"), false))
		KWin::setState(winId(), NET::StaysOnTop);
	else
		KWin::clearState(winId(), NET::StaysOnTop);
}

void KrssApp::slotWindowChanged(WId winid)
{
	if(winid == winId()) {
		if(KWin::info(winid).state == NET::StaysOnTop) {
			viewAlwaysOnTop->setChecked(true);
			config->setGroup(QString("General"));
			config->writeEntry(QString("Always On Top"), true);
		}
		else {
			viewAlwaysOnTop->setChecked(false);
			config->setGroup(QString("General"));
			config->writeEntry(QString("Always On Top"), false);
		}
	}
}

void KrssApp::setActionsEnabled(bool enabled)
{
	fileGetFeeds->setEnabled(enabled);
	fileQuit->setEnabled(enabled);
	feedSetup->setEnabled(enabled);
	krssSetup->setEnabled(enabled);
	feedSync->setEnabled(enabled);
	filterSetup->setEnabled(enabled);
	amphetaDeskImport->setEnabled(enabled);
	clearViewer->setEnabled(enabled);
	//viewDisplayRootWindow->setEnabled(enabled);
	
	mLoadingSites = !enabled;

 	if(mLoadingSites) {
  	mQuitRequested = false;
   	return;
  }
	
	if(mQuitRequested) {
   	close();
		kapp->quit();
  }
}

/*
void KrssApp::slotToggleDisplayInRootWindow(void)
{
	QPoint p(0,0);
	if(viewDisplayRootWindow->isChecked()) {
		QWidget *d = QApplication::desktop();
		if(d) {
			mHTMLReader->view()->reparent(d, 0, p);
			if(d->layout())
				d->layout()->add(mHTMLReader->view());
		}
	}
	else {
		mHTMLReader->view()->reparent(mSplitter, 0, p);
		mSplitter->moveToLast(mHTMLReader->view());
	}
}
*/

void KrssApp::slotManualScrollingOn(void)
{
	mManualScrolling = true;
}

void KrssApp::slotManualScrollingOff(void)
{
	mManualScrolling = false;
}

		

