/***************************************************************************
                          krss.h  -  description
                             -------------------
    begin                : Sat Aug  4 15:59:19 CEST 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRSS_H
#define KRSS_H
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt

// include files for KDE 
#include <kapp.h>
#include <kmainwindow.h>
#include <kaccel.h>
#include <kaction.h>
#include <khtml_part.h>

#include <qtimer.h>
#include <qprogressbar.h>

#include "sitehandler.h"

// forward declaration of the Krss classes
class QSplitter;

class KSystemTray;
class KWinModule;
class KHTMLView;

class MyChannelBar;

/**
  * The base class for Krss application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of KrssView creates your center view, which is connected
  * to the window's Doc object.
  * KrssApp reimplements the methods that KMainWindow provides for main window handling and supports
  * full session management as well as using KActions.
  * @see KMainWindow
  * @see KApplication
  * @see KConfig
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 1.2 code generation
  */
class KrssApp : public KMainWindow
{
  Q_OBJECT

  //friend class KrssView;

  public:
    /** construtor of KrssApp, calls all init functions to create the application.
     */
    KrssApp(QWidget* parent=0, const char* name=0);
    ~KrssApp();

    void setActionsEnabled(bool enable);

    void displaySites(void);

  protected:
    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */ 	
    void saveOptions();
    /** read general Options again and initialize all variables like the recent file list
     */
    void readOptions();
    /** initializes the KActions of the application */
    void initActions();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
    void initStatusBar();
    /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
     * be saved if Modified; on cancel the closeEvent is rejected.
     * @see KTMainWindow#queryClose
     * @see KTMainWindow#closeEvent
     */
    virtual bool queryClose();
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
     * properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */
     virtual bool queryExit();

     void checkDirectories(void);

     void checkSiteFile(void);
		 void addSite(SiteHandler & mSites, bool used, const QString & name, const KURL & url, const QString & description);

    bool event(QEvent *);

    void doAlwaysOnTop(void);

    void doSplash(void);

	public slots:
    /** open a new application window by creating a new instance of KrssApp */
    void slotFileNewWindow();
    /** clears the document in the actual view to reuse it as the new document */
    void slotGetFeeds();
    /** **/
    void slotGetJustThisFeed();
    /** print the actual file */
    void slotFilePrint();
    /** closes all open windows by calling close() on each memberList item until the list is empty, then quits the application.
     * If queryClose() returns false because the user canceled the saveModified() dialog, the closing breaks.
     */
    void slotFileQuit();
    /** toggles the toolbar
     */
    void slotViewToolBar();
    /** toggles the statusbar
     */
    void slotViewStatusBar();
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusMsg(const QString &text);

    void slotEditFeeds();

    void slotConfigure();

    void slotScrollTimer(void);

		void slotAutoUpdateTimer(void);

    void slotOpenURLRequest(const KURL &, const KParts::URLArgs &args = KParts::URLArgs());

    void slotSyncFeeds(void);

    void slotOnURL(const QString & url);

    void slotPopupMenu(const QString & url, const QPoint & p);

    void slotMyChannelBarPopupMenu(const QString & site, const QPoint & p);

    void slotViewQuickLinks(void);

    void slotQuickLinkExecute(QIconViewItem *);

    void slotConfigureKeys(void);

    void slotConfigureToolbars(void);

    void slotEditFilters(void);

    void slotToggleScrolling(void);

    void slotRefresh(void) { displaySites();}

    void slotImportAmphetaDesk(void);

    void slotToggleClearViewer(void);

    void slotToggleAlwaysOnTop(void);

    //in order to receive stays on top messages
    void slotWindowChanged(WId);

    //in order to display on the desktop window
    //void slotToggleDisplayInRootWindow(void);

    void slotManualScrollingOn(void);
    void slotManualScrollingOff(void);

	private:
    /** the configuration object of the application */
    KConfig *config;

    // KAction pointers to enable/disable actions
    KAction* fileNewWindow;
    KAction* fileGetFeeds;
    KAction* fileGetThisFeed;
    KAction* filePrint;
    KAction* fileQuit;
    KToggleAction* viewToolBar;
    KToggleAction* viewStatusBar;
    KToggleAction* viewQuickLinks;
    KToggleAction* scrollToggle;
    KAction* feedSetup;
    KAction* krssSetup;
    KAction* feedSync;
    KAction* keySetup;
    KAction* toolbarSetup;
    KAction* filterSetup;
    KAction* amphetaDeskImport;
    KToggleAction* clearViewer;
    KToggleAction* viewAlwaysOnTop;
    //KToggleAction* viewDisplayRootWindow;

    QProgressBar *mProgress;

    KHTMLPart *mHTMLReader;
    MyChannelBar *mQuickLink;
    QSplitter *mSplitter;

    KSystemTray *mTray;

    QTimer mScrollTimer;
    QTimer mAutoUpdateTimer;

    SiteHandler mSiteHandler;

    bool mLoadingSites;
    bool mQuitRequested;

    bool mAllowScrolling;
    bool mHasBeenCleared;
    bool mManualScrolling;

    KWinModule *mWinModule; //Used to received stays on top events

    QString mMyChannelBarCurrentFeed;
};
 
#endif // KRSS_H
