/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sat Aug  4 15:59:19 CEST 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "krss.h"

static const char *description =
	I18N_NOOP("K.R.S.S.");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE
	
	
static KCmdLineOptions options[] =
{
  //{ "+[File]", I18N_NOOP("file to open"), 0 },
  //{ "a2k <file>", I18N_NOOP("Convert an AmphetaDesk service xml file to the KRSS interal format"), 0 },
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{

	KAboutData aboutData( "krss", I18N_NOOP("Krss"),
		VERSION, description, KAboutData::License_GPL,
		"(c) 2001, Chris Wallace", 0, 0, "chris.wallace@netflash.net");
	aboutData.addAuthor("Chris Wallace",0, "chris.wallace@netflash.net");
	
	aboutData.addCredit("Eduardo Dominguez", "Bring it to my attention that the fonts in version 1.0 were not being displayed properly.");
	aboutData.addCredit("David Boosalis", "For the 3 items on his wish list.");
	aboutData.addCredit("Steve ??? and Theofilos Intzoglou", "For noticing the '#include <klistview.h>' bug");
	
	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.
	
	KApplication app;
 
  if (app.isRestored())
  {
    RESTORE(KrssApp);
  }
  else 
  {
    KrssApp *krss = new KrssApp();
    krss->show();

    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    /*
    if(args->isSet("a2k")) {
    	QString filename = args->getOption("a2k");
    	Ampheta2KRSS::parseFile(filename);
			delete krss;
			//delete app;
			return 0;
    }
		else*/
			krss->setActionsEnabled(false);
    	krss->displaySites();
    	krss->setActionsEnabled(true);
		
		args->clear();
  }

  return app.exec();
}  
