/***************************************************************************
                          mychannelbar.h  -  description
                             -------------------
    begin                : Thu Oct 11 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYCHANNELBAR_H
#define MYCHANNELBAR_H

#include <qwidget.h>
#include <qtimer.h>

#include <kiconview.h>
#include <kio/jobclasses.h>

class KURL;
class KConfig;

class SiteHandler;

/**
  *@author Chris Wallace
  */

class MyChannelBar : public KIconView  {
   Q_OBJECT
	public:
		MyChannelBar(KConfig * config, SiteHandler * sitehandler, QWidget *parent=0, const char *name=0);
		~MyChannelBar();
		
		void expirationChanged(void);
		
		void setItemColours(const QColor & newcolour, const QColor & oldcolour);
		
	signals:
		void signalRefresh(void);
		void signalMyChannelBarPopupMenu(const QString &, const QPoint &);
		
	protected slots:
		void slotScrollBy(int);
		void slotResult(KIO::Job *);
		void slotCopyingDone(KIO::Job *, const KURL &, const KURL &, bool, bool);
		void slotOnItem(QIconViewItem *);
		void slotOnViewport(void);
		void slotExpirationTimeOut(void);
		void slotRightButtonPressed(QIconViewItem *, const QPoint & );
		
	protected:
		void drawBackground(QPainter *, const QRect & );
		void contentsDragEnterEvent(QDragEnterEvent* event);
		void contentsDropEvent(QDropEvent* event);
		
	private:
		SiteHandler *mSiteHandler;
		KConfig *mConfig;
		bool mHaveToolTip;
		QTimer mExTimer;
		int mExpirationDays;
		int mExpirationHours;
		int mExpirationMinutes;
		QColor mNewColour;
		QColor mOldColour;
		
};

#endif
