/***************************************************************************
                          mychannelbaritem.cpp  -  description
                             -------------------
    begin                : Fri Oct 12 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mychannelbaritem.h"

#include <qpalette.h>

#include <kglobal.h>
#include <kconfig.h>

#include <iostream>

MyChannelBarItem::MyChannelBarItem(QIconView * parent, const QColor & c)
: QIconViewItem(parent)
{
	setColour(c);
	setDownloadDateTime(QDateTime::currentDateTime());
	setDisplayDateTime(QDateTime::currentDateTime());
	mNew = false;
}

MyChannelBarItem::MyChannelBarItem(QIconView * parent, QIconViewItem * after, const QColor & c)
: QIconViewItem(parent, after)
{
	setColour(c);
	setDownloadDateTime(QDateTime::currentDateTime());
	setDisplayDateTime(QDateTime::currentDateTime());
	mNew = false;
}

MyChannelBarItem::MyChannelBarItem(QIconView * parent, const QString & text, const QColor & c)
: QIconViewItem(parent, text)
{
	setColour(c);
	setDownloadDateTime(QDateTime::currentDateTime());
	setDisplayDateTime(QDateTime::currentDateTime());
	mNew = false;
}

MyChannelBarItem::MyChannelBarItem(QIconView * parent, QIconViewItem * after, const QString & text, const QColor & c)
: QIconViewItem(parent, after, text)
{
	setColour(c);
	setDownloadDateTime(QDateTime::currentDateTime());
	setDisplayDateTime(QDateTime::currentDateTime());
	mNew = false;
}

MyChannelBarItem::MyChannelBarItem(QIconView * parent, const QString & text, const QPixmap & icon, const QColor & c)
: QIconViewItem(parent, text, icon)
{
	setColour(c);
	setDownloadDateTime(QDateTime::currentDateTime());
	setDisplayDateTime(QDateTime::currentDateTime());
	mNew = false;
}

MyChannelBarItem::MyChannelBarItem(QIconView * parent, QIconViewItem * after, const QString & text, const QPixmap & icon, const QColor & c)
: QIconViewItem(parent, after, text, icon)
{
	setColour(c);
	setDownloadDateTime(QDateTime::currentDateTime());
	setDisplayDateTime(QDateTime::currentDateTime());
	mNew = false;
}

MyChannelBarItem::~MyChannelBarItem()
{
}

void MyChannelBarItem::paintItem(QPainter * p, const QColorGroup & cg)
{
	QColorGroup mycg(cg.foreground(), cg.button(), cg.light(), cg.dark(), cg.mid(), mColour, cg.base());
	//mycg.setColor(QColorGroup::Text, mColour);
	QIconViewItem::paintItem(p, mycg);
}

void MyChannelBarItem::calculateExpireDateTime(void)
{
	QDateTime fidt = mDownloadDateTime;
 	KConfig *config = KGlobal::config();
  config->setGroup(QString("MyChannelBar"));
  if(!config->readBoolEntry(QString("No Expiration"), false)) {
		fidt = fidt.addSecs(config->readNumEntry(QString("Expiration Days"), 1) * 24*60*60);
		fidt = fidt.addSecs(config->readNumEntry(QString("Expiration Hours"), 0) * 60*60);
		fidt = fidt.addSecs(config->readNumEntry(QString("Expiration Minutes"), 0) * 60);
 	}
  else fidt = QDateTime(QDate(0,0,0), QTime(0,0,0));
 	mExpireDateTime = fidt;
}

