/***************************************************************************
                          mychannelbaritem.h  -  description
                             -------------------
    begin                : Fri Oct 12 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MYCHANNELBARITEM_H
#define MYCHANNELBARITEM_H

#include <qiconview.h>

#include <qcolor.h>
#include <qdatetime.h>

/**
  *@author Chris Wallace
  */

class MyChannelBarItem : public QIconViewItem  {
	public:
		MyChannelBarItem(QIconView * parent, const QColor & c);
		MyChannelBarItem(QIconView * parent, QIconViewItem * after, const QColor & c);
		MyChannelBarItem(QIconView * parent, const QString & text, const QColor & c);
		MyChannelBarItem(QIconView * parent, QIconViewItem * after, const QString & text, const QColor & c);
		MyChannelBarItem(QIconView * parent, const QString & text, const QPixmap & icon, const QColor & c);
		MyChannelBarItem(QIconView * parent, QIconViewItem * after, const QString & text, const QPixmap & icon, const QColor & c);
		~MyChannelBarItem();
		
		void setColour(const QColor & c) {mColour = c;}
		const QColor & colour(void) {return mColour;}
		
		void setNew(bool isnew) {mNew = isnew;}
		bool isNew(void) {return mNew;}
		
		void setDisplayDateTime(const QDateTime & dt) {mDisplayDateTime = dt;}
		const QDateTime & displayDateTime(void) {return mDisplayDateTime;}
		
		void setDownloadDateTime(const QDateTime & dt) {mDownloadDateTime = dt;}
		const QDateTime & downloadDateTime(void) {return mDownloadDateTime;}

  	void calculateExpireDateTime(void);
   	const QDateTime & expireDateTime(void) {return mExpireDateTime;}
		
	protected:
		void paintItem(QPainter * p, const QColorGroup & cg);
		
	private:
		QColor mColour;
		QDateTime mDisplayDateTime;
		QDateTime mDownloadDateTime;
  	QDateTime mExpireDateTime;
		bool mNew;
};

#endif
