/***************************************************************************
                          rdfchannel.cpp  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rdfchannel.h"

#include "colourconverter.h"
#include "textcorrector.h"

RDFChannel::RDFChannel()
{
	clear();
}

RDFChannel::RDFChannel(const RDFChannel & c)
{
	operator = (c);
}

RDFChannel::~RDFChannel()
{
}

void RDFChannel::operator = (const RDFChannel & c)
{
	mTitle = c.mTitle;
	mLink = c.mLink;
	mDescription = c.mDescription;
	mRDFTextInput = c.mRDFTextInput;
	mRDFImage = c.mRDFImage;
	mRDFAbout = c.mRDFAbout;
	mItems = c.mItems;
}

void RDFChannel::clear(void)
{
	mTitle = QString("");
	mLink = KURL("");
	mDescription = QString("");
	mRDFTextInput = QString("");
	mRDFImage = QString("");
	mRDFAbout = QString("");
	mItems.clear();
}

void RDFChannel::write(QDomDocument & doc, QDomElement & elm)
{
	QDomElement celm = doc.createElement("channel");
	celm.setAttribute(QString("rdf:about"), mRDFAbout);
	
	//Add the title
	QDomElement telm = doc.createElement("title");
	QDomText ttxt = doc.createTextNode(mTitle);
	telm.appendChild(ttxt);
	celm.appendChild(telm);
	
	//Add the link
	QDomElement lelm = doc.createElement("link");
	QDomText ltxt = doc.createTextNode(mLink.url());
	lelm.appendChild(ltxt);
	celm.appendChild(lelm);
	
	//Add the description
	QDomElement delm = doc.createElement("description");
	QDomText dtxt = doc.createTextNode(mDescription);
	delm.appendChild(dtxt);
	celm.appendChild(delm);
	
	//Add the item seqence
	mItems.write(doc, celm);
	
	//Add the image, if present
	if(haveImage()) {
		QDomElement ielm = doc.createElement("image");
		ielm.setAttribute(QString("rdf:resource"), mRDFImage);
		celm.appendChild(ielm);
	}
	
	//Add the textinput, if present
	if(haveTextInput()) {
		QDomElement ielm = doc.createElement("textinput");
		ielm.setAttribute(QString("rdf:resource"), mRDFTextInput);
		celm.appendChild(ielm);
	}
	
	elm.appendChild(celm);
}

void RDFChannel::displayNews(QString & mStr, SchemeTree & tree)
{	
	switch(tree.channelTitleAlign()) {
		case 1:	mStr.append(QString("<div align=\"left\">"));	break;
		case 2:	mStr.append(QString("<div align=\"right\">")); break;
		case 3:	mStr.append(QString("<div align=\"center\">"));	break;
		case 4:	mStr.append(QString("<div align=\"justify\">")); break;
	}
	
	switch(tree.channelTitleHeaderLevel()) {
		case 1:	mStr.append(QString("<h1>"));	break;
		case 2:	mStr.append(QString("<h2>")); break;
		case 3:	mStr.append(QString("<h3>"));	break;
		case 4:	mStr.append(QString("<h4>"));	break;
		case 5:	mStr.append(QString("<h5>"));	break;
		case 6:	mStr.append(QString("<h6>"));	break;
	}
	
	QString mTitleStr;
	TextCorrector::correctText(mTitle, mTitleStr);
	mStr.append(QString("<P class=\"P_KRSS_CH_TITLE\">") + mTitleStr + QString("</P>"));
	
	switch(tree.channelTitleHeaderLevel()) {
		case 1:	mStr.append(QString("</h1>")); break;
		case 2:	mStr.append(QString("</h2>")); break;
		case 3:	mStr.append(QString("</h3>")); break;
		case 4:	mStr.append(QString("</h4>")); break;
		case 5:	mStr.append(QString("</h5>")); break;
		case 6:	mStr.append(QString("</h6>")); break;
	}
	
	if(tree.channelTitleAlign() > 0 && tree.channelTitleAlign() < 5)
		mStr.append(QString("</div>"));
	
	switch(tree.channelDescriptionAlign()) {
		case 1:	mStr.append(QString("<div align=\"left\">")); break;
		case 2:	mStr.append(QString("<div align=\"right\">")); break;
		case 3:	mStr.append(QString("<div align=\"center\">")); break;
		case 4:	mStr.append(QString("<div align=\"justify\">")); break;
	}
		
	mStr.append(QString("<br><A class=\"A_KRSS\"  href=\""));
	mStr.append(mLink.url());
	mStr.append(QString("\">"));
	mStr.append(mLink.url());
	mStr.append(QString("</A>"));
	
	QString mDescriptionStr;
	TextCorrector::correctText(mDescription, mDescriptionStr);
	mStr.append(QString("<P class=\"P_KRSS_CH_DESC\">") + mDescriptionStr + QString("</P>"));
	
	if(tree.channelDescriptionAlign() > 0 && tree.channelDescriptionAlign() < 5)
		mStr.append(QString("</div>"));
	
	mStr.append(QString("<br>"));
}

