/***************************************************************************
                          rdfchannel.h  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RDFCHANNEL_H
#define RDFCHANNEL_H

#include <qstring.h>
#include <kurl.h>
#include <qdom.h>
#include <iostream>

#include "rdfitems.h"
#include "schemetree.h"
/**
  *@author Chris Wallace
  */

class RDFChannel {
	public:
		RDFChannel();
		RDFChannel(const RDFChannel &);
		~RDFChannel();
		
		void operator = (const RDFChannel &);
		
		void clear(void);
		
		void setTitle(const QString & title) {mTitle = title;}
		const QString & title(void) const {return mTitle;}
		
		void setLink(const KURL & url) {mLink = url;}
		const KURL & link(void) const {return mLink;}
		
		void setDescription(const QString & description) {mDescription = description;}
		const QString & description(void) const {return mDescription;}
		
		void setTextInputUri(const QString & textinputuri) {mRDFTextInput = textinputuri;}
		const QString & textInputUri(void) const {return mRDFTextInput;}
		bool haveTextInput(void) {
			if(mRDFTextInput.isEmpty() || mRDFTextInput.isNull())
				return false;
			return true;
		}
		
		void setImageUri(const QString & imageuri) {mRDFImage = imageuri;}
		const QString & imageUri(void) const {return mRDFImage;}
		bool haveImage(void) {
			if(mRDFImage.isEmpty() || mRDFImage.isNull())
				return false;
			return true;
		}
		
		void setRDFAbout(const QString & about) {mRDFAbout = about;}
		const QString & rdfAbout(void) const {return mRDFAbout;}
		
		void addItemUri(const QString & uri) {mItems.addUri(uri);}
		const QStringList & itemUris(void) const {mItems.uris();}
		
		void write(QDomDocument & doc, QDomElement & elm);
		
		void displayNews(QString & mStr, SchemeTree & tree);
		
	private:
		RDFItems mItems;			//A list of the item resources in the file
		QString mTitle;				//The title of the channel
		KURL mLink;						//The link for the channel
		QString mDescription;	//The description
		
		QString mRDFTextInput;	//Information about the text input
		QString mRDFImage;		//Information about the image
		
		QString mRDFAbout;		//Information about the channel, rdf:about
};

#endif
