/***************************************************************************
                          rdfimage.cpp  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rdfimage.h"
#include <qdir.h>
#include <iostream>
#include <stdlib.h>

RDFImage::RDFImage()
{
	clear();
}

RDFImage::RDFImage(const RDFImage & i)
{
	operator = (i);
}

RDFImage::~RDFImage()
{
}

void RDFImage::operator = (const RDFImage & i)
{
	mTitle = i.mTitle;
	mUrl = i.mUrl;
	mLink = i.mLink;
	mRDFResource = i.mRDFResource;
}

void RDFImage::clear(void)
{
	mTitle = QString("");
	mUrl = KURL("");
	mLink = KURL("");
	mRDFResource = QString("");
}

void RDFImage::write(QDomDocument & doc, QDomElement & elm)
{
	QDomElement ielm = doc.createElement("image");
	ielm.setAttribute(QString("rdf:about"), mRDFResource);
	
	//Add the title
	QDomElement telm = doc.createElement("title");
	QDomText ttxt = doc.createTextNode(mTitle);
	telm.appendChild(ttxt);
	ielm.appendChild(telm);
	
	//Add the URL
	QDomElement uelm = doc.createElement("url");
	QDomText utxt = doc.createTextNode(mUrl.url());
	uelm.appendChild(utxt);
	ielm.appendChild(uelm);
	
	//Add the link
	QDomElement lelm = doc.createElement("link");
	QDomText ltxt = doc.createTextNode(mLink.url());
	lelm.appendChild(ltxt);
	ielm.appendChild(lelm);
	
	elm.appendChild(ielm);
}

void RDFImage::fixImage(KURL & oldUrl, KURL & newUrl)
{
	if(oldUrl.isLocalFile()) {
		newUrl = oldUrl;
		return;
	}
	
	QString filename = QDir::homeDirPath() + QString("/.krss/cache/");
	filename.append( oldUrl.host() );
	filename.append( mUrl.filename() );
	
	newUrl.setPath(filename);
	oldUrl = mUrl;
	setUrl(newUrl);
}

void RDFImage::displayNews(QString & mStr, SchemeTree & tree)
{
	//QFile f(mUrl.path());
	//if(!f.exists()) return;
	if(mUrl.url().isEmpty() || mUrl.url().isNull())
		return;
	
	mStr.append(QString("<A class=\"A_KRSS\" href=\""));
	mStr.append(mLink.url());
	mStr.append(QString("\"><img"));
	switch(tree.channelImageAlign()) {
		case 1:	mStr.append(QString(" align=\"top\""));	break;
		case 2:	mStr.append(QString(" align=\"texttop\"")); break;
		case 3:	mStr.append(QString(" align=\"middle\"")); break;
		case 4:	mStr.append(QString(" align=\"absmiddle\""));	break;
		case 5:	mStr.append(QString(" align=\"bottom\"")); break;
		case 6:	mStr.append(QString(" align=\"absbottom\""));	break;
		case 7:	mStr.append(QString(" align=\"baseline\"")); break;
		case 8:	mStr.append(QString(" align=\"left\"")); break;
		case 9: mStr.append(QString(" align=\"right\""));	break;
		case 10: mStr.append(QString(" align=\"center\""));	break;
	}
	
	mStr.append(QString(" border=") + QString::number(tree.channelImageBorder()));
	mStr.append(QString(" src=\""));
	mStr.append(mUrl.url());
	mStr.append(QString("\" alt=\""));
	mStr.append(mTitle);
	mStr.append(QString("\"></A>"));
	
	mStr.append(QString("<br>"));
}
