/***************************************************************************
                          rdfimage.h  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RDFIMAGE_H
#define RDFIMAGE_H

#include <qstring.h>
#include <kurl.h>
#include <qdom.h>

#include "schemetree.h"
/**
  *@author Chris Wallace
  */

class RDFImage {
	public:
		RDFImage();
		RDFImage(const RDFImage & i);
		~RDFImage();
		
		void operator = (const RDFImage & i);
		
		void clear(void);
	
		void setTitle(const QString & title) {mTitle = title;}
		const QString & title(void) const {return mTitle;}
		
		void setUrl(const KURL & url) {mUrl = url;}
		const KURL & url(void) const {return mUrl;}
		
		void setLink(const KURL & url) {mLink = url;}
		const KURL & link(void) const {return mLink;}
		
		void setUri(const QString & uri) {mRDFResource = uri;}
		const QString & uri(void) const {return mRDFResource;}
		
		void write(QDomDocument & doc, QDomElement & elm);
		
		void fixImage(KURL & oldUrl, KURL & newUrl);
		
		void displayNews(QString & mStr, SchemeTree & tree);
		
	private:
		QString mTitle;	//The alternative text for the image
		KURL mUrl;		//The url where the image can be found
		KURL mLink;  //The link for the image
	
		QString mRDFResource;	//Information about the image, must be the same as in the channel header
	
};

#endif
