/***************************************************************************
                          rdfitem.h  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RDFITEM_H
#define RDFITEM_H

#include <qstring.h>
#include <kurl.h>
#include <qdom.h>

#include "schemetree.h"
/**
  *@author Chris Wallace
  */

class RDFItem {
	public:
		RDFItem();
		RDFItem(const RDFItem & i);
		~RDFItem();
	
		void operator = (const RDFItem & i);
	
		void clear(void);
	
		const QString & title(void) const {return mTitle;}
		void setTitle(const QString & title) {mTitle = title;}
	
		const KURL & link(void) const {return mLink;}
		void setLink(const KURL & url) {mLink = url;}
	
		const QString & description(void) const {return mDescription;}
		void setDescription(const QString & description) {mDescription = description;}
		bool haveDescription(void) {
			if(mDescription.isEmpty() || mDescription.isNull())
				return false;
			return true;
		}
		
		const QString & uri(void) const {return mRDFResource;}
		void setUri(const QString & uri) {mRDFResource = uri;}
		
		void write(QDomDocument & doc, QDomElement & elm);
		
		void displayNews(QString & mStr, SchemeTree & tree);
	
	private:
		QString mTitle;	//The title for the item
		KURL mLink;			//The link for the item
		QString mDescription;	//A description about the item
	
		QString mRDFResource;	//Information about the item, must be in the channel, ie for sequence
};

#endif
