/***************************************************************************
                          rdfitems.cpp  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rdfitems.h"

RDFItems::RDFItems()
{
	clear();
}

RDFItems::RDFItems(const RDFItems & i)
{
	operator = (i);
}

RDFItems::~RDFItems()
{
}

void RDFItems::operator = (const RDFItems & i)
{
	mItems = i.mItems;
}

void RDFItems::clear(void)
{
	mItems.clear();
}

void RDFItems::write(QDomDocument & doc, QDomElement & elm)
{
	QDomElement ielm = doc.createElement("items");
	QDomElement selm = doc.createElement("rdf:Seq");
	
	for(QStringList::Iterator i = mItems.begin(); i != mItems.end(); i++) {
		QDomElement lelm = doc.createElement("rdf:li");
		lelm.setAttribute(QString("resource"), (*i));
		selm.appendChild(lelm);
	}
	ielm.appendChild(selm);
	elm.appendChild(ielm);
}
