/***************************************************************************
                          rdfitems.h  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RDFITEMS_H
#define RDFITEMS_H

#include <qstringlist.h>
#include <qdom.h>

/**
  *@author Chris Wallace
  */

class RDFItems {
	public:
		RDFItems();
		RDFItems(const RDFItems & i);
		~RDFItems();
		
		void operator = (const RDFItems & i);
		
		void clear(void);
		
		void addUri(const QString & uri) {mItems.append(uri);}
		const QStringList & uris(void) const {return mItems;}
		
		void write(QDomDocument & doc, QDomElement & elm);
	
	private:	
		QStringList mItems;	//Information about the items, can be used for sequence
};

#endif
