/***************************************************************************
                          rdftextinput.cpp  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rdftextinput.h"

#include "colourconverter.h"
#include "textcorrector.h"

RDFTextInput::RDFTextInput()
{
	clear();
}

RDFTextInput::RDFTextInput(const RDFTextInput & ti)
{
	operator = (ti);
}

RDFTextInput::~RDFTextInput()
{
}

void RDFTextInput::operator = (const RDFTextInput & ti)
{
	mTitle = ti.mTitle;
	mDescription = ti.mDescription;
	mName = ti.mName;
	mLink = ti.mLink;
	mRDFResource = ti.mRDFResource;
}

void RDFTextInput::clear(void)
{
	mTitle = QString("");
	mDescription = QString("");
	mName = QString("");
	mLink = KURL("");
	mRDFResource = QString("");
}

void RDFTextInput::write(QDomDocument & doc, QDomElement & elm)
{
	QDomElement ielm = doc.createElement("textinput");
	ielm.setAttribute(QString("rdf:about"), mRDFResource);
	
	//Add the title
	QDomElement telm = doc.createElement("title");
	QDomText ttxt = doc.createTextNode(mTitle);
	telm.appendChild(ttxt);
	ielm.appendChild(telm);
	
	//Add the description
	QDomElement delm = doc.createElement("description");
	QDomText dtxt = doc.createTextNode(mDescription);
	delm.appendChild(dtxt);
	ielm.appendChild(delm);
	
	//Add the name
	QDomElement nelm = doc.createElement("name");
	QDomText ntxt = doc.createTextNode(mName);
	nelm.appendChild(ntxt);
	ielm.appendChild(nelm);
	
	//Add the link
	QDomElement lelm = doc.createElement("link");
	QDomText ltxt = doc.createTextNode(mLink.url());
	lelm.appendChild(ltxt);
	ielm.appendChild(lelm);
	
	elm.appendChild(ielm);
}

void RDFTextInput::displayNews(QString & mStr, SchemeTree & tree, const QString & buttonText)
{
	mStr.append(QString("<form action=\""));
	mStr.append(mLink.url());
	mStr.append(QString("\" method=\"GET\">"));
	switch(tree.newsTitleAlign()) {
		case 1:	mStr.append(QString("<div align=\"left\">"));	break;
		case 2:	mStr.append(QString("<div align=\"right\">")); break;
		case 3:	mStr.append(QString("<div align=\"center\">"));	break;
		case 4:	mStr.append(QString("<div align=\"justify\">")); break;
	}
	
	switch(tree.newsTitleHeaderLevel()) {
		case 1: mStr.append(QString("<h1>"));	break;
		case 2:	mStr.append(QString("<h2>"));	break;
		case 3:	mStr.append(QString("<h3>"));	break;
		case 4:	mStr.append(QString("<h4>"));	break;
		case 5:	mStr.append(QString("<h5>"));	break;
		case 6:	mStr.append(QString("<h6>"));	break;
	}
	
	QString mTitleStr;
	TextCorrector::correctText(mTitle, mTitleStr);
	mStr.append(QString("<P class=\"P_KRSS_NW_TITLE\">") + mTitleStr + QString("</P>"));
	
	switch(tree.newsTitleHeaderLevel()) {
		case 1:	mStr.append(QString("</h1>")); break;
		case 2:	mStr.append(QString("</h2>")); break;
		case 3:	mStr.append(QString("</h3>")); break;
		case 4: mStr.append(QString("</h4>")); break;
		case 5: mStr.append(QString("</h5>")); break;
		case 6:	mStr.append(QString("</h6>")); break;
	}
	
	if(tree.newsTitleAlign() > 0 && tree.newsTitleAlign() < 5)
		mStr.append(QString("</div>"));
		
	switch(tree.newsDescriptionAlign()) {
		case 1:	mStr.append(QString("<div align=\"left\">"));	break;
		case 2:	mStr.append(QString("<div align=\"right\">")); break;
		case 3:	mStr.append(QString("<div align=\"center\">"));	break;
		case 4:	mStr.append(QString("<div align=\"justify\">")); break;
	}
	
	if(!(mDescription.isEmpty() || mDescription.isNull())) {
		QString mDescriptionStr;
		TextCorrector::correctText(mDescription, mDescriptionStr);
		mStr.append(QString("<P class=\"P_KRSS_NW_DESC\">") + mDescriptionStr + QString("</P>"));
	}
	
	if(tree.newsDescriptionAlign() > 0 && tree.newsDescriptionAlign() < 5)
		mStr.append(QString("</div>"));
		
	
	mStr.append(QString("<input name=\""));
	mStr.append(mName);
	mStr.append(QString("\" type=\"text\">"));
	mStr.append(QString("<input value=\"") + buttonText + QString("\" type=\"submit\">"));
	mStr.append(QString("</form>"));
	
	mStr.append(QString("<br>"));
}

