/***************************************************************************
                          rdftextinput.h  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RDFTEXTINPUT_H
#define RDFTEXTINPUT_H

#include <qstring.h>
#include <kurl.h>
#include <qdom.h>

#include "schemetree.h"
/**
  *@author Chris Wallace
  */

class RDFTextInput {
	public:
		RDFTextInput();
		RDFTextInput(const RDFTextInput & ti);
		~RDFTextInput();
		
		void operator = (const RDFTextInput & ti);
		
		void clear(void);
		
		const QString & title(void) const {return mTitle;}
		void setTitle(const QString & title) {mTitle = title;}
		
		const QString & description(void) const {return mDescription;}
		void setDescription(const QString & description) {mDescription = description;}
		
		const QString & name(void) const {return mName;}
		void setName(const QString & name) {mName = name;}
		
		const KURL & link(void) const {return mLink;}
		void setLink(const KURL & link) {mLink = link;}
		
		const QString & uri(void) const {return mRDFResource;}
		void setUri(const QString & uri) {mRDFResource = uri;}
		
		void write(QDomDocument & doc, QDomElement & elm);
		
		void displayNews(QString & mStr, SchemeTree & tree, const QString & buttonText);
	
	private:
		QString mTitle;		//A title for the text input
		QString mDescription;	//A description for the text input
		QString mName;	//The variable name to pass
		KURL mLink;		//The link to pass the variable name
	
		QString mRDFResource;	//Information about the text input must be the same as in the channel
};

#endif
