/***************************************************************************
                          rdftree.cpp  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "rdftree.h"
#include <qdom.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qimage.h>
#include <kiconloader.h>

#include "colourconverter.h"
#include "filterhandler.h"

RDFTree::RDFTree()
{
	mItem = 0;
	clear();
}

RDFTree::RDFTree(const RDFTree & t)
{
	operator = (t);
}

RDFTree::~RDFTree()
{
}

void RDFTree::operator = (const RDFTree & t)
{
	mXMLNS = t.mXMLNS;
	mXMLNSRDF = t.mXMLNSRDF;
	mChannel = t.mChannel;
	mImage = t.mImage;
	mTextInput = t.mTextInput;
	mItems = t.mItems;
}

void RDFTree::clear(void)
{
	// These must be set to this! for RSS 1.0
	mXMLNS = QString("http://purl.org/rss/1.0");
	mXMLNSRDF = QString("http://www.w3.org/1999/02/22-rdf-syntax-ns#");
	
	mChannel.clear();
	mImage.clear();
	mTextInput.clear();
	mItems.clear();
}

void RDFTree::write(const QString & filename)
{
	QDomDocument doc("");
	QDomElement rdfelm = doc.createElement("rdf:RDF");
	rdfelm.setAttribute(QString("xmlns"), mXMLNS);
	rdfelm.setAttribute(QString("xmlnsrdf"), mXMLNSRDF);
	doc.appendChild(rdfelm);
	mChannel.write(doc, rdfelm);
	if(mChannel.haveImage())
		mImage.write(doc, rdfelm);
	if(mChannel.haveTextInput())
		mTextInput.write(doc, rdfelm);
		
	for(RDFItem * i = mItems.first(); i != 0; i = mItems.next()) {
		i->write(doc, rdfelm);
	}
	
	//Write the file
	QFile f(filename);
	if(!f.open(IO_WriteOnly)) {
		return;
	}
	
	QTextStream t(&f);
	t << doc.toString();
	f.close();
}

void RDFTree::displayNews(const QString & siteTitle, QString & mStr, SchemeTree & tree, FilterHandler & filters, const QString & buttonText, QIconViewItem *mIcon, int imagex, int imagey)
{
	//if(mChannel.haveImage())
	if(mIcon) {
		if(channelTitle().isEmpty() || channelTitle().isNull())
			mIcon->setText(siteTitle);
		else
			mIcon->setText(channelTitle());
		QImage img;
		QPixmap pix;
		if(img.load(imageUrl().path())) {
			if(!pix.convertFromImage(img))
				pix = KIconLoader().loadIcon("mime_empty", KIcon::Small);
		}
		else
			pix = KIconLoader().loadIcon("mime_empty", KIcon::Small);
		QWMatrix sm;
		int h = pix.height(); if(h == 0) h = 1;
		int w = pix.width(); if(w == 0) w = 1;
		sm.scale( (double) imagex/w, (double) imagey/h);
		mIcon->setPixmap(pix.xForm(sm));
	}
		
	mImage.displayNews(mStr, tree);
	
	mChannel.displayNews(mStr, tree);
	
	mStr.append(QChar('\n'));
	
	if(tree.separateBetweenChannelsAndNews()) {
		mStr.append(QString("<HR"));
		switch(tree.separateBetweenChannelsAndNewsAlign()) {
			case 1: mStr.append(QString(" align=\"left\"")); break;
			case 2: mStr.append(QString(" align=\"right\""));	break;
			case 3:	mStr.append(QString(" align=\"center\"")); break;
		}
		mStr.append(QString(" size=") + QString::number(tree.separateBetweenChannelsAndNewsSize()));
		mStr.append(QString(" width=\"") + QString::number(tree.separateBetweenChannelsAndNewsWidth()) + QString("%\""));
		mStr.append(QString(" color=\"#"));
		ColourConverter::makeHTMLColour(mStr, tree.channelNewsSeparatorColour());
		mStr.append(QString("\">"));
		
		mStr.append(QChar('\n'));
	}
	
	if(mChannel.haveTextInput()) {
		mTextInput.displayNews(mStr, tree, buttonText);
		if(tree.separateBetweenNews()) {
			mStr.append(QString("<HR"));
			switch(tree.separateBetweenNewsAlign()) {
				case 1:	mStr.append(QString(" align=\"left\"")); break;
				case 2:	mStr.append(QString(" align=\"right\""));	break;
				case 3:	mStr.append(QString(" align=\"center\"")); break;
			}
			mStr.append(QString(" size=") + QString::number(tree.separateBetweenNewsSize()));
			mStr.append(QString(" width=\"") + QString::number(tree.separateBetweenNewsWidth()) + QString("%\""));
			mStr.append(QString(" color=\"#"));
			ColourConverter::makeHTMLColour(mStr, tree.newsSeparatorColour());
			mStr.append(QString("\">"));
		}
	}
	RDFItem *end = mItems.last();
	
	for(RDFItem *i = mItems.first(); i != 0; i = mItems.next()) {
		if(filters.filter(i->title(), i->description()) == FilterRule::Allow) {
			i->displayNews(mStr, tree);
			if(tree.separateBetweenNews() && i != end) {
				mStr.append(QString("<HR"));
				switch(tree.separateBetweenNewsAlign()) {
					case 1:	mStr.append(QString(" align=\"left\"")); break;
					case 2:	mStr.append(QString(" align=\"right\""));	break;
					case 3:	mStr.append(QString(" align=\"center\"")); break;
				}
				mStr.append(QString(" size=") + QString::number(tree.separateBetweenNewsSize()));
				mStr.append(QString(" width=\"") + QString::number(tree.separateBetweenNewsWidth()) + QString("%\""));
				mStr.append(QString(" color=\"#"));
				ColourConverter::makeHTMLColour(mStr, tree.newsSeparatorColour());
				mStr.append(QString("\">"));
			}
		}
	}
	
	if(tree.separateBetweenChannels()) {
		mStr.append(QString("<HR"));
		switch(tree.separateBetweenChannelsAlign()) {
			case 1:	mStr.append(QString(" align=\"left\"")); break;
			case 2:	mStr.append(QString(" align=\"right\""));	break;
			case 3:	mStr.append(QString(" align=\"center\"")); break;
		}
		mStr.append(QString(" size=") + QString::number(tree.separateBetweenChannelsSize()));
		mStr.append(QString(" width=\"") + QString::number(tree.separateBetweenChannelsWidth()) + QString("%\""));
		mStr.append(QString(" color=\"#"));
		ColourConverter::makeHTMLColour(mStr, tree.channelSeparatorColour());
		mStr.append(QString("\">"));
	}
}
