/***************************************************************************
                          rdftree.h  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RDFTREE_H
#define RDFTREE_H

#include <qlist.h>
#include <qstring.h>
#include <kiconview.h>

#include <iostream>

#include "rdfchannel.h"
#include "rdfimage.h"
#include "rdftextinput.h"
#include "rdfitem.h"
#include "schemetree.h"

class FilterHandler;
/**
  *@author Chris Wallace
  */

class RDFTree {
	public:
		RDFTree();
		RDFTree(const RDFTree & t);
		~RDFTree();
		
		void operator = (const RDFTree & t);
		
		void clear(void);
		
		void setXmlNS(const QString & xmlns) {mXMLNS = xmlns;}
		const QString & xmlNS(void) const {return mXMLNS;}
		
		void setXmlNSRDF(const QString & xmlnsrdf) {mXMLNSRDF = xmlnsrdf;}
		const QString & xmlNSRDF(void) const {return mXMLNSRDF;}
		
		void setComment(const QString & comment) {mComment = comment;}
		const QString & comment(void) const {return mComment;}
		
		void setChannelRDFAbout(const QString & about) {mChannel.setRDFAbout(about);}
		const QString & channelRDFAbout(void) const {return mChannel.rdfAbout();}
		
		void setChannelImageUri(const QString & uri) {mChannel.setImageUri(uri);}
		const QString & channelImageUri(void) const {return mChannel.imageUri();}
		
		void setChannelTextInputUri(const QString & uri) {mChannel.setTextInputUri(uri);}
		const QString & channelTextInputUri(void) const {mChannel.textInputUri();}
		
		void addChannelItemUri(const QString & uri) {mChannel.addItemUri(uri);}
		const QStringList & channelItemUris(void) const {mChannel.itemUris();}
		
		void setChannelTitle(const QString & title) {mChannel.setTitle(title);}
		const QString & channelTitle(void) const {return mChannel.title();}
		
		void setChannelLink(const KURL & url) {mChannel.setLink(url);}
		const KURL & channelLink(void) const {return mChannel.link();}
		
		void setChannelDescription(const QString & description) {mChannel.setDescription(description);}
		const QString & channelDescription(void) const {return mChannel.description();}
		
		void setItemTitle(const QString & title) {
			if(!mItem)
				createNewItem();
			mItem->setTitle(title);
		}
		
		void setItemLink(const KURL & link) {
			if(!mItem)
				createNewItem();
			mItem->setLink(link);
		}
		
		void setItemDescription(const QString & description) {
			if(!mItem)
				createNewItem();
			mItem->setDescription(description);
		}
		
		void setItemUri(const QString & uri) {
			if(!mItem)
				createNewItem();
			mItem->setUri(uri);
		}
		
		void addItem(void) {
			if(mItem) {
				mItems.append(mItem);
				mItem = 0;
			}
		}
		
		void setImageTitle(const QString & title) {mImage.setTitle(title);}
		const QString & imageTitle(void) const {return mImage.title();}
		
		void setImageUrl(const KURL & url) {mImage.setUrl(url);}
		const KURL & imageUrl(void) const {return mImage.url();}
		
		void setImageLink(const KURL & url) {mImage.setLink(url);}
		const KURL & imageLink(void) const {return mImage.link();}
		
		void setImageUri(const QString & uri) {mImage.setUri(uri);}
		const QString & imageUri(void) const {return mImage.uri();}
				
		void setTextInputTitle(const QString & title) {mTextInput.setTitle(title);}
		const QString & textInputTitle(void) const {return mTextInput.title();}
		
		void setTextInputDescription(const QString & description) {mTextInput.setDescription(description);}
		const QString & textInputDescription(void) const {return mTextInput.description();}
		
		void setTextInputName(const QString & name) {mTextInput.setName(name);}
		const QString & textInputName(void) const {return mTextInput.name();}
		
		void setTextInputLink(const KURL & link) {mTextInput.setLink(link);}
		const KURL & textInputLink(void) const {return mTextInput.link();}
		
		void setTextInputUri(const QString & uri) {mTextInput.setUri(uri);}
		const QString & textInputUri(void) const {return mTextInput.uri();}
		
		void write(const QString & fileName);
		
		bool fixImage(KURL & oldUrl, KURL & newUrl) {
			if(mChannel.haveImage()) {
				mImage.fixImage(oldUrl, newUrl);
				return true;
			}
			return false;
		}
		
		void displayNews(const QString & siteTitle, QString & mStr, SchemeTree & tree, FilterHandler & filters, const QString & buttonText, QIconViewItem *mIcon, int imagex, int imagey);
		
	protected:
		void createNewItem(void) {
			if(mItem)
				mItems.append(mItem);
			mItem = new RDFItem();
		}
		
	private:
		QString mXMLNS; //Stores the attributes
		QString mXMLNSRDF;
		
		QString mComment; // ie, <?xml version="1.0"?> comment
		
		RDFChannel mChannel; //Infomation about the channel
		
		RDFImage mImage; //Image Object
		RDFTextInput mTextInput;	//Text Input Object

		QList<RDFItem> mItems; // A list of the item objects
		RDFItem *mItem;	//The current item for adding;
		
};

#endif
