/***************************************************************************
                          rssparser.h  -  description
                             -------------------
    begin                : Sun Aug 5 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RSSPARSER_H
#define RSSPARSER_H

#include <qxml.h>
#include <kiconview.h>

#include "rdftree.h"
#include "schemetree.h"

class FilterHandler;
/**
  *@author Chris Wallace
  */

class RSSParser : public QXmlDefaultHandler  {
	public:
		RSSParser();
		RSSParser(const RSSParser & p);
		~RSSParser();
		
		void operator = (const RSSParser & p);
		
		void clear(void);
		
		static bool parseFile(const QString & fileName, bool fixImage, KURL & oldUrl, KURL & newUrl, bool updateMD5 = false);
		
		static void parseFile(const QString & fileName, RDFTree & tree);
		
		static void makeNews(const QString & siteTitle, const QString & fileName, QString & mStr, SchemeTree & tree, FilterHandler & filters, const QString & buttonText, KIconView *mIcons, int imagex, int imagey);
		
		void write(const QString & fileName) {
			mRDFTree.write(fileName);
		}
		
		bool fixImage(KURL & oldUrl, KURL & newUrl) {return mRDFTree.fixImage(oldUrl, newUrl);}
		
		void displayNews(const QString & siteTitle, QString & mStr, SchemeTree & tree, FilterHandler & filters, const QString & buttonText, QIconViewItem *mIcon, int imagex, int imagey) {mRDFTree.displayNews(siteTitle, mStr, tree, filters, buttonText, mIcon, imagex, imagey);}
		
		const RDFTree & rdfTree(void) {return mRDFTree;}
		
		static bool isNew(const QString & filename, bool updateMD5 = false);
		
	protected:
		bool startDocument();
		bool endDocument();
		bool startElement(const QString & namespaceURI, const QString & localName, const QString & qName, const QXmlAttributes & atts);
		bool endElement(const QString & namespaceURI, const QString & localName, const QString & qName);
		bool characters(const QString & ch);
		bool warning(const QXmlParseException & exception);
		bool error(const QXmlParseException & exception);
		bool fatalError(const QXmlParseException & exception);
		bool comment(const QString & ch);
				
	private:
		RDFTree mRDFTree;
		bool mReadingFile;
		bool mReadingRDF;
		bool mReadingChannel;
		bool mReadingImage;
		bool mReadingItem;
		bool mReadingTextInput;
		bool mReadingItems;
		bool mReadingItemSeq;
		bool mReadingItemSeqList;
		bool mReadingDescription;
		bool mReadingTitle;
		bool mReadingLink;
		bool mReadingUrl;
		bool mReadingName;
		
		bool mHadRDFTag;
		bool mPrevVersion;
		bool mIsHTML;
		bool mReadingBody;
		bool mHaveComment;
		bool mIsEmpty;
		
		QString rdftag;
		QString channeltag;
		QString titletag;
		QString linktag;
		QString desctag;
		QString imagetag;
		QString itemstag;
		QString rdfseqtag;
		QString rdflitag;
		QString textinputtag;
		QString urltag;
		QString nametag;
		QString itemtag;
		QString rsstag;
		QString htmltag;
		QString bodytag;
		
		QString mComment;
};

#endif
