/***************************************************************************
                          schemechannel.h  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCHEMECHANNEL_H
#define SCHEMECHANNEL_H

#include "schemetitle.h"
#include "schemeimage.h"
#include "schemetext.h"

/**
  *@author Chris Wallace
  */

class SchemeChannel {
	public:
		SchemeChannel();
		~SchemeChannel();
		
		void setTitleFont(const QFont & font) {mTitle.setFont(font);}
		const QFont & titleFont(void) const {return mTitle.font();}
		
		void setTitleAlign(unsigned int align) {mTitle.setAlign(align);}
		unsigned int titleAlign(void) {return mTitle.align();}
		
		void setTitleLevel(unsigned int level) {mTitle.setLevel(level);}
		unsigned int titleLevel(void) {return mTitle.level();}
		
		void setImageAlign(unsigned int align) {mImage.setAlign(align);}
		unsigned int imageAlign(void) {return mImage.align();}
		
		void setImageBorder(unsigned int border) {mImage.setBorder(border);}
		unsigned int imageBorder(void) {return mImage.border();}
		
		void setDescriptionFont(const QFont & font) {mDescription.setFont(font);}
		const QFont & descriptionFont(void) const {return mDescription.font();}
		
		void setDescriptionAlign(unsigned int align) {mDescription.setAlign(align);}
		unsigned int descriptionAlign(void) {return mDescription.align();}
		
		void clear(void);
	private:
		SchemeTitle mTitle;
		SchemeImage mImage;
		SchemeText mDescription;
};

#endif
