/***************************************************************************
                          schemecolours.h  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCHEMECOLOURS_H
#define SCHEMECOLOURS_H

#include <qcolor.h>

/**
  *@author Chris Wallace
  */

class SchemeColours {
	public:
		SchemeColours();
		~SchemeColours();
		
		void setBackgroundColour(const QColor & c) {mBackground = c;}
		const QColor & backgroundColour(void) const {return mBackground;}
			
		void setActiveLinkColour(const QColor & c) {mActiveLink = c;}
		const QColor & activeLinkColour(void) const {return mActiveLink;}
				
		void setVisitedLinkColour(const QColor & c) {mVisitedLink = c;}
		const QColor & visitedLinkColour(void) const {return mVisitedLink;}
				
		void setChannelTitleColour(const QColor & c) {mChannelTitle = c;}
		const QColor & channelTitleColour(void) const {return mChannelTitle;}
				
		void setChannelDescriptionColour(const QColor & c) {mChannelDescription = c;}
		const QColor & channelDescriptionColour(void) const {return mChannelDescription;}
			
		void setNewsTitleColour(const QColor & c) {mNewsTitle = c;}
		const QColor & newsTitleColour(void) const {return mNewsTitle;}
			
		void setNewsDescriptionColour(const QColor & c) {mNewsDescription = c;}
		const QColor & newsDescriptionColour(void) const {return mNewsDescription;}
			
		void setChannelSeparatorColour(const QColor & c) {mChannelSep = c;}
		const QColor & channelSeparatorColour(void) const {return mChannelSep;}
				
		void setNewsSeparatorColour(const QColor & c) {mNewsSep = c;}
		const QColor & newsSeparatorColour(void) const {return mNewsSep;}
				
		void setChannelNewsSeparatorColour(const QColor & c) {mChannelNewsSep = c;}
		const QColor & channelNewsSeparatorColour(void) const {return mChannelNewsSep;}
		
		void setMyChannelBarTextColour(const QColor & c) {mMyChannelBarText = c;}
		const QColor & myChannelBarTextColour(void) {return mMyChannelBarText;}
		
		void setMyChannelBarBackgroundColour(const QColor & c) {mMyChannelBarBackground = c;}
		const QColor & myChannelBarBackgroundColour(void)  {return mMyChannelBarBackground;}
		
		void setMyChannelBarNewFeedColour(const QColor & c) {mMyChannelBarNewFeedColour = c;}
		const QColor & myChannelBarNewFeedColour(void) {return mMyChannelBarNewFeedColour;}
			
		void clear(void);
		
	private:
		QColor mBackground;
		QColor mActiveLink;
		QColor mVisitedLink;
		QColor mChannelTitle;
		QColor mChannelDescription;
		QColor mNewsTitle;
		QColor mNewsDescription;
		QColor mChannelSep;
		QColor mNewsSep;
		QColor mChannelNewsSep;
		QColor mMyChannelBarText;
		QColor mMyChannelBarBackground;
		QColor mMyChannelBarNewFeedColour;
};

#endif
