/***************************************************************************
                          schemeeditor.h  -  description
                             -------------------
    begin                : Fri Oct 12 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCHEMEEDITOR_H
#define SCHEMEEDITOR_H

#include <qwidget.h>

#include "schemetree.h"

class KComboBox;
class KHTMLPart;
class KListView;
class QListViewItem;
class KFontChooser;
class KColorButton;
class KLineEdit;

class QPushButton;
class QLabel;
class QSpinBox;
class QFrame;
class QToolButton;
class QCheckBox;
class QSlider;

/**
  *@author Chris Wallace
  */

class SchemeEditor : public QWidget  {
   Q_OBJECT
	public:
		enum Type {
			Information=0,
			Text,
			OneLine,
			Font,
			Colour,
			Margins,
			Image,
			Separator,
			Align,
			Header,
			Border,
			Size,
			Width
		};
		
		enum Locate {
			Nowhere=0,
			Background,
			ActiveLink,
			VisitedLink,
			ChannelTitle,
			ChannelDescription,
			ChannelImage,
			ChannelSeparator,
			NewsTitle,
			NewsDescription,
			NewsSeparator,
			ChannelNewsSeparator,
			Margin,
			MyChannelBarText,
			MyChannelBarBackground,
			MyChannelBarImage,
			MyChannelBarNewFeed
		};
			
		SchemeEditor(QWidget *parent=0, const char *name=0);
		~SchemeEditor();
		
		void saveCurrentScheme(void);
		
	protected slots:
		void slotSchemeChanged(const QString &);
		void slotOptionChanged(QListViewItem *);
		
		void slotNewScheme(void);
		void slotSaveScheme(void);
		void slotSaveSchemeAs(void);
		void slotRemoveScheme(void);
		
		void slotImageBrowse(void);
		
	protected:
		void loadOptions(void);
		void loadSchemes(void);
		
		void loadOption(SchemeEditor::Type, SchemeEditor::Locate );
		void saveOption(SchemeEditor::Type, SchemeEditor::Locate );
		
		void displayHTML(void);
		
	private:
		SchemeTree mTree;
		
		KComboBox *mSchemes;
		QPushButton *mNewScheme;
		QPushButton *mSaveScheme;
		QPushButton *mSaveSchemeAs;
		QPushButton *mRemoveScheme;
		
		KHTMLPart *mPreview;
		
		KListView *mOptions;
		
		//Font Picker
		KFontChooser *mFont;
		//Colour Picker
		KColorButton *mColour;
		//Information
		QLabel *mInformation;
		//Margin Picker;
		QWidget *mMargin;
		QLabel *mLeftMarginText;
		QLabel *mRightMarginText;
		QLabel *mTopMarginText;
		QLabel *mBottomMarginText;
		QSpinBox *mLeftMargin;
		QSpinBox *mRightMargin;
		QSpinBox *mTopMargin;
		QSpinBox *mBottomMargin;
		//Image Picker
		QWidget *mImage;
		QFrame *mImageFrame;
		QCheckBox *mUseImage;
		QLabel *mImageURLText;
		QCheckBox *mFixedImage;
		KLineEdit *mImageURL;
		QToolButton *mImageBrowser;
		//Alignment Picker
		QWidget *mAlign;
		QLabel *mAlignmentText;
		KComboBox *mAlignment;
		//Header Picker
		QWidget *mHeader;
		QLabel *mHeaderText;
		KComboBox *mHeaders;
		//Border Picker
		QWidget *mBorder;
		QLabel *mBorderText;
		QSpinBox *mBorderValue;
		//Size Picker
		QWidget *mSize;
		QLabel *mSizeText;
		QSpinBox *mSizeValue;
		//Width Picker
		QWidget *mWidth;
		QLabel *mWidthText;
		QSlider *mWidthValue;
		//Separator Widget
		QWidget *mSeparator;
		QCheckBox *mUseSeparator;
		
		QString mHTMLText;
		
		Type mLastType;
		Locate mLastLocate;
		
		
		
		
};

#endif
