/***************************************************************************
                          schemegeneral.h  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCHEMEGENERAL_H
#define SCHEMEGENERAL_H

#include <qfont.h>

#include <kurl.h>


/**
  *@author Chris Wallace
  */

class SchemeGeneral {
	public:
		SchemeGeneral();
		~SchemeGeneral();
		
		void setUseBackgroundImage(bool use) {mUseBackground = use;}
		bool useBackgroundImage(void) {return mUseBackground;}
		
		void setBackgroundImageUrl(const KURL & url) {mBackgroundURL = url;}
		const KURL & backgroundImageUrl(void) const {return mBackgroundURL;}
		
		void setBackgroundImageFixed(bool fixed) {mFixed = fixed;}
		bool backgroundImageFixed(void) {return mFixed;}
		
		void setMyChannelBarUseBackgroundImage(bool use) {mMyChannelBarUseBackground = use;}
		bool myChannelBarUseBackgroundImage(void) {return mMyChannelBarUseBackground;}
		
		void setMyChannelBarBackgroundImageUrl(const KURL & url) {mMyChannelBarBackgroundURL = url;}
		const KURL & myChannelBarBackgroundImageUrl(void) {return mMyChannelBarBackgroundURL;}
		
		void setMyChannelBarBackgroundImageFixed(bool fixed) {mMyChannelBarFixed = fixed;}
		bool myChannelBarBackgroundImageFixed(void) {return mMyChannelBarFixed;}
		
		void setTopMargin(unsigned int top) {mTopMargin = top;}
		//void setTopMargin(const QString & top) {mTopMargin = top.toUInt();}
		unsigned int topMargin(void) {return mTopMargin;}
		//const QString & topMarginString(void) const {return QString::number(mTopMargin);}
		
		void setLeftMargin(unsigned int left) {mLeftMargin = left;}
		//void setLeftMargin(const QString & left) {mLeftMargin = left.toUInt();}
		unsigned int leftMargin(void) {return mLeftMargin;}
		//const QString & leftMarginString(void) const {return QString::number(mLeftMargin);}
		
		void setRightMargin(unsigned int right) {mRightMargin = right;}
		unsigned int rightMargin(void) {return mRightMargin;}
		
		void setBottomMargin(unsigned int bottom) {mBottomMargin = bottom;}
		unsigned int bottomMargin(void) {return mBottomMargin;}
		
		void setDateTimeFont(const QFont & f) {mDateTimeFont = f;}
		const QFont & dateTimeFont(void) {return mDateTimeFont;}
		
		void clear(void);
	private:
		bool mUseBackground;
		KURL mBackgroundURL;
		bool mFixed;
		
		bool mMyChannelBarUseBackground;
		KURL mMyChannelBarBackgroundURL;
		bool mMyChannelBarFixed;
		
		QFont mDateTimeFont;
		
		unsigned int mTopMargin;
		unsigned int mLeftMargin;
		unsigned int mRightMargin;
		unsigned int mBottomMargin;
};

#endif
