/***************************************************************************
                          schemenews.h  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCHEMENEWS_H
#define SCHEMENEWS_H

#include "schemetitle.h"
#include "schemetext.h"
/**
  *@author Chris Wallace
  */

class SchemeNews {
	public:
		SchemeNews();
		~SchemeNews();
		
		void setTitleLevel(unsigned int level) {mTitle.setLevel(level);}
		unsigned int titleLevel(void) {return mTitle.level();}
		
		void setTitleFont(const QFont & font) {mTitle.setFont(font);}
		const QFont & titleFont(void) const {return mTitle.font();}
		
		void setTitleAlign(unsigned int align) {mTitle.setAlign(align);}
		unsigned int titleAlign(void) {return mTitle.align();}
		
		void setDescriptionFont(const QFont & font) {mDescription.setFont(font);}
		const QFont & descriptionFont(void) const {return mDescription.font();}
		
		void setDescriptionAlign(unsigned int align) {mDescription.setAlign(align);}
		unsigned int descriptionAlign(void) {return mDescription.align();}
		
		void clear(void);
		
	private:
		SchemeTitle mTitle;
		SchemeText mDescription;
		
};

#endif
