/***************************************************************************
                          schemeparser.cpp  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "schemeparser.h"
#include <iostream>

SchemeParser::SchemeParser()
{
	schemetag = QString("scheme");
	generaltag = QString("general");
	backgroundtag = QString("background");
	imagetag = QString("image");
	urltag = QString("url");
	colourtag = QString("colour");
	margintag = QString("margins");
	toptag = QString("top");
	lefttag = QString("left");
	channeltag = QString("channel");
	titletag = QString("title");
	fonttag = QString("font");
	aligntag = QString("align");
	leveltag = QString("level");
	bordertag = QString("border");
	separatortag = QString("separators");
	channelseptag = QString("channelsep");
	sizetag = QString("size");
	widthtag = QString("width");
	newsseptag = QString("newssep");
	channelnewsseptag = QString("channelnewssep");
	descriptiontag = QString("description");
	linkstag = QString("links");
	activetag = QString("active");
	visitedtag = QString("visited");
	newstag = QString("news");
	texttag = QString("text");
	mychannelbartag = QString("mychannelbar");
	righttag = QString("right");
	bottomtag = QString("bottom");
	newfeed = QString("newfeedcolour");
	
	clear();
}

SchemeParser::~SchemeParser()
{
}

void SchemeParser::clear(void)
{
	mReadingFile = mReadingScheme = mReadingGeneral = mReadingChannel = false;
	mReadingImage = mReadingItem = mReadingSeparators = mReadingTitle = false;
	mReadingDescription = mReadingFont = mReadingColour = mReadingBackground = false;
	mReadingMargins = mReadingLeft = mReadingTop = mReadingAlign = false;
	mReadingBorder = mReadingLevel = mReadingSize = mReadingWidth = false;
	mReadingUrl = mReadingChannelNewsSeparator = mReadingNewsSeparator = false;
	mReadingChannelSeparator = mReadingLinks = mReadingActive = false;
	mReadingVisited = mReadingNews = mReadingText = mReadingMyChannelBar = false;
	mReadingRight = mReadingBottom = mReadingNewFeed = false;
	
	mTree.clear();
}

bool SchemeParser::startDocument()
{
	clear();
	mReadingFile = true;
	return true;
}

bool SchemeParser::endDocument()
{
	mReadingFile = false;
	return true;
}

bool SchemeParser::startElement(const QString & , const QString & , const QString & qName, const QXmlAttributes & atts)
{
	if(qName.compare(schemetag) == 0) {
		mReadingScheme = true;
	}
	else if(qName.compare(generaltag) == 0) {
		mReadingGeneral = true;
	}
	else if(qName.compare(backgroundtag) == 0) {
		mReadingBackground = true;
	}
	else if(qName.compare(mychannelbartag) == 0) {
		mReadingMyChannelBar = true;
	}
	else if(qName.compare(imagetag) == 0) {
		mReadingImage = true;
		if(mReadingMyChannelBar) {
			if(mReadingBackground) {
				for(int i=0; i<atts.length(); i++) {
					if(atts.qName(i).compare("use") == 0) {
						if(atts.value(i).compare("true") == 0 || atts.value(i).compare("yes") == 0) {
							mTree.setMyChannelBarUseBackgroundImage(true);
						}
						else {
							mTree.setMyChannelBarUseBackgroundImage(false);
						}
					}
					else if(atts.qName(i).compare("fixed") == 0) {
						if(atts.value(i).compare("true") == 0|| atts.value(i).compare("yes") == 0) {
							mTree.setMyChannelBarBackgroundImageFixed(true);
						}
						else {
							mTree.setMyChannelBarBackgroundImageFixed(false);
						}
					}
				}
			}
		}
		else {	
			if(mReadingBackground) {
				for(int i=0; i<atts.length(); i++) {
					if(atts.qName(i).compare("use") == 0) {
						if(atts.value(i).compare("true") == 0 || atts.value(i).compare("yes") == 0) {
							mTree.setUseBackgroundImage(true);
						}
						else {
							mTree.setUseBackgroundImage(false);
						}
					}
					else if(atts.qName(i).compare("fixed") == 0) {
						if(atts.value(i).compare("true") == 0 || atts.value(i).compare("yes") == 0) {
							mTree.setBackgroundImageFixed(true);
						}
						else {
							mTree.setBackgroundImageFixed(false);
						}
					}
				}
			}
		}
	}
	else if(qName.compare(urltag) == 0) {
		mReadingUrl = true;
	}
	else if(qName.compare(margintag) == 0) {
		mReadingMargins = true;
	}
	else if(qName.compare(toptag) == 0) {
		mReadingTop = true;
	}
	else if(qName.compare(lefttag) == 0) {
		mReadingLeft = true;
	}
	else if(qName.compare(righttag) == 0) {
		mReadingRight = true;
	}
	else if(qName.compare(bottomtag) == 0) {
		mReadingBottom = true;
	}
	else if(qName.compare(channeltag) == 0) {
		mReadingChannel = true;
	}
	else if(qName.compare(titletag) == 0) {
		mReadingTitle = true;
	}
	else if(qName.compare(aligntag) == 0) {
		mReadingAlign = true;
	}
	else if(qName.compare(leveltag) == 0) {
		mReadingLevel = true;
	}
	else if(qName.compare(bordertag) == 0) {
		mReadingBorder = true;
	}
	else if(qName.compare(descriptiontag) == 0) {
		mReadingDescription = true;
	}
	else if(qName.compare(separatortag) == 0) {
		mReadingSeparators = true;
	}
	else if(qName.compare(channelseptag) == 0) {
		mReadingChannelSeparator = true;
		for(int i=0; i<atts.length(); i++) {
			if(atts.qName(i).compare("use") == 0) {
				if(atts.value(i).compare("true") == 0 || atts.value(i).compare("yes") == 0) {
					mTree.setSeparateBetweenChannels(true);
				}
				else {
					mTree.setSeparateBetweenChannels(false);
				}
			}
		}
	}
	else if(qName.compare(sizetag) == 0) {
		mReadingSize = true;
	}
	else if(qName.compare(widthtag) == 0) {
		mReadingWidth = true;
	}
	else if(qName.compare(channelnewsseptag) == 0) {
		mReadingChannelNewsSeparator = true;
		for(int i=0; i<atts.length(); i++) {
			if(atts.qName(i).compare("use") == 0) {
				if(atts.value(i).compare("true") == 0 || atts.value(i).compare("yes") == 0) {
					mTree.setSeparateBetweenChannelsAndNews(true);
				}
				else {
					mTree.setSeparateBetweenChannelsAndNews(false);
				}
			}
		}
	}
	else if(qName.compare(newsseptag) == 0) {
		mReadingNewsSeparator = true;
		for(int i=0; i<atts.length(); i++) {
			if(atts.qName(i).compare("use") == 0) {
				if(atts.value(i).compare("true") == 0 || atts.value(i).compare("yes") == 0) {
					mTree.setSeparateBetweenNews(true);
				}
				else {
					mTree.setSeparateBetweenNews(false);
				}
			}
		}
	}
	else if(qName.compare(linkstag) == 0) {
		mReadingLinks = true;
	}
	else if(qName.compare(activetag) == 0) {
		mReadingActive = true;
	}
	else if(qName.compare(visitedtag) == 0) {
		mReadingVisited = true;
	}
	else if(qName.compare(newstag) == 0) {
		mReadingNews = true;
	}
	else if(qName.compare(colourtag) == 0) {
		mReadingColour = true;
		QColor c;
		int red = 0, green = 0, blue = 0;
		for(int i=0; i<atts.length(); i++) {
			if(atts.qName(i).compare("red") == 0) {
				red = atts.value(i).toInt();
			}
			else if(atts.qName(i).compare("green") == 0) {
				green = atts.value(i).toInt();
			}
			else if(atts.qName(i).compare("blue") == 0) {
				blue = atts.value(i).toInt();
			}
		}
		c.setRgb(red, green, blue);
		if(mReadingGeneral) {
			if(mReadingMyChannelBar) {
				if(mReadingBackground) {
					mTree.setMyChannelBarBackgroundColour(c);
				}
				else if(mReadingText) {
					//cerr << "Setting MyChannelBar Text Colour: " << c.red() << ", " << c.green() << ", " << c.blue() << endl;
					mTree.setMyChannelBarTextColour(c);
				}
			}
			else if(mReadingBackground) {
				mTree.setBackgroundColour(c);
			}
			else if(mReadingLinks) {
				if(mReadingActive) {
					//cerr << "SETTING ACTIVE LINK COLOUR: " << red << "," << green << "," << blue << endl;
					mTree.setActiveLinkColour(c);
				}
				else if(mReadingVisited) {
					//cerr << "SETTING VISITED LINK COLOUR: " << red << "," << green << "," << blue << endl;
					mTree.setVisitedLinkColour(c);
				}
			}
		}
		else if(mReadingChannel) {
			if(mReadingTitle) {
				//cerr << "CHANNEL TITLE COLOUR: " << red << "," << green << "," << blue << endl;
				mTree.setChannelTitleColour(c);
			}
			else if(mReadingDescription) {
				//cerr << "CHANNEL DESCRIPTION COLOUR: " << red << "," << green << "," << blue << endl;
				mTree.setChannelDescriptionColour(c);
			}
		}
		else if(mReadingNews) {
			if(mReadingTitle) {
				mTree.setNewsTitleColour(c);
			}
			else if(mReadingDescription) {
				mTree.setNewsDescriptionColour(c);
			}
		}
		else if(mReadingSeparators) {
			if(mReadingChannelSeparator) {
				mTree.setChannelSeparatorColour(c);
			}
			else if(mReadingNewsSeparator) {
				mTree.setNewsSeparatorColour(c);
			}
			else if(mReadingChannelNewsSeparator) {
				mTree.setChannelNewsSeparatorColour(c);
			}
		}
	}		
	else if(qName.compare(fonttag) == 0) {
		mReadingFont = true;
		QFont font = QFont::defaultFont();
		for(int i=0; i<atts.length(); i++) {
			if(atts.qName(i).compare("family") == 0) {
				font.setFamily(atts.value(i));	
			}
			else if(atts.qName(i).compare("size") == 0) {
				font.setPointSize(atts.value(i).toInt());
			}
			else if(atts.qName(i).compare("bold") == 0) {
				if(atts.value(i).compare("true") == 0 || atts.value(i).compare("yes") == 0)
					font.setBold(true);
				else
					font.setBold(false);
			}
			else if(atts.qName(i).compare("italic") == 0) {
				if(atts.value(i).compare("true") == 0 || atts.value(i).compare("yes") == 0)
					font.setItalic(true);
				else
					font.setItalic(false);
			}
			else if(atts.qName(i).compare("underline") == 0) {
				if(atts.value(i).compare("true") == 0 || atts.value(i).compare("yes") == 0)
					font.setUnderline(true);
				else
					font.setUnderline(false);
			}
			else if(atts.qName(i).compare("charset") == 0) {
				font.setCharSet((QFont::CharSet) atts.value(i).toInt());
			}
		}
		if(mReadingChannel) {
			if(mReadingTitle) {
				mTree.setChannelTitleFont(font);
			}
			else if(mReadingDescription) {
				mTree.setChannelDescriptionFont(font);
			}
		}
		else if(mReadingNews) {
			if(mReadingTitle) {
				mTree.setNewsTitleFont(font);
			}
			else if(mReadingDescription) {
				mTree.setNewsDescriptionFont(font);
			}
		}
	}
	else if(qName.compare(texttag) == 0) {
		mReadingText = true;
	}
	else if(qName.compare(newfeed) == 0) {
		mReadingNewFeed = true;
		QColor c;
		int red = 0, green = 0, blue = 0;
		for(int i=0; i<atts.length(); i++) {
			if(atts.qName(i).compare("red") == 0) {
				red = atts.value(i).toInt();
			}
			else if(atts.qName(i).compare("green") == 0) {
				green = atts.value(i).toInt();
			}
			else if(atts.qName(i).compare("blue") == 0) {
				blue = atts.value(i).toInt();
			}
		}
		c.setRgb(red, green, blue);
		mTree.setMyChannelBarNewFeedColour(c);
	}
	else {
		cerr << "Not Parsing Element: " << qName << endl;
	}
	return true;
}

bool SchemeParser::endElement(const QString & , const QString & , const QString & qName)
{
	if(qName.compare(schemetag) == 0) {
		mReadingScheme = false;
	}
	else if(qName.compare(generaltag) == 0) {
		mReadingGeneral = false;
	}
	else if(qName.compare(mychannelbartag) == 0) {
		mReadingMyChannelBar = false;
	}
	else if(qName.compare(backgroundtag) == 0) {
		mReadingBackground = false;
	}
	else if(qName.compare(imagetag) == 0) {
		mReadingImage = false;
	}
	else if(qName.compare(urltag) == 0) {
		mReadingUrl = false;
	}
	else if(qName.compare(margintag) == 0) {
		mReadingMargins = false;
	}
	else if(qName.compare(toptag) == 0) {
		mReadingTop = false;
	}
	else if(qName.compare(lefttag) == 0) {
		mReadingLeft = false;
	}
	else if(qName.compare(righttag) == 0) {
		mReadingRight = false;
	}
	else if(qName.compare(bottomtag) == 0) {
		mReadingBottom = false;
	}
	else if(qName.compare(channeltag) == 0) {
		mReadingChannel = false;
	}
	else if(qName.compare(titletag) == 0) {
		mReadingTitle = false;
	}
	else if(qName.compare(aligntag) == 0) {
		mReadingAlign = false;
	}
	else if(qName.compare(leveltag) == 0) {
		mReadingLevel = false;
	}
	else if(qName.compare(bordertag) == 0) {
		mReadingBorder = false;
	}
	else if(qName.compare(descriptiontag) == 0) {
		mReadingDescription = false;
	}
	else if(qName.compare(separatortag) == 0) {
		mReadingSeparators = false;
	}
	else if(qName.compare(channelseptag) == 0) {
		mReadingChannelSeparator = false;
	}
	else if(qName.compare(sizetag) == 0) {
		mReadingSize = false;
	}
	else if(qName.compare(widthtag) == 0) {
		mReadingWidth = false;
	}
	else if(qName.compare(channelnewsseptag) == 0) {
		mReadingChannelNewsSeparator = false;
	}
	else if(qName.compare(newsseptag) == 0) {
		mReadingNewsSeparator = false;
	}
	else if(qName.compare(linkstag) == 0) {
		mReadingLinks = false;
	}
	else if(qName.compare(activetag) == 0) {
		mReadingActive = false;
	}
	else if(qName.compare(visitedtag) == 0) {
		mReadingVisited = false;
	}
	else if(qName.compare(newstag) == 0) {
		mReadingNews = false;
	}
	else if(qName.compare(fonttag) == 0) {
		mReadingFont = false;
	}
	else if(qName.compare(texttag) == 0) {
		mReadingText = false;
	}
	else if(qName.compare(newfeed) == 0) {
		mReadingNewFeed = false;
	}
	return true;
}

bool SchemeParser::characters(const QString & ch)
{
	if(mReadingFile) {
		if(mReadingScheme) {
			if(mReadingGeneral) {
				if(mReadingMyChannelBar) {
					if(mReadingBackground) {
						if(mReadingImage) {
							if(mReadingUrl) {
								mTree.setMyChannelBarBackgroundImageUrl(KURL(ch.stripWhiteSpace()));
							}
						}
					}
				}
				else if(mReadingBackground) {
					if(mReadingImage) {
						if(mReadingUrl) {
							mTree.setBackgroundImageUrl(KURL(ch.stripWhiteSpace()));
						}
					}
				}
				else if(mReadingMargins) {
					if(mReadingTop) {
						mTree.setTopMargin(ch.toUInt());
					}
					else if(mReadingLeft) {
						mTree.setLeftMargin(ch.toUInt());
					}
					else if(mReadingRight) {
						mTree.setRightMargin(ch.toUInt());
					}
					else if(mReadingBottom) {
						mTree.setBottomMargin(ch.toUInt());
					}
				}
			}
			else if(mReadingChannel) {
				if(mReadingTitle) {
					if(mReadingAlign) {
						mTree.setChannelTitleAlign(ch.toUInt());
					}
					else if(mReadingLevel) {
						mTree.setChannelTitleHeaderLevel(ch.toUInt());
					}
				}
				else if(mReadingImage) {
					if(mReadingAlign) {
						mTree.setChannelImageAlign(ch.toUInt());
					}
					else if(mReadingBorder) {
						mTree.setChannelImageBorder(ch.toUInt());
					}
				}
				else if(mReadingDescription) {
					if(mReadingAlign) {
						mTree.setChannelDescriptionAlign(ch.toUInt());
					}
				}
			}
			else if(mReadingNews) {
				if(mReadingTitle) {
					if(mReadingAlign) {
						mTree.setNewsTitleAlign(ch.toUInt());
					}
					else if(mReadingLevel) {
						mTree.setNewsTitleHeaderLevel(ch.toUInt());
					}
				}
				else if(mReadingDescription) {
					if(mReadingAlign) {
						mTree.setNewsDescriptionAlign(ch.toUInt());
					}
				}
			}
			else if(mReadingSeparators) {
				if(mReadingChannelSeparator) {
					if(mReadingAlign) {
						mTree.setSeparateBetweenChannelsAlign(ch.toUInt());
					}
					else if(mReadingSize) {
						mTree.setSeparateBetweenChannelsSize(ch.toUInt());
					}
					else if(mReadingWidth) {
						mTree.setSeparateBetweenChannelsWidth(ch.toUInt());
					}
				}
				else if(mReadingNewsSeparator) {
					if(mReadingAlign) {
						mTree.setSeparateBetweenNewsAlign(ch.toUInt());
					}
					else if(mReadingSize) {
						mTree.setSeparateBetweenNewsSize(ch.toUInt());
					}
					else if(mReadingWidth) {
						mTree.setSeparateBetweenNewsWidth(ch.toUInt());
					}
				}
				else if(mReadingChannelNewsSeparator) {
					if(mReadingAlign) {
						mTree.setSeparateBetweenChannelsAndNewsAlign(ch.toUInt());
					}
					else if(mReadingSize) {
						mTree.setSeparateBetweenChannelsAndNewsSize(ch.toUInt());
					}
					else if(mReadingWidth) {
						mTree.setSeparateBetweenChannelsAndNewsWidth(ch.toUInt());
					}
				}
			}
		}
	}
	return true;
}

bool SchemeParser::warning(const QXmlParseException & exception)
{
	cerr << endl;
	cerr << "SchemeParser reported: " << endl;
	cerr << "Waring: (" << exception.lineNumber() << "," << exception.columnNumber() << ")" << endl;
	cerr << "      " << exception.message() << endl;
	return true;
}

bool SchemeParser::error(const QXmlParseException & exception)
{
	cerr << endl;
	cerr << "SchemeParser reported: " << endl;
	cerr << "Error: (" << exception.lineNumber() << "," << exception.columnNumber() << ")" << endl;
	cerr << "     " << exception.message() << endl;
	return true;
}

bool SchemeParser::fatalError(const QXmlParseException & exception)
{
	cerr << endl;
	cerr << "SchemeParser reported: " << endl;
	cerr << "Fatal Error: (" << exception.lineNumber() << "," << exception.columnNumber() << ")" << endl;
	cerr << "           " << exception.message() << endl;
	return true;
}

void SchemeParser::parseFile(const QString & fileName, SchemeTree & tree)
{
	SchemeParser parser;
	QFile xmlFile(fileName);
	QXmlInputSource source(xmlFile);
	QXmlSimpleReader reader;
	reader.setContentHandler(&parser);
	reader.setErrorHandler(&parser);
	reader.parse(source);
	
	tree = parser.getTree();
	
}
