/***************************************************************************
                          schemeparser.h  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCHEMEPARSER_H
#define SCHEMEPARSER_H

#include <qxml.h>


#include "schemetree.h"

/**
  *@author Chris Wallace
  */

class SchemeParser : public QXmlDefaultHandler  {
	public:
		SchemeParser();
		~SchemeParser();
		
		static void parseFile(const QString & filename, SchemeTree & tree);
		
		void clear(void);
		
	protected:
		bool startDocument();
		bool endDocument();
		bool startElement(const QString & namespaceURI, const QString & localName, const QString & qName, const QXmlAttributes & atts);
		bool endElement(const QString & namespaceURI, const QString & localName, const QString & qName);
		bool characters(const QString & ch);
		bool warning(const QXmlParseException & exception);
		bool error(const QXmlParseException & exception);
		bool fatalError(const QXmlParseException & exception);
		
		SchemeTree & getTree(void) {return mTree;}
		
	private:
		SchemeTree mTree;
		
		bool mReadingFile;
		bool mReadingScheme;
		bool mReadingGeneral;
		bool mReadingChannel;
		bool mReadingImage;
		bool mReadingItem;
		bool mReadingSeparators;
		bool mReadingTitle;
		bool mReadingDescription;
		bool mReadingFont;
		bool mReadingColour;
		bool mReadingBackground;
		bool mReadingMargins;
		bool mReadingLeft;
		bool mReadingTop;
		bool mReadingRight;
		bool mReadingBottom;
		bool mReadingAlign;
		bool mReadingBorder;
		bool mReadingLevel;
		bool mReadingSize;
		bool mReadingWidth;
		bool mReadingUrl;
		bool mReadingChannelNewsSeparator;
		bool mReadingNewsSeparator;
		bool mReadingChannelSeparator;
		bool mReadingLinks;
		bool mReadingActive;
		bool mReadingVisited;
		bool mReadingNews;
		bool mReadingText;
		bool mReadingMyChannelBar;
		bool mReadingNewFeed;
		
		
		QString schemetag;
		QString generaltag;
		QString backgroundtag;
		QString imagetag;
		QString urltag;
		QString colourtag;
		QString margintag;
		QString toptag;
		QString lefttag;
		QString righttag;
		QString bottomtag;
		QString channeltag;
		QString titletag;
		QString fonttag;
		QString aligntag;
		QString leveltag;
		QString bordertag;
		QString separatortag;
		QString channelseptag;
		QString sizetag;
		QString widthtag;
		QString newsseptag;
		QString channelnewsseptag;
		QString descriptiontag;
		QString linkstag;
		QString activetag;
		QString visitedtag;
		QString newstag;
		QString texttag;
		QString mychannelbartag;
		QString newfeed;
};

#endif
