/***************************************************************************
                          schemetree.cpp  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "schemetree.h"

#include <qdom.h>
#include <qfile.h>
#include <qtextstream.h>
#include <iostream>

#include "colourconverter.h"

SchemeTree::SchemeTree()
{	
	clear();
}

SchemeTree::SchemeTree(const SchemeTree & tree)
{
	operator = (tree);
}

SchemeTree::~SchemeTree()
{
}

void SchemeTree::operator = (const SchemeTree & tree)
{
	mColours = tree.mColours;
	mGeneral = tree.mGeneral;
	mChannel = tree.mChannel;
	mNews = tree.mNews;
	mSeparators = tree.mSeparators;
}

void SchemeTree::clear(void)
{
	mColours.clear();
	mGeneral.clear();
	mChannel.clear();
	mNews.clear();
	mSeparators.clear();
}

void SchemeTree::write(const QString & filename)
{
	QDomDocument doc("KrssScheme");
	
	QDomElement elm = doc.createElement("scheme");
		
	QDomElement gelm = doc.createElement("general");
		QDomElement mcbelm = doc.createElement("mychannelbar");
			QDomElement mcbbelm = doc.createElement("background");
				QDomElement mcbbcelm = doc.createElement("colour");
				mcbbcelm.setAttribute("red", QString::number(myChannelBarBackgroundColour().red()));
				mcbbcelm.setAttribute("green", QString::number(myChannelBarBackgroundColour().green()));
				mcbbcelm.setAttribute("blue", QString::number(myChannelBarBackgroundColour().blue()));
				mcbbelm.appendChild(mcbbcelm);
				QDomElement mcbielm = doc.createElement("image");
					if(myChannelBarUseBackgroundImage())
						mcbielm.setAttribute("use", "true");
					else
						mcbielm.setAttribute("use", "false");
					if(myChannelBarBackgroundImageFixed())
						mcbielm.setAttribute("fixed", "true");
					else
						mcbielm.setAttribute("fixed", "false");
					QDomElement mcbuelm = doc.createElement("url");
						QDomText mcbutxt = doc.createTextNode(myChannelBarBackgroundImageUrl().url());
						mcbuelm.appendChild(mcbutxt);
					mcbielm.appendChild(mcbuelm);
				mcbbelm.appendChild(mcbielm);
			mcbelm.appendChild(mcbbelm);
			QDomElement mcbtelm = doc.createElement("text");
				QDomElement mcbtcelm = doc.createElement("colour");
					mcbtcelm.setAttribute("red", QString::number(myChannelBarTextColour().red()));
					mcbtcelm.setAttribute("green", QString::number(myChannelBarTextColour().green()));
					mcbtcelm.setAttribute("blue", QString::number(myChannelBarTextColour().blue()));
				mcbtelm.appendChild(mcbtcelm);
				QDomElement mcbtnfcelm = doc.createElement("newfeedcolour");
					mcbtnfcelm.setAttribute("red", QString::number(myChannelBarNewFeedColour().red()));
					mcbtnfcelm.setAttribute("green", QString::number(myChannelBarNewFeedColour().green()));
					mcbtnfcelm.setAttribute("blue", QString::number(myChannelBarNewFeedColour().blue()));
				mcbtelm.appendChild(mcbtnfcelm);
			mcbelm.appendChild(mcbtelm);
				
		gelm.appendChild(mcbelm);
		QDomElement belm = doc.createElement("background");
			QDomElement bielm = doc.createElement("image");
				if(useBackgroundImage())
					bielm.setAttribute("use", "true");
				else
					bielm.setAttribute("use", "false");
				if(backgroundImageFixed())
					bielm.setAttribute("fixed", "true");
				else
					bielm.setAttribute("fixed", "false");
				QDomElement uelm = doc.createElement("url");
					QDomText utxt = doc.createTextNode(backgroundImageUrl().url());
					uelm.appendChild(utxt);
				bielm.appendChild(uelm);
			belm.appendChild(bielm);
			QDomElement bcelm = doc.createElement("colour");
				bcelm.setAttribute("red", QString::number(backgroundColour().red()));
				bcelm.setAttribute("green", QString::number(backgroundColour().green()));
				bcelm.setAttribute("blue", QString::number(backgroundColour().blue()));
			belm.appendChild(bcelm);
		gelm.appendChild(belm);
		QDomElement melm = doc.createElement("margins");
			QDomElement mtelm = doc.createElement("top");
				QDomText mttxt = doc.createTextNode(QString::number(topMargin()));
			mtelm.appendChild(mttxt);
		melm.appendChild(mtelm);
			QDomElement mlelm = doc.createElement("left");
				QDomText mltxt = doc.createTextNode(QString::number(leftMargin()));
			mlelm.appendChild(mltxt);
		melm.appendChild(mlelm);
			QDomElement mrelm = doc.createElement("right");
				QDomText mrtxt = doc.createTextNode(QString::number(rightMargin()));
			mrelm.appendChild(mrtxt);
		melm.appendChild(mrelm);
			QDomElement mbelm = doc.createElement("bottom");
				QDomText mbtxt = doc.createTextNode(QString::number(bottomMargin()));
			mbelm.appendChild(mbtxt);
		melm.appendChild(mbelm);
	gelm.appendChild(melm);
		QDomElement lelm = doc.createElement("links");
			QDomElement laelm = doc.createElement("active");
				QDomElement lacelm = doc.createElement("colour");
					lacelm.setAttribute("red", QString::number(activeLinkColour().red()));
					lacelm.setAttribute("green", QString::number(activeLinkColour().green()));
					lacelm.setAttribute("blue", QString::number(activeLinkColour().blue()));
			laelm.appendChild(lacelm);
		lelm.appendChild(laelm);
			QDomElement lvelm = doc.createElement("visited");
				QDomElement lvcelm = doc.createElement("colour");
					lvcelm.setAttribute("red", QString::number(visitedLinkColour().red()));
					lvcelm.setAttribute("green", QString::number(visitedLinkColour().green()));
					lvcelm.setAttribute("blue", QString::number(visitedLinkColour().blue()));
			lvelm.appendChild(lvcelm);
		lelm.appendChild(lvelm);
	gelm.appendChild(lelm);
	elm.appendChild(gelm);
	
	QDomElement celm = doc.createElement("channel");
		QDomElement ctelm = doc.createElement("title");
			QDomElement ctcelm = doc.createElement("colour");
				ctcelm.setAttribute("red", QString::number(channelTitleColour().red()));
				ctcelm.setAttribute("green", QString::number(channelTitleColour().green()));
				ctcelm.setAttribute("blue", QString::number(channelTitleColour().blue()));
		ctelm.appendChild(ctcelm);
			QDomElement ctfelm = doc.createElement("font");
			ctfelm.setAttribute("family", channelTitleFont().family());
			ctfelm.setAttribute("size", QString::number(channelTitleFont().pointSize()));
			if(channelTitleFont().bold())
				ctfelm.setAttribute("bold", "true");
			else
				ctfelm.setAttribute("bold", "false");
			if(channelTitleFont().italic())
				ctfelm.setAttribute("italic", "true");
			else
				ctfelm.setAttribute("italic", "false");
			if(channelTitleFont().underline())
				ctfelm.setAttribute("underline", "true");
			else
				ctfelm.setAttribute("underline", "false");
			ctfelm.setAttribute("charset", QString::number(channelTitleFont().charSet()));
		ctelm.appendChild(ctfelm);
		QDomElement ctaelm = doc.createElement("align");
			QDomText ctatxt = doc.createTextNode(QString::number(channelTitleAlign()));
			ctaelm.appendChild(ctatxt);
		ctelm.appendChild(ctaelm);
		QDomElement ctlelm = doc.createElement("level");
			QDomText ctltxt = doc.createTextNode(QString::number(channelTitleHeaderLevel()));
			ctlelm.appendChild(ctltxt);
		ctelm.appendChild(ctlelm);
	celm.appendChild(ctelm);
		QDomElement cielm = doc.createElement("image");
			QDomElement ciaelm = doc.createElement("align");
				QDomText ciatxt = doc.createTextNode(QString::number(channelImageAlign()));
			ciaelm.appendChild(ciatxt);
		cielm.appendChild(ciaelm);
			QDomElement cibelm = doc.createElement("border");
				QDomText cibtxt = doc.createTextNode(QString::number(channelImageBorder()));
			cibelm.appendChild(cibtxt);
		cielm.appendChild(cibelm);
	celm.appendChild(cielm);
		QDomElement cdelm = doc.createElement("description");
			QDomElement cdcelm = doc.createElement("colour");
				cdcelm.setAttribute("red", QString::number(channelDescriptionColour().red()));
				cdcelm.setAttribute("green", QString::number(channelDescriptionColour().green()));
				cdcelm.setAttribute("blue", QString::number(channelDescriptionColour().blue()));
		cdelm.appendChild(cdcelm);
			QDomElement cdfelm = doc.createElement("font");
			cdfelm.setAttribute("family", channelDescriptionFont().family());
			cdfelm.setAttribute("size", QString::number(channelDescriptionFont().pointSize()));
			if(channelDescriptionFont().bold())
				cdfelm.setAttribute("bold", "true");
			else
				cdfelm.setAttribute("bold", "false");
			if(channelDescriptionFont().italic())
				cdfelm.setAttribute("italic", "true");
			else
				cdfelm.setAttribute("italic", "false");
			if(channelDescriptionFont().underline())
				cdfelm.setAttribute("underline", "true");
			else
				cdfelm.setAttribute("underline", "false");
			cdfelm.setAttribute("charset", QString::number(channelDescriptionFont().charSet()));
		cdelm.appendChild(cdfelm);
			QDomElement cdaelm = doc.createElement("align");
				QDomText cdatxt = doc.createTextNode(QString::number(channelDescriptionAlign()));
			cdaelm.appendChild(cdatxt);
		cdelm.appendChild(cdaelm);
	celm.appendChild(cdelm);
	elm.appendChild(celm);
	
	QDomElement nelm = doc.createElement("news");
		QDomElement ntelm = doc.createElement("title");
			QDomElement ntcelm = doc.createElement("colour");
				ntcelm.setAttribute("red", QString::number(newsTitleColour().red()));
				ntcelm.setAttribute("green", QString::number(newsTitleColour().green()));
				ntcelm.setAttribute("blue", QString::number(newsTitleColour().blue()));
		ntelm.appendChild(ntcelm);
			QDomElement ntfelm = doc.createElement("font");
			ntfelm.setAttribute("family", newsTitleFont().family());
			ntfelm.setAttribute("size", QString::number(newsTitleFont().pointSize()));
			if(newsTitleFont().bold())
				ntfelm.setAttribute("bold", "true");
			else
				ntfelm.setAttribute("bold", "false");
			if(newsTitleFont().italic())
				ntfelm.setAttribute("italic", "true");
			else
				ntfelm.setAttribute("italic", "false");
			if(newsTitleFont().underline())
				ntfelm.setAttribute("underline", "true");
			else
				ntfelm.setAttribute("underline", "false");
			ntfelm.setAttribute("charset", QString::number(newsTitleFont().charSet()));
		ntelm.appendChild(ntfelm);
		QDomElement ntaelm = doc.createElement("align");
			QDomText ntatxt = doc.createTextNode(QString::number(newsTitleAlign()));
			ntaelm.appendChild(ntatxt);
		ntelm.appendChild(ntaelm);
		QDomElement ntlelm = doc.createElement("level");
			QDomText ntltxt = doc.createTextNode(QString::number(newsTitleHeaderLevel()));
			ntlelm.appendChild(ntltxt);
		ntelm.appendChild(ntlelm);
	nelm.appendChild(ntelm);
		QDomElement ndelm = doc.createElement("description");
			QDomElement ndcelm = doc.createElement("colour");
				ndcelm.setAttribute("red", QString::number(newsDescriptionColour().red()));
				ndcelm.setAttribute("green", QString::number(newsDescriptionColour().green()));
				ndcelm.setAttribute("blue", QString::number(newsDescriptionColour().blue()));
		ndelm.appendChild(ndcelm);
			QDomElement ndfelm = doc.createElement("font");
			ndfelm.setAttribute("family", newsDescriptionFont().family());
			ndfelm.setAttribute("size", QString::number(newsDescriptionFont().pointSize()));
			if(newsDescriptionFont().bold())
				ndfelm.setAttribute("bold", "true");
			else
				ndfelm.setAttribute("bold", "false");
			if(newsDescriptionFont().italic())
				ndfelm.setAttribute("italic", "true");
			else
				ndfelm.setAttribute("italic", "false");
			if(newsDescriptionFont().underline())
				ndfelm.setAttribute("underline", "true");
			else
				ndfelm.setAttribute("underline", "false");
			ndfelm.setAttribute("charset", QString::number(newsDescriptionFont().charSet()));
		ndelm.appendChild(ndfelm);
			QDomElement ndaelm = doc.createElement("align");
				QDomText ndatxt = doc.createTextNode(QString::number(newsDescriptionAlign()));
			ndaelm.appendChild(ndatxt);
		ndelm.appendChild(ndaelm);
	nelm.appendChild(ndelm);
	elm.appendChild(nelm);
	
	QDomElement selm = doc.createElement("separators");
		QDomElement scelm = doc.createElement("channelsep");
			if(separateBetweenChannels())
				scelm.setAttribute("use", "true");
			else
				scelm.setAttribute("use", "false");
			QDomElement sccelm = doc.createElement("colour");
				sccelm.setAttribute("red", QString::number(channelSeparatorColour().red()));
				sccelm.setAttribute("green", QString::number(channelSeparatorColour().green()));
				sccelm.setAttribute("blue", QString::number(channelSeparatorColour().blue()));
		scelm.appendChild(sccelm);
			QDomElement scaelm = doc.createElement("align");
				QDomText scatxt = doc.createTextNode(QString::number(separateBetweenChannelsAlign()));
			scaelm.appendChild(scatxt);
		scelm.appendChild(scaelm);
			QDomElement scselm = doc.createElement("size");
				QDomText scstxt = doc.createTextNode(QString::number(separateBetweenChannelsSize()));
			scselm.appendChild(scstxt);
		scelm.appendChild(scselm);
			QDomElement scwelm = doc.createElement("width");
				QDomText scwtxt = doc.createTextNode(QString::number(separateBetweenChannelsWidth()));
			scwelm.appendChild(scwtxt);
		scelm.appendChild(scwelm);
	selm.appendChild(scelm);
		QDomElement scnelm = doc.createElement("channelnewssep");
			if(separateBetweenChannelsAndNews())
				scnelm.setAttribute("use", "true");
			else
				scnelm.setAttribute("use", "false");
			QDomElement scncelm = doc.createElement("colour");
				scncelm.setAttribute("red", QString::number(channelNewsSeparatorColour().red()));
				scncelm.setAttribute("green", QString::number(channelNewsSeparatorColour().green()));
				scncelm.setAttribute("blue", QString::number(channelNewsSeparatorColour().blue()));
		scnelm.appendChild(scncelm);
			QDomElement scnaelm = doc.createElement("align");
				QDomText scnatxt = doc.createTextNode(QString::number(separateBetweenChannelsAndNewsAlign()));
			scnaelm.appendChild(scnatxt);
		scnelm.appendChild(scnaelm);
			QDomElement scnselm = doc.createElement("size");
				QDomText scnstxt = doc.createTextNode(QString::number(separateBetweenChannelsAndNewsSize()));
			scnselm.appendChild(scnstxt);
		scnelm.appendChild(scnselm);
			QDomElement scnwelm = doc.createElement("width");
				QDomText scnwtxt = doc.createTextNode(QString::number(separateBetweenChannelsAndNewsWidth()));
			scnwelm.appendChild(scnwtxt);
		scnelm.appendChild(scnwelm);
	selm.appendChild(scnelm);
	QDomElement snelm = doc.createElement("newssep");
			if(separateBetweenNews())
				snelm.setAttribute("use", "true");
			else
				snelm.setAttribute("use", "false");
			QDomElement sncelm = doc.createElement("colour");
				sncelm.setAttribute("red", QString::number(newsSeparatorColour().red()));
				sncelm.setAttribute("green", QString::number(newsSeparatorColour().green()));
				sncelm.setAttribute("blue", QString::number(newsSeparatorColour().blue()));
		snelm.appendChild(sncelm);
			QDomElement snaelm = doc.createElement("align");
				QDomText snatxt = doc.createTextNode(QString::number(separateBetweenNewsAlign()));
			snaelm.appendChild(snatxt);
		snelm.appendChild(snaelm);
			QDomElement snselm = doc.createElement("size");
				QDomText snstxt = doc.createTextNode(QString::number(separateBetweenNewsSize()));
			snselm.appendChild(snstxt);
		snelm.appendChild(snselm);
			QDomElement snwelm = doc.createElement("width");
				QDomText snwtxt = doc.createTextNode(QString::number(separateBetweenNewsWidth()));
			snwelm.appendChild(snwtxt);
		snelm.appendChild(snwelm);
	selm.appendChild(snelm);
	
	elm.appendChild(selm);
		
	doc.appendChild(elm);
		
	QFile f(filename);
	if(!f.open(IO_WriteOnly)) {
		cerr << "COULD NOT OPEN FILE TO WRITE: " << filename << endl;
		return;
	}
		
	QTextStream t(&f);
	t << doc.toString();
	f.close();
}

void SchemeTree::makeCSS(QString & mStr)
{
	//Start on a clean line
	mStr.append(QString("\n"));
	//Add all of the body elements
	mStr.append(QString("BODY.BODY_KRSS {\n"));
	QString colour = QString::null;
	ColourConverter::makeCSSColour(backgroundColour(), colour);
	mStr.append(QString("\tbackground-color: ") + colour);
	if(useBackgroundImage()) {
		mStr.append(QString(";\n\tbackground-image: url(\"") + backgroundImageUrl().url() + QString("\")"));
		if(backgroundImageFixed())
			mStr.append(QString(";\n\tbackground-attachment: fixed"));
		else
			mStr.append(QString(";\n\tbackground-attachment: scroll"));
	}
	mStr.append(QString("\n}\n"));
	//Add all of the link elements
	mStr.append(QString("A.A_KRSS:link {\n"));
	colour = QString::null;
	ColourConverter::makeCSSColour(activeLinkColour(), colour);
	mStr.append(QString("\tcolor: ") + colour);
	mStr.append(QString("\n}\n"));
	mStr.append(QString("A.A_KRSS:visited {\n"));
	colour = QString::null;
	ColourConverter::makeCSSColour(visitedLinkColour(), colour);
	mStr.append(QString("\tcolor: ") + colour);
	mStr.append(QString("\n}\n"));
	
	mStr.append(QString("P.P_KRSS_CH_TITLE {\n"));
	colour = QString::null;
	ColourConverter::makeCSSColour(channelTitleColour(), colour);
	mStr.append(QString("\tcolor: ") + colour);
	mStr.append(QString(";\n\tfont-family: \"") + channelTitleFont().family() + QString("\""));
	if(channelTitleFont().italic())
		mStr.append(QString(";\n\tfont-style: italic"));
	else
		mStr.append(QString(";\n\tfont-style: normal"));
	if(channelTitleFont().bold())
		mStr.append(QString(";\n\tfont-weight: bold"));
	else
		mStr.append(QString(";\n\tfont-weight: normal"));
	mStr.append(QString(";\n\tfont-size: ") + QString::number(channelTitleFont().pointSize()) + QString("pt"));
	mStr.append(QString("\n}\n"));
	
	mStr.append(QString("P.P_KRSS_CH_DESC {\n"));
	colour = QString::null;
	ColourConverter::makeCSSColour(channelDescriptionColour(), colour);
	mStr.append(QString("\tcolor: ") + colour);
	mStr.append(QString(";\n\tfont-family: \"") + channelDescriptionFont().family() + QString("\""));
	if(channelDescriptionFont().italic())
		mStr.append(QString(";\n\tfont-style: italic"));
	else
		mStr.append(QString(";\n\tfont-style: normal"));
	if(channelDescriptionFont().bold())
		mStr.append(QString(";\n\tfont-weight: bold"));
	else
		mStr.append(QString(";\n\tfont-weight: normal"));
	mStr.append(QString(";\n\tfont-size: ") + QString::number(channelDescriptionFont().pointSize()) + QString("pt"));
	mStr.append(QString("\n}\n"));
	
	mStr.append(QString("P.P_KRSS_NW_TITLE {\n"));
	colour = QString::null;
	ColourConverter::makeCSSColour(newsTitleColour(), colour);
	mStr.append(QString("\tcolor: ") + colour);
	mStr.append(QString(";\n\tfont-family: \"") + newsTitleFont().family() + QString("\""));
	if(newsTitleFont().italic())
		mStr.append(QString(";\n\tfont-style: italic"));
	else
		mStr.append(QString(";\n\tfont-style: normal"));
	if(newsTitleFont().bold())
		mStr.append(QString(";\n\tfont-weight: bold"));
	else
		mStr.append(QString(";\n\tfont-weight: normal"));
	mStr.append(QString(";\n\tfont-size: ") + QString::number(newsTitleFont().pointSize()) + QString("pt"));
	mStr.append(QString("\n}\n"));
	
	mStr.append(QString("P.P_KRSS_NW_DESC {\n"));
	colour = QString::null;
	ColourConverter::makeCSSColour(newsDescriptionColour(), colour);
	mStr.append(QString("\tcolor: ") + colour);
	mStr.append(QString(";\n\tfont-family: \"") + newsDescriptionFont().family() + QString("\""));
	if(newsDescriptionFont().italic())
		mStr.append(QString(";\n\tfont-style: italic"));
	else
		mStr.append(QString(";\n\tfont-style: normal"));
	if(newsDescriptionFont().bold())
		mStr.append(QString(";\n\tfont-weight: bold"));
	else
		mStr.append(QString(";\n\tfont-weight: normal"));
	mStr.append(QString(";\n\tfont-size: ") + QString::number(newsDescriptionFont().pointSize()) + QString("pt"));
	mStr.append(QString("\n}\n"));
	
	mStr.append(QString("HR.HR_KRSS_NW {\n"));
	colour = QString::null;
	ColourConverter::makeCSSColour(newsSeparatorColour(), colour);
	mStr.append(QString("\tcolor: ") + colour);
	mStr.append(QString("\n}\n"));

	mStr.append(QString("HR.HR_KRSS_CH {\n"));
	colour = QString::null;
	ColourConverter::makeCSSColour(channelSeparatorColour(), colour);
	mStr.append(QString("\tcolor: ") + colour);
	mStr.append(QString("\n}\n"));
	
	mStr.append(QString("HR.HR_KRSS_CN {\n"));
	colour = QString::null;
	ColourConverter::makeCSSColour(channelNewsSeparatorColour(), colour);
	mStr.append(QString("\tcolor: ") + colour);
	mStr.append(QString("\n}\n"));
	
}
