/***************************************************************************
                          schemetree.h  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SCHEMETREE_H
#define SCHEMETREE_H


#include "schemecolours.h"
#include "schemegeneral.h"
#include "schemechannel.h"
#include "schemenews.h"
#include "schemeseparators.h"
/**
  *@author Chris Wallace
  */

class SchemeTree {
	public:
		SchemeTree();
		SchemeTree(const SchemeTree & tree);
		~SchemeTree();
		
		void operator = (const SchemeTree & tree);
		
		void setBackgroundColour(const QColor & c) {mColours.setBackgroundColour(c);}
		const QColor & backgroundColour(void) const {return mColours.backgroundColour();}
			
		void setActiveLinkColour(const QColor & c) {mColours.setActiveLinkColour(c);}
		const QColor & activeLinkColour(void) const {return mColours.activeLinkColour();}
				
		void setVisitedLinkColour(const QColor & c) {mColours.setVisitedLinkColour(c);}
		const QColor & visitedLinkColour(void) const {return mColours.visitedLinkColour();}
			
		void setChannelTitleColour(const QColor & c) {mColours.setChannelTitleColour(c);}
		const QColor & channelTitleColour(void) const {return mColours.channelTitleColour();}
			
		void setChannelDescriptionColour(const QColor & c) {mColours.setChannelDescriptionColour(c);}
		const QColor & channelDescriptionColour(void) const {return mColours.channelDescriptionColour();}
			
		void setNewsTitleColour(const QColor & c) {mColours.setNewsTitleColour(c);}
		const QColor & newsTitleColour(void) const {return mColours.newsTitleColour();}
		
		void setNewsDescriptionColour(const QColor & c) {mColours.setNewsDescriptionColour(c);}
		const QColor & newsDescriptionColour(void) const {return mColours.newsDescriptionColour();}
			
		void setChannelSeparatorColour(const QColor & c) {mColours.setChannelSeparatorColour(c);}
		const QColor & channelSeparatorColour(void) const {return mColours.channelSeparatorColour();}
			
		void setNewsSeparatorColour(const QColor & c) {mColours.setNewsSeparatorColour(c);}
		const QColor & newsSeparatorColour(void) const {return mColours.newsSeparatorColour();}
			
		void setChannelNewsSeparatorColour(const QColor & c) {mColours.setChannelNewsSeparatorColour(c);}
		const QColor & channelNewsSeparatorColour(void) const {return mColours.channelNewsSeparatorColour();}
		
		void setUseBackgroundImage(bool use) {mGeneral.setUseBackgroundImage(use);}
		bool useBackgroundImage(void) {return mGeneral.useBackgroundImage();}
		
		void setBackgroundImageUrl(const KURL & url) {mGeneral.setBackgroundImageUrl(url);}
		const KURL & backgroundImageUrl(void) const {return mGeneral.backgroundImageUrl();}
		
		void setBackgroundImageFixed(bool fixed) {mGeneral.setBackgroundImageFixed(fixed);}
		bool backgroundImageFixed(void) {return mGeneral.backgroundImageFixed();}
		
		void setTopMargin(unsigned int top) {mGeneral.setTopMargin(top);}
		unsigned int topMargin(void) {return mGeneral.topMargin();}
				
		void setLeftMargin(unsigned int left) {mGeneral.setLeftMargin(left);}
		unsigned int leftMargin(void) {return mGeneral.leftMargin();}
		
		void setBottomMargin(unsigned int bottom) {mGeneral.setBottomMargin(bottom);}
		unsigned int bottomMargin(void) {return mGeneral.bottomMargin();}
				
		void setRightMargin(unsigned int right) {mGeneral.setRightMargin(right);}
		unsigned int rightMargin(void) {return mGeneral.rightMargin();}
				
		void setChannelTitleFont(const QFont & font) {mChannel.setTitleFont(font);}
		const QFont & channelTitleFont(void) const {return mChannel.titleFont();}
		
		void setChannelDescriptionFont(const QFont & font) {mChannel.setDescriptionFont(font);}
		const QFont & channelDescriptionFont(void) const {return mChannel.descriptionFont();}
		
		void setChannelTitleAlign(unsigned int align) {mChannel.setTitleAlign(align);}
		unsigned int channelTitleAlign(void) {return mChannel.titleAlign();}
		
		void setChannelImageAlign(unsigned int align) {mChannel.setImageAlign(align);}
		unsigned int channelImageAlign(void) {return mChannel.imageAlign();}
		
		void setChannelDescriptionAlign(unsigned int align) {mChannel.setDescriptionAlign(align);}
		unsigned int channelDescriptionAlign(void) {return mChannel.descriptionAlign();}
		
		void setChannelTitleHeaderLevel(unsigned int level) {mChannel.setTitleLevel(level);}
		unsigned int channelTitleHeaderLevel(void) {return mChannel.titleLevel();}
		
		void setChannelImageBorder(unsigned int border) {mChannel.setImageBorder(border);}
		unsigned int channelImageBorder(void) {return mChannel.imageBorder();}
		
		void setNewsTitleFont(const QFont & font) {mNews.setTitleFont(font);}
		const QFont & newsTitleFont(void) const {return mNews.titleFont();}
		
		void setNewsTitleAlign(unsigned int align) {mNews.setTitleAlign(align);}
		unsigned int newsTitleAlign(void) {return mNews.titleAlign();}
		
		void setNewsTitleHeaderLevel(unsigned int level) {mNews.setTitleLevel(level);}
		unsigned int newsTitleHeaderLevel(void) {return mNews.titleLevel();}
		
		void setNewsDescriptionFont(const QFont & font) {mNews.setDescriptionFont(font);}
		const QFont & newsDescriptionFont(void) const {return mNews.descriptionFont();}
		
		void setNewsDescriptionAlign(unsigned int align) {mNews.setDescriptionAlign(align);}
		unsigned int newsDescriptionAlign(void) {return mNews.descriptionAlign();}
		
		void setSeparateBetweenChannels(bool sep) {mSeparators.setChannelSepUse(sep);}
		bool separateBetweenChannels(void) {return mSeparators.channelSepUse();}
		
		void setSeparateBetweenChannelsAlign(unsigned int align) {mSeparators.setChannelSepAlign(align);}
		unsigned int separateBetweenChannelsAlign(void) {return mSeparators.channelSepAlign();}
		
		void setSeparateBetweenChannelsSize(unsigned int size) {mSeparators.setChannelSepSize(size);}
		unsigned int separateBetweenChannelsSize(void) {return mSeparators.channelSepSize();}
		
		void setSeparateBetweenChannelsWidth(unsigned int width) {mSeparators.setChannelSepWidth(width);}
		unsigned int separateBetweenChannelsWidth(void) {return mSeparators.channelSepWidth();}
		
		void setSeparateBetweenChannelsAndNews(bool sep) {mSeparators.setChannelNewsSepUse(sep);}
		bool separateBetweenChannelsAndNews(void) {return mSeparators.channelNewsSepUse();}
		
		void setSeparateBetweenChannelsAndNewsAlign(unsigned int align) {mSeparators.setChannelNewsSepAlign(align);}
		unsigned int separateBetweenChannelsAndNewsAlign(void) {return mSeparators.channelNewsSepAlign();}
		
		void setSeparateBetweenChannelsAndNewsSize(unsigned int size) {mSeparators.setChannelSepSize(size);}
		unsigned int separateBetweenChannelsAndNewsSize(void) {return mSeparators.channelSepSize();}
		
		void setSeparateBetweenChannelsAndNewsWidth(unsigned int width) {mSeparators.setChannelNewsSepWidth(width);}
		unsigned int separateBetweenChannelsAndNewsWidth(void) {return mSeparators.channelNewsSepWidth();}
		
		void setSeparateBetweenNews(bool sep) {mSeparators.setNewsSepUse(sep);}
		bool separateBetweenNews(void) {return mSeparators.newsSepUse();}
		
		void setSeparateBetweenNewsAlign(unsigned int align) {mSeparators.setNewsSepAlign(align);}
		unsigned int separateBetweenNewsAlign(void) {return mSeparators.newsSepAlign();}
		
		void setSeparateBetweenNewsSize(unsigned int size) {mSeparators.setNewsSepSize(size);}
		unsigned int separateBetweenNewsSize(void) {return mSeparators.newsSepSize();}
		
		void setSeparateBetweenNewsWidth(unsigned int width) {mSeparators.setNewsSepWidth(width);}
		unsigned int separateBetweenNewsWidth(void) {return mSeparators.newsSepWidth();}
		
		void setMyChannelBarTextColour(const QColor & c) {mColours.setMyChannelBarTextColour(c);}
		const QColor & myChannelBarTextColour(void) {return mColours.myChannelBarTextColour();}
		
		void setMyChannelBarBackgroundColour(const QColor & c) {mColours.setMyChannelBarBackgroundColour(c);}
		const QColor & myChannelBarBackgroundColour(void) {return mColours.myChannelBarBackgroundColour();}
		
		void setMyChannelBarUseBackgroundImage(bool use) {mGeneral.setMyChannelBarUseBackgroundImage(use);}
		bool myChannelBarUseBackgroundImage(void) {return mGeneral.myChannelBarUseBackgroundImage();}
		
		void setMyChannelBarBackgroundImageUrl(const KURL & url) {mGeneral.setMyChannelBarBackgroundImageUrl(url);}
		const KURL & myChannelBarBackgroundImageUrl(void) {return mGeneral.myChannelBarBackgroundImageUrl();}
		
		void setMyChannelBarBackgroundImageFixed(bool fixed) {mGeneral.setMyChannelBarBackgroundImageFixed(fixed);}
		bool myChannelBarBackgroundImageFixed(void) {return mGeneral.myChannelBarBackgroundImageFixed();}
		
		void setMyChannelBarNewFeedColour(const QColor & c) {mColours.setMyChannelBarNewFeedColour(c);}
		const QColor & myChannelBarNewFeedColour(void) {return mColours.myChannelBarNewFeedColour();}
		
		void clear(void);
		
		void write(const QString & filename);
		
		void makeCSS(QString & mStr);
		
	private:
		SchemeColours mColours;
		SchemeGeneral mGeneral;
		SchemeChannel mChannel;
		SchemeNews mNews;
		SchemeSeparators mSeparators;
		
};

#endif
