/***************************************************************************
                          site.cpp  -  description
                             -------------------
    begin                : Sat Aug 4 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "site.h"

#include <iostream>
#include <stdlib.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qdir.h>
#include <qdatetime.h>

#include "rssparser.h"
#include "filterhandler.h"

Site::Site()
{
	mUsed = false;
	mName = mDescription = mFileNameUnParsed = mFileNameParsed = QString::null;
	mURL = KURL("");
	mAddedDateTime = QDateTime::currentDateTime();
}

Site::~Site()
{
}

void Site::operator = (const Site & site)
{
	mUsed = site.mUsed;
	mName = site.mName;
	mDescription = site.mDescription;
	mURL = site.mURL;
	mFileNameUnParsed = site.mFileNameUnParsed;
	mFileNameParsed = site.mFileNameParsed;
	mAddedDateTime = site.mAddedDateTime;
}

void Site::write(QDomDocument & doc, QDomElement & elm)
{
	
	QDomElement esite = doc.createElement("site");
	esite.setAttribute("year", QString::number(mAddedDateTime.date().year()) );
	esite.setAttribute("month", QString::number(mAddedDateTime.date().month()) );
	esite.setAttribute("day", QString::number(mAddedDateTime.date().day()) );
	esite.setAttribute("hour", QString::number(mAddedDateTime.time().hour()) );
	esite.setAttribute("minute", QString::number(mAddedDateTime.time().minute()) );
	esite.setAttribute("second", QString::number(mAddedDateTime.time().second()) );
	
	QDomElement eused = doc.createElement("used");
	QDomText tused;
	if(mUsed)
		tused = doc.createTextNode("yes");
	else
		tused = doc.createTextNode("no");
	eused.appendChild(tused);
	esite.appendChild(eused);
	
	QDomElement ename = doc.createElement("name");
	QDomText tname = doc.createTextNode(mName);
	ename.appendChild(tname);
	esite.appendChild(ename);
	
	QDomElement eurl = doc.createElement("url");
	if(mURL.url().isEmpty() || mURL.url().isNull()) {
		QDomText turl = doc.createTextNode("");
		eurl.appendChild(turl);
	}
	else {
		//cerr << mURL.url() << endl;
		QDomText turl = doc.createTextNode(mURL.url());
		eurl.appendChild(turl);
	}
	esite.appendChild(eurl);
	
	QDomElement edesc = doc.createElement("description");
	QDomText tdesc = doc.createTextNode(mDescription);
	edesc.appendChild(tdesc);
	esite.appendChild(edesc);
	
	QDomElement efname = doc.createElement("filename");
	QDomText tfname = doc.createTextNode(mFileNameParsed);
	efname.appendChild(tfname);
	esite.appendChild(efname);
	
	QDomElement efuname = doc.createElement("unparsed_filename");
	QDomText tfuname = doc.createTextNode(mFileNameUnParsed);
	efuname.appendChild(tfuname);
	esite.appendChild(efuname);
	
	elm.appendChild(esite);
}

void Site::makeFileName(void)
{
	QString tempName;
	QTextStream t(&tempName, IO_WriteOnly);
	QString sName = mName.lower();
	t <<  sName.stripWhiteSpace();
	t << QDateTime::currentDateTime().date().year();
	t << QDateTime::currentDateTime().date().month();
	t << QDateTime::currentDateTime().date().day();
	t << QDateTime::currentDateTime().time().hour();
	t << QDateTime::currentDateTime().time().minute();
	t << QDateTime::currentDateTime().time().second();
	t << 1 + (int) (1000.0*rand()/(RAND_MAX+1.0));
	QString fname = tempName.stripWhiteSpace() + QString(".rss");
	QFile f(QDir::homeDirPath() + QString("/.krss/feeds/unparsed/") + fname);
	if(f.exists()) {
		makeFileName();
		return;
	}
	mFileNameUnParsed = QDir::homeDirPath() + QString("/.krss/feeds/unparsed/") + fname;
	mFileNameParsed = QDir::homeDirPath() + QString("/.krss/feeds/parsed/") + fname;
}

void Site::displayNews(QString & mStr, SchemeTree & tree, FilterHandler & filters, const QString & buttonText, KIconView *mIcons, int imagex, int imagey)
{
	RSSParser::makeNews(mName, mFileNameParsed, mStr, tree, filters, buttonText, mIcons, imagex, imagey);
}
