/***************************************************************************
                          site.h  -  description
                             -------------------
    begin                : Sat Aug 4 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SITE_H
#define SITE_H

#include <qstring.h>
#include <kurl.h>
#include <qdom.h>
#include <iostream>
#include <qdatetime.h>
#include <kiconview.h>

#include "schemetree.h"

class FilterHandler;
/**
  *@author Chris Wallace
  */

class Site {
	public:
		Site();
		Site(const Site & site) {
			operator=(site);
		}
		~Site();
		
		void operator=(const Site & site);
		
		bool used() {return mUsed;}
		void setUsed(bool u) {mUsed = u;}
		
		const QString & name() const {return mName;}
		void setName(const QString & name) {mName = name;}
		
		const QString & description() const {return mDescription;}
		void setDescription(const QString & description) {mDescription = description;}
		
		const KURL & URL() const {return mURL;}
		void setURL(const KURL & url) {mURL = url;}
			//cerr << mURL.url() << endl;
		//}
		
		const QString & fileNameUnParsed(void) const {return mFileNameUnParsed;}
		void setFileNameUnParsed(const QString & filename) {mFileNameUnParsed = filename;}
		
		const QString & fileNameParsed(void) const {return mFileNameParsed;}
		void setFileNameParsed(const QString & filename) {mFileNameParsed = filename;}
		
		void write(QDomDocument & doc, QDomElement & elm);
		
		void makeFileName(void);
		
		void displayNews(QString & mStr, SchemeTree & tree, FilterHandler & filters, const QString & buttonText, KIconView *mIcons, int imagex, int imagey);
		
		void setAddedDateTime(const QDateTime & datetime) {mAddedDateTime = datetime;}
		void setAddedDate(const QDate & date) {mAddedDateTime.setDate(date);}
		void setAddedTime(const QTime & time) {mAddedDateTime.setTime(time);}
		
		const QDateTime & addedDateTime(void) const {return mAddedDateTime;}
	private:
		bool mUsed;
		QString mName;
		QString mDescription;
		KURL mURL;
		QString mFileNameUnParsed;
		QString mFileNameParsed;
		QDateTime mAddedDateTime;
};

#endif
