/***************************************************************************
                          sitehandler.h  -  description
                             -------------------
    begin                : Sat Aug 4 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SITEHANDLER_H
#define SITEHANDLER_H

#include <qlist.h>
#include <qxml.h>
#include <qstring.h>
#include <qqueue.h>
#include <kconfig.h>
#include <kapp.h>
#include <qprogressbar.h>
#include <kiconview.h>

#include "site.h"
#include "filetransfer.h"

class KListView;

class MyChannelBar;

/**
  *@author Chris Wallace
  */

class SiteHandler : QXmlDefaultHandler{
	public:
		SiteHandler();
		~SiteHandler();
		
		void clearSites(void) {
			mSites.clear();
		}
		
		void writeSites(void);
		void readSites(void);
		void readSites(const QString & filename, bool clear = true);
		
		void displaySites(KListView *lview);
		void getSites(KListView *lview);
		
		void makeQueue(QQueue<FileTransfer> & files);
		void makeQueue(QQueue<FileTransfer> & files, const QString & unparsedfilename);
		
		void makeSiteList(QList<Site> & rsssites);
		
		bool displayNews(KConfig *mConfig, QString & mStr, QProgressBar * mProgress, KApplication * mKApp, MyChannelBar *mIcons);
		
		bool isDuplicate(Site *s);
		
		bool isDuplicate(const KURL & url);
		
		void addSite(Site *site);
		
		void fixSiteFile_2_2(void);
		
	protected:
		bool startDocument(void);
		bool endDocument(void);
		bool startElement(const QString &, const QString &, const QString &, const QXmlAttributes &);
		bool endElement(const QString &, const QString &, const QString &);
		bool warning(const QXmlParseException &);
		bool error(const QXmlParseException &);
		bool fatalError(const QXmlParseException &);
		bool characters(const QString &);
		
	private:
		bool mReadingSites;
		bool mReadingSite;
		bool mReadingUsed;
		bool mReadingName;
		bool mReadingDescription;
		bool mReadingURL;
		bool mReadingFileNameUnParsed;
		bool mReadingFileNameParsed;
		
		bool mDontClear;
		QList<Site> mSites;
		Site *mSite;
		
};

#endif
