/***************************************************************************
                          syncdialog.cpp  -  description
                             -------------------
    begin                : Thu Aug 9 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "syncdialog.h"

#include <iostream>

#include <qtabwidget.h>
#include <qprogressbar.h>
#include <qlabel.h>
#include <qdatetime.h>
#include <qdir.h>

#include <klocale.h>

SyncDialog::SyncDialog(KConfig *config, QWidget *parent, const char *name )
: KDialogBase(parent,name,true,i18n("Sharing Feeds"),User1|Close,Close,true,i18n("Skip"))
{
	mConfig = config;
	
	sd_bend = new SyncDialogBackEnd(this, "sd_bend");
	setMainWidget(sd_bend);
	connect(&mSocket, SIGNAL(hostFound()), this, SLOT(slotHostFound()));
	connect(&mSocket, SIGNAL(connected()), this, SLOT(slotConnected()));
	connect(&mSocket, SIGNAL(connectionClosed()), this, SLOT(slotConnectionClosed()));
	connect(&mSocket, SIGNAL(readyRead()), this, SLOT(slotReadyRead()));
	connect(&mSocket, SIGNAL(error(int)), this, SLOT(slotError(int)));
	SiteHandler sh;
	sh.readSites();
	sh.makeSiteList(mSites);
	mTotalNumberOfFiles = mSites.count() + 1;
	mHaveNumberOfFiles = 0;
	mUpload = true;
	mHost = QString("127.0.0.1");
	mPort = 80;
	mHaveError = false;
	mHaveData = false;
	enableButton(Close, false);
	cerr << "Done Setting Up!" << endl;
	setupNextUpload();
}

SyncDialog::~SyncDialog()
{
}

void SyncDialog::syncFeeds(KConfig *config)
{
	SyncDialog sd(config);
	sd.exec();
}

void SyncDialog::setupDownload(void)
{
	QString clientutc;
	QString datetime;
	int year = QDateTime::currentDateTime().date().year();
	int month = QDateTime::currentDateTime().date().month();
	int day = QDateTime::currentDateTime().date().day();
	int hour = QDateTime::currentDateTime().time().hour();
	int minute = QDateTime::currentDateTime().time().minute();
	int second = QDateTime::currentDateTime().time().second();
	datetime.append(QString::number(year));
	if(month < 10)
		datetime.append(QChar('0'));
	datetime.append(QString::number(month));
	if(day < 10)
		datetime.append(QChar('0'));
	datetime.append(QString::number(day));
	if(hour < 10)
		datetime.append(QChar('0'));
	datetime.append(QString::number(hour));
	if(minute < 10)
		datetime.append(QChar('0'));
	datetime.append(QString::number(minute));
	if(second < 10)
		datetime.append(QChar('0'));
	datetime.append(QString::number(second));
	
	mHaveData = false;
	mFileUrl = KURL(QString("http://") + mHost + QString("/getfeeds.php?clientutc=0") + QString("&datetime=") + datetime);
	cerr << mFileUrl.url() << endl;
	mHaveNumberOfFiles++;
	mSocket.connectToHost(mHost, mPort);
	displayProgress();
}

void SyncDialog::setupNextUpload(void)
{
	Site *s = mSites.first();
	if(!s) {
		mUpload = false;
		setupDownload();
		return;
	}
	
	sd_bend->mActionText->setText(QString("Uploading Feed: ") + s->name());
	
	mConfig->setGroup(QString("Feed Sync"));
	bool mHaveSynced = mConfig->readBoolEntry(QString("Have Synced"), false);
	if(mHaveSynced) {
		const QDateTime & ldt = mConfig->readDateTimeEntry(QString("Last Sync"));
		const QDateTime & sdt = s->addedDateTime();
	
		cerr << "Site Was Added:" << sdt.date().year() << sdt.date().month() << sdt.date().day() << sdt.time().hour() << sdt.time().minute() << sdt.time().second() << endl;
		cerr << "Last Sync:" << ldt.date().year() << ldt.date().month() << ldt.date().day() << ldt.time().hour() << ldt.time().minute() << ldt.time().second() << endl;
		if(sdt < ldt) {
			mSites.removeFirst();
			mHaveNumberOfFiles++;
			displayProgress();
			setupNextUpload();
			return;
		}
	}
	mFileUrl = KURL(QString("http://") + mHost + QString("/addfeed.php?feedname=") + KURL::encode_string(s->name()) + QString("&feedurl=") + KURL::encode_string(s->URL().url()) + QString("&feeddescription=") + KURL::encode_string(s->description()));
	cerr << mFileUrl.url() << endl;
	mHaveNumberOfFiles++;
	mSocket.connectToHost(mHost, mPort);
	mSites.removeFirst();
	displayProgress();
}

void SyncDialog::slotHostFound(void)
{
	cerr << "Host Found: " << mHost << endl;
}

void SyncDialog::slotConnected(void)
{
	cerr << "Connected to " << mHost << endl;
	if(mUpload) {
		QString getcmd = QString("GET ") + mFileUrl.url() + QString("\r\n");
		if(mSocket.writeBlock(getcmd, getcmd.length()) < 0) {
			sd_bend->mErrorList->insertItem(i18n("An error occured when trying to write ") + getcmd);
			mSocket.close();
		}
	}
	else {
		QString getcmd = QString("GET ") + mFileUrl.url() + QString("\r\n");
		if(mSocket.writeBlock(getcmd, getcmd.length()) < 0) {
			sd_bend->mErrorList->insertItem(i18n("An error occured when trying to write ") + getcmd);
			mSocket.close();
		}
	}
}

void SyncDialog::slotConnectionClosed(void)
{
	cerr << "Connection to " << mHost << " was closed" << endl;
	if(mUpload)
		setupNextUpload();
	else {
		SiteHandler sh;
		sh.readSites();
		sh.readSites(QDir::homeDirPath() + QString("/.krss/tempsites.xml"), false);
		sh.writeSites();
		cerr << "Done" << endl;
		QDir d;
		d.remove(QDir::homeDirPath() + QString("/.krss/tempsites.xml"),true);
		mDone = true;
		enableButton(Close, true);
		if(!mHaveError)
			accept();
	}
}

void SyncDialog::slotReadyRead(void)
{
	cerr << "Received Data" << endl;
	if(mUpload) {
		cerr << "We should not be receiving any date now!" << endl;
		while(!mSocket.atEnd()) {
			cerr << QChar(mSocket.getch());
		}
		cerr << endl;
	}
	else {
		if(!mHaveData) {
			mHaveData = true;
			QFile f(QDir::homeDirPath() + QString("/.krss/tempsites.xml"));
			if(!f.open(IO_WriteOnly)) {
				cerr << "Could not open file: " << QDir::homeDirPath() + QString("/.krss/tempsites.xml") << " for writing!" << endl;
				while(!mSocket.atEnd()) {
					cerr << QChar(mSocket.getch());
				}
				cerr << endl;			
			}
			QTextStream t(&f);
			while(!mSocket.atEnd()) {
				t << QChar(mSocket.getch());
			}
			f.close();
		}
		else {
			QFile f(QDir::homeDirPath() + QString("/.krss/tempsites.xml"));
			if(!f.open(IO_WriteOnly|IO_Append)) {
				cerr << "Could not open file: " << QDir::homeDirPath() + QString("/.krss/tempsites.xml") << " for writing!" << endl;
				while(!mSocket.atEnd()) {
					cerr << QChar(mSocket.getch());
				}
				cerr << endl;			
			}
			QTextStream t(&f);
			while(!mSocket.atEnd()) {
				t << QChar(mSocket.getch());
			}
			f.close();
		}
	}
}

void SyncDialog::slotError(int ec)
{
	switch(ec) {
		case QSocket::ErrConnectionRefused:
			sd_bend->mErrorList->insertItem(i18n("Connection to ") + mHost + QString(":") + QString::number(mPort) + i18n(" was refused"));
			break;
		case QSocket::ErrHostNotFound:
			sd_bend->mErrorList->insertItem(i18n("Host ") + mHost + QString(":") + QString::number(mPort) + i18n(" was not found"));
			break;
		case QSocket::ErrSocketRead:
			sd_bend->mErrorList->insertItem(i18n("An error occured while reading from ") + mHost + QString(":") + QString::number(mPort));
			break;
		default:
			sd_bend->mErrorList->insertItem(i18n("An unknown error has occured, ") + mHost + QString(":") + QString::number(mPort));
			break;
	}
	mHaveError = true;
	sd_bend->mTab->setCurrentPage(1);
	if(mUpload)
		setupNextUpload();
}

void SyncDialog::displayProgress(void)
{
	if(mTotalNumberOfFiles == 0) {
		sd_bend->mProgress->setProgress(100);
	}
	
	sd_bend->mProgress->setProgress((100*mHaveNumberOfFiles)/mTotalNumberOfFiles);
}	
