/***************************************************************************
                          syncdialog.h  -  description
                             -------------------
    begin                : Thu Aug 9 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SYNCDIALOG_H
#define SYNCDIALOG_H

#include <qwidget.h>
#include <kdialogbase.h>
#include <kconfig.h>

#include <qsocket.h>
#include <qlist.h>

#include "site.h"
#include "sitehandler.h"

#include "syncdialogbackend.h"

/**
  *@author Chris Wallace
  */

class SyncDialog : public KDialogBase  {
   Q_OBJECT
	public:
		SyncDialog(KConfig *config, QWidget *parent=0, const char *name=0);
		~SyncDialog();
		
		static void syncFeeds(KConfig *config);
		
	protected slots:
		void slotHostFound(void);
		void slotConnected(void);
		void slotConnectionClosed(void);
		void slotReadyRead(void);
		void slotError(int ec);
		
		void slotClose(void) {
			if(mDone)
				accept();
		}
		
		void slotUser1(void) {
			mSocket.close();
			if(mUpload)
				setupNextUpload();
			else
				mDone = true;
				enableButton(Close, true);
		}
		
	protected:
		void setupNextUpload(void);
		void setupDownload(void);
		void displayProgress(void);
		
	private:
		KConfig *mConfig;
		QSocket mSocket;
		QList<Site> mSites;
		SyncDialogBackEnd *sd_bend;
		QString mHost;
		int mPort;
		KURL mFileUrl;
		bool mUpload;
		int mTotalNumberOfFiles;
		int mHaveNumberOfFiles;
		bool mHaveError;
		bool mHaveData;
		bool mDone;
		
};

#endif
