/***************************************************************************
                          transferdialog.cpp  -  description
                             -------------------
    begin                : Sat Aug 4 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "transferdialog.h"

#include <qlabel.h>
#include <qprogressbar.h>
#include <qgroupbox.h>
#include <qdatastream.h>
#include <qlayout.h>
#include <qfileinfo.h>

#include <klocale.h>
#include <kio/job.h>
#include <kapp.h>

#include "sitehandler.h"
#include "rssparser.h"

TransferDialog::TransferDialog(SiteHandler * sitehandler, QWidget *parent, const char *name )
: KDialogBase(parent,name,false,i18n("Updating Feeds"),Details|User1|Close,Close,true,i18n("Skip"))
{
	mSiteHandler = sitehandler;
	
	td_bend = new TransferDialogBackEnd(this, "td_bend");
	
	QGroupBox *mDetails = new QGroupBox(this, "mFrame");
	mDetails->setTitle(i18n("Errors"));
	QVBoxLayout *flay = new QVBoxLayout(mDetails);
	mErrorList = new KListBox(mDetails, "mDetails");
	mErrorList->setMinimumHeight(150);
	flay->addWidget(mErrorList);
		
	setMainWidget(td_bend);
	setDetailsWidget(mDetails);
	mHaveError = mDone = mParse = mHaveData = false;
	enableButton(Close, false);
	setButtonText(Details, i18n("Errors"));
}

TransferDialog::~TransferDialog()
{
}

void TransferDialog::getFeeds(SiteHandler * sitehandler, const QString & unparsedfilename)
{
	TransferDialog *td = new TransferDialog(sitehandler);
	if(td->loadSites(unparsedfilename))
		td->show();
		
	KApplication * app = KApplication::kApplication();
	while(!td->isDone()) {app->processEvents(100);}
}

void TransferDialog::getFeeds(SiteHandler * sitehandler)
{
	TransferDialog *td = new TransferDialog(sitehandler);
	if(td->loadSites())
	 td->show();
	
	KApplication * app = KApplication::kApplication();
	while(!td->isDone()) {app->processEvents(100);}
}

bool TransferDialog::loadSites(void)
{
	if(!mSiteHandler)
		return false;
		
	mSiteHandler->makeQueue(files);
	mTotalNumberOfFiles = files.count()*2;
	mHaveNumberOfFiles = 0;
	if(mTotalNumberOfFiles == 0)
		return false;
	setupNextFile();
	return true;
}

bool TransferDialog::loadSites(const QString & unparsedfilename)
{
	if(!mSiteHandler)
		return false;
	
	mSiteHandler->makeQueue(files, unparsedfilename);
	mTotalNumberOfFiles = files.count()*2;
	mHaveNumberOfFiles = 0;
	if(mTotalNumberOfFiles == 0)
		return false;
	setupNextFile();
	return true;
}

void TransferDialog::setupNextFile(void)
{
	if(mParse) {
		if(!(mDstFile.isEmpty() || mDstFile.isNull())) {
			QFileInfo file(mDstFile);
			if(file.lastModified() >= mStartDateTime) {
				fixRSSSpaceProblem();		//The file gets copied from mDstFile to mFinalDstFile here
				KURL oldUrl, newUrl;
				RSSParser::isNew(mDstFile, true);
				if(RSSParser::parseFile(mFinalDstFile, true, oldUrl, newUrl)) {
					if(!oldUrl.isLocalFile() && newUrl.isLocalFile()) {
						FileTransfer *ft = new FileTransfer();
						ft->setURL(oldUrl);
						ft->setDestination(newUrl.path());
						ft->setIsFeed(false);
						ft->setFeedName(td_bend->mFeedName->text());
						files.enqueue(ft);
					}
				}
				else {
					mHaveNumberOfFiles++;
				}
			}
		}
	}

	FileTransfer * ft = files.dequeue();
	if(!ft) {
		mDone = true;
		enableButton(Close, true);
		enableButton(User1, false);
		mHaveNumberOfFiles = mTotalNumberOfFiles;
		displayProgress();
		if(!mHaveError)
			accept();
		else
			setDetails(true);
		return;
	}
	if(!ft->URL().isValid()) {
		mErrorList->insertItem(i18n("URL ") + ft->URL().url() + i18n(" is not valid"));
		setupNextFile();
		return;
	}
	
	mFeedName = ft->feedName();
	
	mParse = ft->isFeed();
	mSrcFile = ft->URL().url();
	mDstFile = ft->destination();
	mFinalDstFile = ft->finalDestination();
	KURL dsturl;
	dsturl.setPath(mDstFile);
	//cerr << "Next File: " << mSrcFile << QString(" -> ") << mDstFile << endl;
	td_bend->mFeedName->setText(ft->feedName());
	if(ft->URL().url().length() > 55) {
		QString left = ft->URL().url().left(32);
		QString right = ft->URL().url().right(20);
		td_bend->mCurrentFile->setText(left + QString("...") + right);
	}
	else
		td_bend->mCurrentFile->setText(ft->URL().url());
		
	mHaveData = false;
	mHaveNumberOfFiles++;
	displayProgress();
	mStartDateTime = QDateTime::currentDateTime();
	mTJob = KIO::file_copy(ft->URL(), dsturl, -1, true, false, false);
	connect(mTJob, SIGNAL(result(KIO::Job *)), this, SLOT(slotResult(KIO::Job *)));
}

void TransferDialog::slotResult(KIO::Job *job)
{
	if(!job)
		return;
		
	if(job->error() != 0) {
		mErrorList->insertItem(i18n("Error: (") + mFeedName + QString(") ") + job->errorString());
		mHaveError = true;
		RDFTree tree;
		tree.setChannelTitle(mFeedName);
		tree.setChannelDescription(i18n("Error: ") + job->errorString());
		tree.write(mDstFile);
	}
	
	/** lets try deleting the job **/
	/**
	Nope, the job will be deleted by KDE
	
	delete job;
	job = 0;
	
	**/
	
	setupNextFile();				
}

void TransferDialog::displayProgress(void)
{
	if(mTotalNumberOfFiles == 0) {
		td_bend->mProgress->setProgress(100);
	}
	
	td_bend->mProgress->setProgress((100*mHaveNumberOfFiles)/mTotalNumberOfFiles);
}	

void TransferDialog::fixRSSSpaceProblem(void)
{
	QFile fr(mDstFile);
	if(!fr.open(IO_ReadOnly)) return;
	
	QFile fw(mFinalDstFile);
	if(!fw.open(IO_WriteOnly)) return;
	
	QTextStream tr(&fr);
	QTextStream tw(&fw);
	
	tw << tr.read().simplifyWhiteSpace();
	
	fr.close();
	fw.close();
}
