/***************************************************************************
                          transferdialog.h  -  description
                             -------------------
    begin                : Sat Aug 4 2001
    copyright            : (C) 2001 by Chris Wallace
    email                : ranchhard@netflash.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef TRANSFERDIALOG_H
#define TRANSFERDIALOG_H

#include <qwidget.h>
#include <qqueue.h>
#include <qdatetime.h>

#include <kdialogbase.h>
#include <klocale.h>
#include <kio/jobclasses.h>

#include "transferdialogbackend.h"
#include "filetransfer.h"
#include "rdftree.h"
/**
  *@author Chris Wallace
  */

class KListBox;

class SiteHandler;

class TransferDialog : public KDialogBase  {
   Q_OBJECT
	public:
		~TransferDialog();
		static void getFeeds(SiteHandler * sitehandler);
		static void getFeeds(SiteHandler * sitehandler, const QString & unparsedfilename);
		bool loadSites(void);
		bool loadSites(const QString & uparsedfilename);
		
	protected:
		TransferDialog(SiteHandler * sitehandler, QWidget *parent=0, const char *name=0);
		void setupNextFile(void);
		void displayProgress(void);
		
		void fixRSSSpaceProblem(void);
		
		
		bool isDone(void) {return mDone;}
		
	protected slots:		
		void slotResult(KIO::Job *);
		
		void slotClose(void) {
			if(mDone)
				accept();
		}
		
		void slotUser1(void) {
			if(mTJob)
				mTJob->kill(true);
				
			if(mParse) {
				RDFTree tree;
				tree.setChannelTitle(mFeedName);
				tree.setChannelDescription(i18n("Warning: You have skipped this feed."));
				tree.write(mDstFile);
			}
			setupNextFile();
		}
		
			
	private:
		SiteHandler *mSiteHandler;
		TransferDialogBackEnd *td_bend;
		KListBox *mErrorList;
		QQueue<FileTransfer> files;
		QString mSrcFile;					//Source File, ie, /rss/feed/news
		QString mDstFile;					//Destination File, ie /home/chris/.krss/feeds/slashdot
		QString mFinalDstFile;		//Where the file should end up
		QString mFeedName;
		KIO::FileCopyJob *mTJob;
		bool mHaveError;
		bool mDone;
		bool mParse;
		bool mHaveData;
		unsigned int mTotalNumberOfFiles;
		unsigned int mHaveNumberOfFiles;
		QDateTime mStartDateTime;
};

#endif
